/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.view.Surface;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.EGLUtil;
import com.tencent.xcast.GLES20IdImpl;
import com.tencent.xcast.GLId;
import com.tencent.xcast.RefCountDelegate;
import com.tencent.xcast.RefCounted;
import java.util.Locale;

public class SurfaceTextureHolder
extends RefCountDelegate {
    private static final GLId GLID = new GLES20IdImpl();
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private int[] mOesTextureId = new int[1];
    private final EGLCoreContext mContext;
    private EventCallback mEventCallback;
    private TextureDestructorRunner mTextureDestructor;

    @AnyThread
    public SurfaceTextureHolder(int n2, int n3, @NonNull EventCallback eventCallback, @NonNull TextureDestructorRunner textureDestructorRunner) {
        this.mContext = null;
        this.mEventCallback = eventCallback;
        this.mTextureDestructor = textureDestructorRunner;
        this.mOesTextureId[0] = GLID.generateTexture();
        GLID.setTextureParameters(this.mOesTextureId[0], 36197, 33984);
        if (Platform.isLogLevel(5)) {
            Platform.logInfo(String.format(Locale.CHINA, "Create.texture.%d", this.mOesTextureId[0]));
        }
        this.mSurfaceTexture = new SurfaceTexture(this.mOesTextureId[0]);
        this.mSurfaceTexture.setDefaultBufferSize(n2, n3);
        this.mSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                EventCallback eventCallback = SurfaceTextureHolder.this.mEventCallback;
                if (eventCallback != null) {
                    eventCallback.onFrameAvailable(SurfaceTextureHolder.this, surfaceTexture);
                }
            }
        });
    }

    @AnyThread
    public SurfaceTextureHolder(int n2, int n3, @NonNull EventCallback eventCallback, @NonNull EGLCoreContext eGLCoreContext) {
        int n4;
        eGLCoreContext.retain();
        boolean bl = eGLCoreContext.isCurrentContext();
        if (!bl && (n4 = eGLCoreContext.makeCurrent()) != 12288) {
            eGLCoreContext.release();
            String string = String.format(Locale.CHINA, "makeCurrent.failed.%s", EGLUtil.getEglErrorString(n4));
            Platform.logError(string);
            throw new IllegalArgumentException(string);
        }
        this.mContext = eGLCoreContext;
        this.mEventCallback = eventCallback;
        this.mTextureDestructor = null;
        this.mOesTextureId[0] = GLID.generateTexture();
        GLID.setTextureParameters(this.mOesTextureId[0], 36197, 33984);
        if (Platform.isLogLevel(5)) {
            Platform.logInfo(String.format(Locale.CHINA, "glGenTextures.%d", this.mOesTextureId[0]));
        }
        this.mSurfaceTexture = new SurfaceTexture(this.mOesTextureId[0]);
        this.mSurfaceTexture.setDefaultBufferSize(n2, n3);
        this.mSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                EventCallback eventCallback = SurfaceTextureHolder.this.mEventCallback;
                if (eventCallback != null) {
                    eventCallback.onFrameAvailable(SurfaceTextureHolder.this, surfaceTexture);
                }
            }
        });
        if (!bl) {
            eGLCoreContext.detachCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void updateTextureImage() {
        if (this.mSurfaceTexture != null) {
            SurfaceTextureHolder surfaceTextureHolder = this;
            synchronized (surfaceTextureHolder) {
                if (this.mSurfaceTexture == null) {
                    return;
                }
                if (this.mContext != null) {
                    EGLCoreContext eGLCoreContext = this.mContext;
                    synchronized (eGLCoreContext) {
                        int n2;
                        boolean bl = this.mContext.isCurrentContext();
                        if (!bl && (n2 = this.mContext.makeCurrent()) != 12288) {
                            Platform.logError(String.format(Locale.CHINA, "makeCurrent.failed.%s", EGLUtil.getEglErrorString(n2)));
                            return;
                        }
                        this.mSurfaceTexture.updateTexImage();
                        if (!bl) {
                            this.mContext.detachCurrent();
                        }
                    }
                } else {
                    this.mSurfaceTexture.updateTexImage();
                }
            }
        }
    }

    @AnyThread
    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    @AnyThread
    public Surface getSurface() {
        if (this.mSurface == null) {
            this.mSurface = new Surface(this.mSurfaceTexture);
        }
        return this.mSurface;
    }

    @AnyThread
    public int getTextureId() {
        return this.mOesTextureId != null ? this.mOesTextureId[0] : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    public int release() {
        int n2 = super.release();
        if (n2 > 0) {
            return n2;
        }
        if (Platform.isDebugBuild) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.release.mSurfaceTexture.%h.mTextureDestructor.%h.mContext.%h", this, this.mSurfaceTexture, this.mTextureDestructor, this.mContext));
        }
        if (this.mEventCallback != null) {
            this.mEventCallback.onRelease(this);
            this.mEventCallback = null;
        }
        RefCounted refCounted = this;
        synchronized (refCounted) {
            if (this.mSurfaceTexture != null) {
                this.mSurfaceTexture.release();
                this.mSurfaceTexture = null;
            }
        }
        if (this.mOesTextureId != null) {
            if (this.mTextureDestructor != null) {
                this.mTextureDestructor.post(new TextureDestructor(this.mOesTextureId));
                this.mTextureDestructor = null;
            } else {
                refCounted = this.mContext;
                synchronized (refCounted) {
                    boolean bl = this.mContext.isCurrentContext();
                    int n3 = 12288;
                    if (!bl && (n3 = this.mContext.makeCurrent()) != 12288) {
                        Platform.logError(String.format(Locale.CHINA, "makeCurrent.failed.%s", EGLUtil.getEglErrorString(n3)));
                    }
                    if (n3 == 12288) {
                        if (Platform.isLogLevel(5)) {
                            Platform.logInfo(String.format(Locale.CHINA, "glDeleteTextures.%d", this.mOesTextureId[0]));
                        }
                        GLID.glDeleteTextures(this.mOesTextureId.length, this.mOesTextureId, 0);
                    } else if (Platform.isLogLevel(5)) {
                        Platform.logInfo(String.format(Locale.CHINA, "makeCurrent.fail.texture.%d", this.mOesTextureId[0]));
                    }
                    if (!bl) {
                        this.mContext.detachCurrent();
                    }
                    this.mContext.release();
                }
            }
            this.mOesTextureId = null;
        }
        return n2;
    }

    private static class TextureDestructor
    implements Runnable {
        @NonNull
        final int[] mTexture;

        @AnyThread
        TextureDestructor(@NonNull int[] nArray) {
            this.mTexture = nArray;
        }

        @Override
        @WorkerThread
        public void run() {
            GLID.glDeleteTextures(this.mTexture.length, this.mTexture, 0);
            if (Platform.isLogLevel(5)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("glDeleteTextures");
                for (int n2 : this.mTexture) {
                    stringBuilder.append('.');
                    stringBuilder.append(n2);
                }
                stringBuilder.append('.');
                Platform.logInfo(stringBuilder.toString());
            }
        }
    }

    public static class HandlerDestructorRunner
    implements TextureDestructorRunner {
        @NonNull
        Handler mHandler;

        public HandlerDestructorRunner(@NonNull Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void post(@NonNull Runnable runnable) {
            if (Looper.myLooper() == this.mHandler.getLooper()) {
                runnable.run();
            } else {
                this.mHandler.post(runnable);
            }
        }
    }

    public static interface TextureDestructorRunner {
        public void post(@NonNull Runnable var1);
    }

    public static interface EventCallback {
        public void onFrameAvailable(SurfaceTextureHolder var1, SurfaceTexture var2);

        public void onRelease(SurfaceTextureHolder var1);
    }
}

