/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.avlab.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.text.TextUtils;
import com.tencent.avlab.utils.QLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SoUtil {
    private static final String TAG = "SoUtil";
    private static final String SO_SP = "so_sp";
    private static final String KEY_APK_SIZE = "key_apk_size";
    private static final String KEY_APP_VERSION = "key_app_version";
    private static final String KEY_APK_UPDATE_TIME = "key_apk_update_time";
    private static Context ctx = null;
    private static boolean copySoFromAssets = false;
    private static int extractSoError = 0;
    public static String customLibPath = null;

    public static void setAppContext(Context context) {
        ctx = context;
    }

    public static Context getAppContext() {
        return ctx;
    }

    public static void releaseAppContext() {
        ctx = null;
    }

    public static void setCopySoInfo(boolean bl) {
        copySoFromAssets = bl;
    }

    public static boolean getCopySoInfo() {
        return copySoFromAssets;
    }

    public static boolean loadSo(String string) {
        block10: {
            if (customLibPath != null) {
                try {
                    System.load(customLibPath + "/lib" + string + ".so");
                    return true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (!QLog.isColorLevel()) break block10;
                    QLog.d(TAG, 0, "loadSo from customLibPath(" + customLibPath + ") failed: " + unsatisfiedLinkError.getMessage());
                }
            }
        }
        if (SoUtil.getCopySoInfo() && SoUtil.LoadExtractedSo(string)) {
            return true;
        }
        try {
            System.loadLibrary(string);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (QLog.isColorLevel()) {
                QLog.d(TAG, 0, "loadSo from APP Path failed: " + unsatisfiedLinkError.getMessage());
            }
            try {
                System.load("/system/lib/lib" + string + ".so");
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 0, "loadSo from System Path failed: " + unsatisfiedLinkError2.getMessage());
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int extractAVModulesFromAssets() {
        SharedPreferences sharedPreferences = ctx.getSharedPreferences(SO_SP, 0);
        PackageManager packageManager = ctx.getPackageManager();
        ApplicationInfo applicationInfo = null;
        PackageInfo packageInfo = null;
        String string = sharedPreferences.getString(KEY_APP_VERSION, "");
        long l2 = sharedPreferences.getLong(KEY_APK_SIZE, -1L);
        long l3 = sharedPreferences.getLong(KEY_APK_UPDATE_TIME, -1L);
        boolean bl = true;
        String string2 = "";
        long l4 = -1L;
        long l5 = -1L;
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "local version = " + string + ", lastUpdateApkSize = " + l2 + ", lastUpdateApkTime = " + l3);
        }
        try {
            applicationInfo = packageManager.getApplicationInfo(ctx.getPackageName(), 0);
            packageInfo = packageManager.getPackageInfo(ctx.getPackageName(), 0);
            File file = new File(applicationInfo.sourceDir);
            if (file != null && file.exists()) {
                l4 = file.length();
                l5 = file.lastModified();
            }
            if (packageInfo != null) {
                string2 = packageInfo.versionName + "." + packageInfo.versionCode;
            }
            if (l4 == l2 && string.equals(string2) && l5 == l3) {
                bl = false;
            }
            if (QLog.isColorLevel()) {
                QLog.d(TAG, 0, "apk version = " + string2 + ", apksize = " + l4 + ", apkTime = " + l5 + ", needupdate = " + bl);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        if (SoUtil.extractLibraryFromAssert("hwcodec", bl) && SoUtil.extractLibraryFromAssert("traeimp-armeabi-v7a", bl) && SoUtil.extractLibraryFromAssert("qav_graphics", bl) && SoUtil.extractLibraryFromAssert("qavsdk", bl) && SoUtil.extractLibraryFromAssert("stlport_shared", bl) && SoUtil.extractLibraryFromAssert("TcVpxDec", bl) && SoUtil.extractLibraryFromAssert("TcVpxEnc", bl) && SoUtil.extractLibraryFromAssert("xplatform", bl) && SoUtil.extractLibraryFromAssert("UDT", bl)) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                sharedPreferences.edit().putString(KEY_APP_VERSION, string2).commit();
            }
            if (l4 > 0L) {
                sharedPreferences.edit().putLong(KEY_APK_SIZE, l4).commit();
            }
            if (l5 > 0L) {
                sharedPreferences.edit().putLong(KEY_APK_UPDATE_TIME, l5).commit();
            }
        } else {
            return extractSoError;
        }
        return 0;
    }

    public static boolean LoadExtractedSo(String string) {
        if (QLog.isColorLevel()) {
            QLog.i(TAG, 0, "start LoadExtractedSo: " + string);
        }
        boolean bl = false;
        try {
            System.load(ctx.getFilesDir().getParent() + "/txav/" + SoUtil.getLibActualName(string));
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            File file = new File(ctx.getFilesDir().getParent() + "/txav/" + SoUtil.getLibActualName(string));
            if (file.exists()) {
                file.delete();
            }
            SoUtil.extractLibraryFromAssert(string, true);
            try {
                System.load(ctx.getFilesDir().getParent() + "/txav/" + SoUtil.getLibActualName(string));
                bl = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                bl = false;
            }
        }
        if (!bl) {
            if (QLog.isColorLevel()) {
                QLog.d(TAG, 0, "finally try to use system way to load so: " + string);
            }
            try {
                System.loadLibrary(string);
                bl = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        if (!bl) {
            QLog.e(TAG, 1, "LoadExtractedSo failed: " + string);
        }
        return bl;
    }

    private static long getAvailableInternalMemorySize() {
        File file = Environment.getDataDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getAvailableBlocks();
        return l3 * l2;
    }

    private static String getLibActualName(String string) {
        return "lib" + string + ".so";
    }

    private static String getLibPath() {
        return "lib/armeabi/";
    }

    private static String getTxlibPath() {
        File file = ctx.getFilesDir();
        if (file == null) {
            if (QLog.isColorLevel()) {
                QLog.i(TAG, 0, "getFilesDir is null");
            }
            return "";
        }
        return file.getParent() + "/txav/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean extractLibraryFromAssert(String string, boolean bl) {
        boolean bl2 = false;
        String string2 = "";
        boolean bl3 = false;
        String string3 = SoUtil.getTxlibPath();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return false;
        }
        File file = new File(string3 + SoUtil.getLibActualName(string));
        if (!bl && file.exists()) {
            if (QLog.isColorLevel()) {
                QLog.d(TAG, 0, "extractLibraryFromAssert, no need update");
            }
            bl2 = true;
        } else {
            long l2;
            block49: {
                l2 = SystemClock.uptimeMillis();
                file.delete();
                if (!file.exists()) {
                    OutputStream outputStream = null;
                    InputStream inputStream = null;
                    InputStream inputStream2 = null;
                    long l3 = -1L;
                    try {
                        File file2 = new File(string3);
                        if (!file2.exists() && !file2.mkdir()) break block49;
                        try {
                            if (QLog.isColorLevel()) {
                                QLog.d(TAG, 0, "extractLibraryFromAssert, getAssets = " + SoUtil.getLibPath() + SoUtil.getLibActualName(string));
                            }
                            inputStream = ctx.getAssets().open(SoUtil.getLibPath() + SoUtil.getLibActualName(string));
                            if (SoUtil.getAvailableInternalMemorySize() < (long)inputStream.available()) {
                                bl3 = true;
                                extractSoError = -1;
                                if (QLog.isColorLevel()) {
                                    QLog.d(TAG, 0, "extractLibraryFromAssert, memory is not enough, available = " + SoUtil.getAvailableInternalMemorySize() + ", so = " + inputStream.available());
                                }
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            bl2 = true;
                        }
                        if (!bl3 && !bl2) {
                            int n2;
                            int n3;
                            if (inputStream != null) {
                                outputStream = new FileOutputStream(string3 + SoUtil.getLibActualName(string), true);
                            }
                            l3 = 0L;
                            byte[] byArray = new byte[32768];
                            while (inputStream != null && (n3 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                                outputStream.write(byArray, 0, n3);
                                l3 += (long)n3;
                            }
                            while (inputStream2 != null && (n2 = inputStream2.read(byArray, 0, byArray.length)) != -1) {
                                outputStream.write(byArray, 0, n2);
                                l3 += (long)n2;
                            }
                            if (QLog.isColorLevel()) {
                                QLog.d(TAG, 0, "extractLibraryFromAssert, copy success");
                            }
                            if (file.exists()) {
                                if (l3 != file.length()) {
                                    file.delete();
                                    string2 = string2 + "copy asset so fail. file size not match";
                                    bl2 = false;
                                    if (QLog.isColorLevel()) {
                                        QLog.d(TAG, 0, string2);
                                    }
                                } else {
                                    bl2 = true;
                                    if (QLog.isColorLevel()) {
                                        QLog.d(TAG, 0, "extractLibraryFromAssert " + string + " success");
                                    }
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (QLog.isColorLevel()) {
                            QLog.d(TAG, 0, string2, iOException);
                        }
                        if (QLog.isColorLevel()) {
                            QLog.d(TAG, 0, "extractLibraryFromAssert, e = " + iOException.toString());
                        }
                        extractSoError = -1;
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            long l4 = SystemClock.uptimeMillis() - l2;
            if (QLog.isColorLevel()) {
                QLog.d(TAG, 0, "extract so " + string + " from assets, spend time: " + l4);
            }
        }
        return bl2;
    }
}

