/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.av.mediacodec;

import android.view.Surface;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.EGLUtil;
import com.tencent.xcast.ExternalOESTexture;
import com.tencent.xcast.GLCanvas;
import com.tencent.xcast.GLES20Canvas;
import com.tencent.xcast.SurfaceTextureHolder;

public class MediaCodecEncodeSurface {
    private static final String TAG = "MediaCodecEncodeCapture";
    private Surface mSurface;
    private ExternalOESTexture mExternalOESTexture;
    private EGLCoreContext mEGLCoreContext;
    private GLCanvas mCanvas;
    private int mTextureWidth;
    private int mTextureHeight;

    private MediaCodecEncodeSurface(Surface surface) {
        this.mSurface = surface;
        this.mEGLCoreContext = new EGLCore();
        this.mExternalOESTexture = new ExternalOESTexture();
    }

    public int eglSetup() {
        try {
            if (!this.mEGLCoreContext.createContext(EGLUtil.getOffscreenContext(), true)) {
                throw new IllegalArgumentException("createContext.failed");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Platform.logError("createMediaCodecSurface.failed");
            return -1;
        }
        if (!this.mEGLCoreContext.createSurface(this.mSurface)) {
            return -1;
        }
        this.mEGLCoreContext.makeCurrent();
        this.mCanvas = new GLES20Canvas();
        return 0;
    }

    public int eglSwapBuffers(long l2) {
        int n2 = this.mEGLCoreContext.swapBuffers(l2 * 1000L);
        if (n2 == 12288) {
            return 0;
        }
        return -1;
    }

    public void setSurfaceTextureHolder(SurfaceTextureHolder surfaceTextureHolder) {
        this.mExternalOESTexture.setSurfaceTextureHolder(surfaceTextureHolder);
    }

    public void setParameters(int n2, int n3, int n4, int n5) {
        this.mCanvas.setSize(this.mTextureWidth, this.mTextureHeight);
        this.mExternalOESTexture.setSize(n2, n3, this.mTextureWidth, this.mTextureHeight);
        this.mExternalOESTexture.setPadding(n4, n5);
    }

    public void drawOnEncodeSurface(int n2, int n3, int n4, int n5) {
        this.mTextureWidth = n2 - 2 * n4;
        this.mTextureHeight = n3 - 2 * n5;
        this.setParameters(n2, n3, n4, n5);
        this.mCanvas.drawTexture(this.mExternalOESTexture, 0, 0, this.mTextureWidth, this.mTextureHeight);
    }

    public void release() {
        this.mCanvas.release();
        this.mCanvas = null;
        this.mSurface.release();
        this.mSurface = null;
        this.mExternalOESTexture.release();
        this.mExternalOESTexture = null;
        this.mEGLCoreContext.release();
        this.mEGLCoreContext = null;
    }
}

