/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.av.mediacodec;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import com.tencent.av.mediacodec.DeviceCheck;
import com.tencent.av.mediacodec.IMediaCodecCallback;
import com.tencent.av.mediacodec.NativeCodec;
import com.tencent.avlab.utils.QLog;
import com.tencent.avlab.utils.SoUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=16)
public class AndroidCodec {
    public static int ENC_CODEC = 1;
    public static int DEC_CODEC = 0;
    public static String AVC_CODEC_MIME = "video/avc";
    public static String HEVC_CODEC_MIME = "video/hevc";
    public static String ForceIFrame = "request-sync";
    protected static boolean gfLoaded = false;
    protected MediaFormat mFormat;
    protected MediaFormat mOutputFormat;
    protected MediaCodec mMediaCodec;
    public static String TAG = "AndroidCodec";
    protected ByteBuffer[] inputBuffers;
    protected ByteBuffer[] outputBuffers;
    public static int TIMEOUT_US = 33000;
    public static final int SUPPORT_NONE = 0;
    public static final int SUPPORT_AVC_DEC = 1;
    public static final int SUPPORT_AVC_ENC = 2;
    public static final int SUPPORT_HEVC_DEC = 4;
    public static final int SUPPORT_HEVC_ENC = 8;
    protected int mCodecType = DEC_CODEC;

    private Context reflectApplicationContext() {
        Application application = null;
        try {
            Class<?> clazz = Class.forName("android.app.ActivityThread");
            if (clazz != null) {
                Method method = clazz.getDeclaredMethod("currentApplication", new Class[0]);
                application = (Application)method.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return application;
    }

    public AndroidCodec() {
        AndroidCodec.setDeviceInfos(this.reflectApplicationContext());
    }

    public void setSurface(Surface surface) {
    }

    public static void loadCodecLibrarys() {
        if (!gfLoaded) {
            gfLoaded = SoUtil.loadSo("stlport_shared") && SoUtil.loadSo("hwcodec");
        }
    }

    private static void setDeviceInfos(Context context) {
        Object object;
        boolean bl = false;
        String string = null;
        if (SoUtil.customLibPath != null && ((File)(object = new File(string = SoUtil.customLibPath + "/libhwcodec.so"))).exists()) {
            bl = true;
        }
        if (!bl && ((File)(object = new File(string = context.getApplicationInfo().nativeLibraryDir + "/libhwcodec.so"))).exists()) {
            bl = true;
        }
        if (!bl && ((File)(object = new File(string = context.getFilesDir().getParent() + "/txav/libhwcodec.so"))).exists()) {
            bl = true;
        }
        if (!bl && ((File)(object = new File(string = "/system/lib/libhwcodec.so"))).exists()) {
            bl = true;
        }
        if (!bl) {
            QLog.d(TAG, 0, "setDeviceInfos  ! soExist");
            return;
        }
        if (!gfLoaded) {
            AndroidCodec.loadCodecLibrarys();
            if (gfLoaded) {
                object = "PRODUCT=" + Build.PRODUCT.toLowerCase() + ";";
                object = (String)object + "MODEL=" + Build.MODEL.toLowerCase() + ";";
                object = (String)object + "SDK=" + Build.VERSION.SDK_INT + ";";
                object = (String)object + "FINGERPRINT=" + Build.FINGERPRINT.toLowerCase() + ";";
                object = (String)object + "MANUFACTURER=" + Build.MANUFACTURER.toLowerCase() + ";";
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                object = (String)object + "DATADIR=" + applicationInfo.dataDir + ";";
                object = Build.VERSION.SDK_INT >= 9 ? (String)object + "LIBDIR=" + applicationInfo.nativeLibraryDir + ";" : (String)object + "LIBDIR=" + applicationInfo.dataDir + "/lib;";
                NativeCodec.set_device_infos((String)object);
            }
        }
    }

    public static List<MediaCodecInfo> getDecoderInfos(String string) {
        ArrayList<MediaCodecInfo> arrayList = new ArrayList<MediaCodecInfo>();
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (mediaCodecInfo.isEncoder() || mediaCodecInfo.getName().contains(".sw.") || mediaCodecInfo.getName().contains(".SW.") || mediaCodecInfo.getName().contains("google") || mediaCodecInfo.getName().contains("Google") || mediaCodecInfo.getName().contains("GOOGLE")) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string)) continue;
                arrayList.add(mediaCodecInfo);
            }
        }
        return arrayList;
    }

    public static MediaCodecInfo getCodecInfo(String string) {
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.getName().equalsIgnoreCase(string)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    public static List<MediaCodecInfo> getEndoderInfos(String string) {
        ArrayList<MediaCodecInfo> arrayList = new ArrayList<MediaCodecInfo>();
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder() || mediaCodecInfo.getName().contains(".sw.") || mediaCodecInfo.getName().contains(".SW.") || mediaCodecInfo.getName().contains("google") || mediaCodecInfo.getName().contains("Google") || mediaCodecInfo.getName().contains("GOOGLE")) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string)) continue;
                arrayList.add(mediaCodecInfo);
            }
        }
        return arrayList;
    }

    public static MediaCodecInfo.CodecCapabilities getCodecCapabilities(MediaCodecInfo mediaCodecInfo, String string) {
        MediaCodecInfo.CodecCapabilities codecCapabilities = null;
        try {
            codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            codecCapabilities = null;
        }
        return codecCapabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        block6: {
            try {
                if (this.mMediaCodec == null) break block6;
                this.mMediaCodec.start();
                if (Build.VERSION.SDK_INT <= 20) {
                    AndroidCodec androidCodec = this;
                    synchronized (androidCodec) {
                        this.inputBuffers = this.mMediaCodec.getInputBuffers();
                        this.outputBuffers = this.mMediaCodec.getOutputBuffers();
                    }
                }
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public void flush() {
        if (this.mMediaCodec != null) {
            this.mMediaCodec.flush();
        }
    }

    public void stop() {
        if (this.mMediaCodec != null) {
            this.mMediaCodec.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferData getInputBuffer() {
        if (this.mMediaCodec == null) {
            return null;
        }
        BufferData bufferData = new BufferData();
        int n2 = this.mMediaCodec.dequeueInputBuffer((long)TIMEOUT_US);
        if (n2 >= 0) {
            if (Build.VERSION.SDK_INT <= 20) {
                AndroidCodec androidCodec = this;
                synchronized (androidCodec) {
                    bufferData.index = n2;
                    bufferData.buffer = this.inputBuffers[n2];
                    return bufferData;
                }
            }
            AndroidCodec androidCodec = this;
            synchronized (androidCodec) {
                bufferData.index = n2;
                try {
                    bufferData.buffer = this.mMediaCodec.getInputBuffer(n2);
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                    bufferData.success = false;
                }
                return bufferData;
            }
        }
        return null;
    }

    public synchronized void queueInputBuffer(int n2, int n3, long l2, int n4) {
        block3: {
            if (this.mMediaCodec == null) {
                return;
            }
            try {
                this.mMediaCodec.queueInputBuffer(n2, 0, n3, l2, n4);
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block3;
                QLog.e(TAG, 0, "queueInputBuffer exception", exception);
            }
        }
    }

    public synchronized BufferData dequeueOutputBuffer() {
        if (this.mMediaCodec == null) {
            return null;
        }
        BufferData bufferData = new BufferData();
        int n2 = this.mMediaCodec.dequeueOutputBuffer(bufferData.info, (long)TIMEOUT_US);
        switch (n2) {
            case -3: {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "INFO_OUTPUT_BUFFERS_CHANGED");
                }
                this.outputBuffers = this.mMediaCodec.getOutputBuffers();
                bufferData.index = -3;
                break;
            }
            case -2: {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "INFO_OUTPUT_FORMAT_CHANGED");
                }
                bufferData.index = -2;
                this.mOutputFormat = this.mMediaCodec.getOutputFormat();
                if (this.mOutputFormat == null) break;
                if (this.mCodecType == DEC_CODEC) {
                    int n3 = this.mOutputFormat.getInteger("color-format");
                    if (!QLog.isColorLevel()) break;
                    QLog.e(TAG, 0, "New color format: " + n3 + "[0x" + Integer.toHexString(n3) + "]");
                    break;
                }
                if (!QLog.isColorLevel()) break;
                QLog.e(TAG, 0, "EncCodec, INFO_OUTPUT_FORMAT_CHANGED");
                break;
            }
            case -1: {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "dequeueOutputBuffer timed out!");
                }
                bufferData.index = -1;
                break;
            }
            default: {
                if (n2 >= 0) {
                    if (Build.VERSION.SDK_INT <= 20) {
                        bufferData.buffer = this.outputBuffers[n2];
                        bufferData.index = n2;
                        bufferData.format = this.mOutputFormat;
                        break;
                    }
                    bufferData.index = n2;
                    try {
                        bufferData.format = this.mMediaCodec.getOutputFormat(n2);
                        bufferData.buffer = this.mMediaCodec.getOutputBuffer(n2);
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        bufferData.success = false;
                    }
                    break;
                }
                bufferData.index = n2;
                bufferData.success = false;
            }
        }
        return bufferData;
    }

    public synchronized BufferData dequeueOutputBuffer_First(int n2) {
        if (this.mMediaCodec == null) {
            return null;
        }
        while (this.mMediaCodec != null) {
            int n3 = -1;
            BufferData bufferData = new BufferData();
            n3 = this.mMediaCodec.dequeueOutputBuffer(bufferData.info, (long)n2);
            if (n3 == -3) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, " dequeueOutputBuffer_First INFO_OUTPUT_BUFFERS_CHANGED");
                }
                this.outputBuffers = this.mMediaCodec.getOutputBuffers();
                bufferData.index = -3;
                continue;
            }
            if (n3 == -2) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "dequeueOutputBuffer_First INFO_OUTPUT_FORMAT_CHANGED");
                }
                bufferData.index = -2;
                this.mOutputFormat = this.mMediaCodec.getOutputFormat();
                if (this.mOutputFormat == null) continue;
                if (this.mCodecType == DEC_CODEC) {
                    int n4 = this.mOutputFormat.getInteger("color-format");
                    if (!QLog.isColorLevel()) continue;
                    QLog.e(TAG, 0, "dequeueOutputBuffer_First New color format: " + n4 + "[0x" + Integer.toHexString(n4) + "]");
                    continue;
                }
                if (!QLog.isColorLevel()) continue;
                QLog.e(TAG, 0, "EncCodec, dequeueOutputBuffer_First INFO_OUTPUT_FORMAT_CHANGED");
                continue;
            }
            if (n3 == -1) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "dequeueOutputBuffer_First dequeueOutputBuffer timed out!");
                }
                bufferData.index = -1;
                return bufferData;
            }
            if (n3 >= 0) {
                if (Build.VERSION.SDK_INT <= 20) {
                    bufferData.buffer = this.outputBuffers[n3];
                    bufferData.index = n3;
                    bufferData.format = this.mOutputFormat;
                } else {
                    bufferData.index = n3;
                    try {
                        bufferData.format = this.mMediaCodec.getOutputFormat(n3);
                        bufferData.buffer = this.mMediaCodec.getOutputBuffer(n3);
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        bufferData.success = false;
                    }
                }
            } else {
                bufferData.index = n3;
                bufferData.success = false;
            }
            return bufferData;
        }
        return null;
    }

    @TargetApi(value=21)
    public ByteBuffer getInputBuffer(int n2) {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = this.mMediaCodec.getInputBuffer(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "invoke getInputBuffer exception", exception);
            }
            byteBuffer = null;
        }
        return byteBuffer;
    }

    @TargetApi(value=21)
    public ByteBuffer getOutputBuffer(int n2) {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = this.mMediaCodec.getOutputBuffer(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "invoke getOutputBuffer exception", exception);
            }
            byteBuffer = null;
        }
        return byteBuffer;
    }

    @TargetApi(value=21)
    public MediaFormat getOutputFormat(int n2) {
        MediaFormat mediaFormat;
        try {
            mediaFormat = this.mMediaCodec.getOutputFormat(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "invoke getOutputFormat exception", exception);
            }
            mediaFormat = null;
        }
        return mediaFormat;
    }

    public synchronized void releaseOutputBuffer(int n2) {
        if (this.mMediaCodec == null) {
            return;
        }
        this.mMediaCodec.releaseOutputBuffer(n2, false);
    }

    public synchronized void release() {
        this.inputBuffers = null;
        this.outputBuffers = null;
        if (this.mMediaCodec != null) {
            this.mMediaCodec.release();
            this.mMediaCodec = null;
        }
    }

    public synchronized void reset() {
    }

    public boolean init(MediaFormat mediaFormat, String string, IMediaCodecCallback iMediaCodecCallback) {
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 0, "init name: " + string);
        }
        this.mFormat = mediaFormat;
        int n2 = 2;
        MediaCodecInfo mediaCodecInfo = AndroidCodec.getCodecInfo(string);
        if (mediaCodecInfo != null && mediaCodecInfo.isEncoder()) {
            n2 = 1;
            this.mCodecType = ENC_CODEC;
        }
        try {
            this.mMediaCodec = MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
        try {
            if (this.mMediaCodec != null) {
                if (iMediaCodecCallback != null && DeviceCheck.isSupportAsyncAPI()) {
                    this.setCallback(iMediaCodecCallback);
                }
                this.mMediaCodec.configure(this.mFormat, null, null, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
        return this.mMediaCodec != null;
    }

    public boolean init(MediaFormat mediaFormat, String string, Surface surface, IMediaCodecCallback iMediaCodecCallback) {
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 0, "init name: " + string);
        }
        this.mFormat = mediaFormat;
        try {
            this.mMediaCodec = MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
        int n2 = 2;
        MediaCodecInfo mediaCodecInfo = AndroidCodec.getCodecInfo(string);
        if (mediaCodecInfo != null && mediaCodecInfo.isEncoder()) {
            n2 = 1;
            this.mCodecType = ENC_CODEC;
        }
        try {
            if (this.mMediaCodec != null) {
                if (iMediaCodecCallback != null && DeviceCheck.isSupportAsyncAPI()) {
                    this.setCallback(iMediaCodecCallback);
                }
                this.mMediaCodec.configure(this.mFormat, surface, null, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
        return this.mMediaCodec != null;
    }

    public boolean init(MediaFormat mediaFormat, int n2, IMediaCodecCallback iMediaCodecCallback) {
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 0, "init codecType: " + n2);
        }
        this.mFormat = mediaFormat;
        if (n2 == DEC_CODEC) {
            try {
                this.mMediaCodec = MediaCodec.createDecoderByType((String)this.mFormat.getString("mime"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "init exception", exception);
                }
                return false;
            }
        }
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)this.mFormat.getString("mime"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
        this.mCodecType = n2;
        try {
            if (this.mMediaCodec != null) {
                int n3 = 2;
                if (n2 == ENC_CODEC) {
                    n3 = 1;
                }
                if (iMediaCodecCallback != null && DeviceCheck.isSupportAsyncAPI()) {
                    this.setCallback(iMediaCodecCallback);
                }
                this.mMediaCodec.configure(this.mFormat, null, null, n3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
        return this.mMediaCodec != null;
    }

    public void setParameters(Bundle bundle) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (this.mMediaCodec == null) {
            return;
        }
        try {
            this.mMediaCodec.setParameters(bundle);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    private void setCallback(final IMediaCodecCallback iMediaCodecCallback) {
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "setCallback");
        }
        if (Build.VERSION.SDK_INT < 21) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "setCallback api level lower 21.");
            }
        } else {
            this.mMediaCodec.setCallback(new MediaCodec.Callback(){

                public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
                    if (iMediaCodecCallback != null) {
                        iMediaCodecCallback.onOutputFormatChanged(mediaCodec, mediaFormat);
                    }
                }

                public void onOutputBufferAvailable(MediaCodec mediaCodec, int n2, MediaCodec.BufferInfo bufferInfo) {
                    if (iMediaCodecCallback != null) {
                        iMediaCodecCallback.onOutputBufferAvailable(mediaCodec, n2, bufferInfo);
                    }
                }

                public void onInputBufferAvailable(MediaCodec mediaCodec, int n2) {
                    if (iMediaCodecCallback != null) {
                        iMediaCodecCallback.onInputBufferAvailable(mediaCodec, n2);
                    }
                }

                @TargetApi(value=21)
                public void onError(MediaCodec mediaCodec, MediaCodec.CodecException codecException) {
                    if (iMediaCodecCallback != null) {
                        iMediaCodecCallback.onError(mediaCodec, (Exception)codecException);
                    }
                }
            });
        }
    }

    public static class InputBufferData {
        public ByteBuffer buffer;
        public int index;
        public boolean processing = false;

        public InputBufferData(ByteBuffer byteBuffer, int n2) {
            this.buffer = byteBuffer;
            this.index = n2;
        }
    }

    public class BufferData {
        public ByteBuffer buffer;
        public MediaFormat format;
        public int index;
        public MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        public boolean success = true;
    }
}

