package com.tencent.wecast.sender.cloud.config

import com.tencent.wecast.WeCastConfigManager
import com.tencent.wecast.WeCastUIConfigManager
import com.tencent.wecast.sender.cloud.R

/**
 * 发送端UI定制ID映射
 */
class SenderUIIdMapping : WeCastUIConfigManager.IConfigUI {
    override fun getViewIds(templateId: WeCastUIConfigManager.UITemplateId?,
                            label: WeCastUIConfigManager.ActivityLabel?,
                            viewLabel: String?): IntArray? {
        return null
    }

    override fun getLayoutId(templateId: WeCastUIConfigManager.UITemplateId?,
                             activityLabel: WeCastUIConfigManager.ActivityLabel?): Int {
        val tId = autoCorrectTemplateId(templateId)
        return when (tId) {
            WeCastUIConfigManager.UITemplateId.TEMPLATE_2 -> {
                when (activityLabel) {
                    WeCastUIConfigManager.ActivityLabel.SENDER_SPLASH_2 -> R.layout.wecast_activity_splash_2
                    WeCastUIConfigManager.ActivityLabel.SENDER_MAIN_2 -> R.layout.wecast_activity_main_2
                    WeCastUIConfigManager.ActivityLabel.SENDER_USER_LIST -> R.layout.wecast_user_list_item
                    WeCastUIConfigManager.ActivityLabel.SENDER_USER_ADD -> R.layout.wecast_user_list_add
                    else -> 0
                }
            }
            WeCastUIConfigManager.UITemplateId.TEMPLATE_3 -> 0    // 默认用TEMPLATE_1
            WeCastUIConfigManager.UITemplateId.TEMPLATE_4 -> 0    // 默认用TEMPLATE_1
            WeCastUIConfigManager.UITemplateId.TEMPLATE_5 -> 0    // 默认用TEMPLATE_1
            else -> {
                when (activityLabel) {
                    WeCastUIConfigManager.ActivityLabel.SENDER_SPLASH_1 -> R.layout.wecast_activity_splash_1
                    WeCastUIConfigManager.ActivityLabel.SENDER_MAIN_1 -> R.layout.wecast_activity_main_1
                    WeCastUIConfigManager.ActivityLabel.SENDER_GUIDE -> R.layout.wecast_dialog_choose_app
                    else -> 0
                }
            }
        }
    }

    override fun getViewId(templateId: WeCastUIConfigManager.UITemplateId?,
                           activityLabel: WeCastUIConfigManager.ActivityLabel?,
                           viewLabel: String?): Int {
        val tId = autoCorrectTemplateId(templateId)
        return when (tId) {
            WeCastUIConfigManager.UITemplateId.TEMPLATE_2 -> {
                when (activityLabel) {
                    WeCastUIConfigManager.ActivityLabel.SENDER_MAIN_2 -> {
                        when (viewLabel) {
                            // 等待layout
                            "main_background" -> R.id.iv_main_bg
                            "close_button" -> R.id.btn_close
                            "welcome_text" -> R.id.tv_welcome
                            "pin_edit" -> R.id.et_pin_code
                            "brush_frame" -> R.id.iv_pin_down_line
                            "cast_button" -> R.id.btn_confirm
                            "cast_text" -> R.id.btn_confirm
                            "logo_img" -> R.id.iv_footer_logo
                            "down_tips" -> R.id.tv_footer_tips
                            "version_text" -> R.id.tv_version_and_env
                            "alert_image" -> R.id.iv_alert_icon
                            "alert_text" -> R.id.tv_alert_text
                            "wecast_alert_waiting" -> R.id.wca_alert
                            // 投屏layout
                            "casting_lock_screen_background" -> R.id.layout_setting
                            "casting_lock_screen_text" -> R.id.tv_lock_screen_tips
                            "casting_lock_screen_arrow" -> R.id.iv_lock_screen_arrow
                            "casting_logo" -> R.id.iv_in_room_logo
                            "casting_guide_text" -> R.id.tv_casting
                            "casting_tv_text" -> R.id.tv_notice
                            "casting_exit_button" -> R.id.btn_exit
                            "casting_exit_text" -> R.id.btn_exit
                            "wecast_alert_in_room" -> R.id.wca_alert_in_room
                            "casting_member_list" -> R.id.lv_user_list
                            else -> 0
                        }
                    }
                    WeCastUIConfigManager.ActivityLabel.SENDER_USER_LIST -> {
                        when (viewLabel) {
                            // 列表当前user layout
                            "casting_member_list_text" -> R.id.tv_show_user_name
                            "casting_member_list_computer_logo" -> R.id.iv_show_user_icon
                            "casting_member_list_click_logo" -> R.id.tv_show_status
                            else -> 0
                        }
                    }
                    WeCastUIConfigManager.ActivityLabel.SENDER_USER_ADD -> {
                        when (viewLabel) {
                            // 列表增加user layout
                            "casting_member_list_add_logo" -> R.id.iv_add_user_icon
                            "casting_member_list_add_user_name" -> R.id.tv_add_user_name
                            else -> 0
                        }
                    }
                    else -> 0
                }
            }

            WeCastUIConfigManager.UITemplateId.TEMPLATE_3 -> 0    // 默认用TEMPLATE_1
            WeCastUIConfigManager.UITemplateId.TEMPLATE_4 -> 0    // 默认用TEMPLATE_1
            WeCastUIConfigManager.UITemplateId.TEMPLATE_5 -> 0    // 默认用TEMPLATE_1
            else -> { // 模板1
                when (activityLabel) {
                    WeCastUIConfigManager.ActivityLabel.SENDER_MAIN_1 -> {
                        when (viewLabel) {
                            // 等待layout
                            "main_background" -> R.id.iv_main_bg
                            "close_button" -> R.id.btn_close
                            "welcome_text" -> R.id.tv_welcome
                            "pin_edit" -> R.id.et_pin_code
                            "brush_frame" -> R.id.iv_pin_down_line
                            "cast_button" -> R.id.btn_confirm
                            "cast_text" -> R.id.btn_confirm
                            "logo_img" -> R.id.iv_logo
                            "version_text" -> R.id.tv_version_and_env
                            "alert_image" -> R.id.iv_alert_icon
                            "alert_text" -> R.id.tv_alert_text
                            "wecast_alert_waiting" -> R.id.wca_alert
                            // 投屏layout
                            "casting_lock_screen_background" -> R.id.layout_setting
                            "casting_lock_screen_text" -> R.id.tv_lock_screen_tips
                            "casting_lock_screen_arrow" -> R.id.iv_lock_screen_arrow
                            "casting_logo" -> R.id.iv_in_room_logo
                            "casting_guide_text" -> R.id.tv_casting
                            "casting_tv_text" -> R.id.tv_notice
                            "casting_streaming_button" -> R.id.btn_choose_video_app
                            "casting_streaming_text" -> R.id.btn_choose_video_app
                            "casting_exit_button" -> R.id.btn_exit
                            "casting_exit_text" -> R.id.btn_exit
                            "wecast_alert_in_room" -> R.id.wca_alert_in_room
                            else -> 0
                        }
                    }
                    WeCastUIConfigManager.ActivityLabel.SENDER_GUIDE -> {
                        when (viewLabel) {
                            "guide_close_text" -> R.id.btn_cancel
                            "guide_choose_app_title" -> R.id.tv_choose_app_title
                            "guide_choose_app_youku" -> R.id.tv_choose_app_youku
                            "guide_choose_app_iqiyi" -> R.id.tv_choose_app_iqiyi
                            "guide_choose_app_tencent" -> R.id.tv_choose_app_tencent
                            "guide_choose_app_bg" -> R.id.ll_wecast_guide
                            else -> 0
                        }
                    }
                    else -> 0
                }
            }
        }
    }

    override fun getResourceId(templateId: WeCastUIConfigManager.UITemplateId?,
                               resLabel: String?): Int {
        if (0 != getThemeStyleResId(resLabel)) {
            return getThemeStyleResId(resLabel)
        }

        val tId = autoCorrectTemplateId(templateId)
        return when (tId) {
            WeCastUIConfigManager.UITemplateId.TEMPLATE_2 -> {
                when (resLabel) {
                    "wecast_icon_left_arrow" -> R.drawable.wecast_icon_left_gray_arrow_selector
                    "wecast_icon_left_white_arrow" -> R.drawable.wecast_icon_left_white_arrow_selector
                    "wecast_icon_right_arrow_gray" -> R.drawable.wecast_icon_right_arrow_gray
                    "wecast_casting_black_up_picture" -> R.drawable.wecast_casting_black_up_picture
                    "wecast_casting_white_up_picture" -> R.drawable.wecast_casting_white_up_picture
                    "wecast_casting_black_up_picture_2" -> R.drawable.wecast_casting_black_up_picture_2
                    "wecast_casting_white_up_picture_2" -> R.drawable.wecast_casting_white_up_picture_2
                    "wecast_btn_rectangle_yellow_bg" -> R.drawable.wecast_btn_rectangle_yellow_bg
                    "wecast_btn_rectangle_blue_bg" -> R.drawable.wecast_btn_rectangle_blue_bg
                    "wecast_btn_rectangle_white_bg" -> R.drawable.wecast_btn_rectangle_white_bg
                    "wecast_btn_rectangle_transparent_black_bg" -> R.drawable.wecast_btn_rectangle_transparent_black_bg
                    "wecast_btn_rectangle_transparent_white_bg" -> R.drawable.wecast_btn_rectangle_transparent_white_bg
                    "wecast_icon_yellow_error" -> R.drawable.wecast_icon_yellow_error
                    "wecast_icon_white_error" -> R.drawable.wecast_icon_white_error
                    "wecast_icon_footer" -> R.drawable.wecast_icon_footer
                    "wecast_medialab_logo_black" -> R.drawable.medialab_logo_black
                    "wecast_medialab_logo_white" -> R.drawable.medialab_logo_white
                    "wecast_lock_screen_bg_blue" -> R.drawable.wecast_lock_screen_bg_blue
                    "wecast_lock_screen_bg_black" -> R.drawable.wecast_lock_screen_bg_black
                    "wecast_lock_screen_arrow_blue" -> R.drawable.wecast_lock_screen_arrow_blue
                    "wecast_lock_screen_arrow_black" -> R.drawable.wecast_lock_screen_arrow_black
                    "wecast_lock_screen_arrow_white" -> R.drawable.wecast_lock_screen_arrow_white
                    "wecast_icon_white_computer" -> R.drawable.wecast_icon_white_computer
                    "wecast_icon_black_computer" -> R.drawable.wecast_icon_black_computer
                    "wecast_icon_white_tick" -> R.drawable.wecast_icon_white_tick
                    "wecast_icon_black_tick" -> R.drawable.wecast_icon_black_tick
                    "wecast_white_add_user_icon" -> R.drawable.wecast_white_add_user_icon
                    "wecast_black_add_user_icon" -> R.drawable.wecast_black_add_user_icon

                    "wecast_style_common_yellow" -> R.style.WeCastButtonCommonYellow
                    "wecast_img_rectangle_yellow" -> R.drawable.wecast_btn_rectangle_yellow_bg

                    "wecast_style_rectangle_white" -> R.style.WeCastButtonRectangleWhite
                    "wecast_img_rectangle_white" -> R.drawable.wecast_btn_rectangle_white_bg

                    "wecast_style_common_white" -> R.style.WeCastButtonCommonWhite
                    "wecast_img_rectangle_transparent" -> R.drawable.wecast_btn_rectangle_transparent_black_bg

                    "wecast_style_rectangle_blue" -> R.style.WeCastButtonRectangleBlue
                    "wecast_img_rectangle_blue" -> R.drawable.wecast_btn_rectangle_blue_bg
                    else -> 0
                }
            }
            WeCastUIConfigManager.UITemplateId.TEMPLATE_3 -> 0    // 默认用TEMPLATE_1
            WeCastUIConfigManager.UITemplateId.TEMPLATE_4 -> 0    // 默认用TEMPLATE_1
            WeCastUIConfigManager.UITemplateId.TEMPLATE_5 -> 0    // 默认用TEMPLATE_1
            else -> {    // 模版1
                when (resLabel) {
                    "wecast_icon_left_arrow" -> R.drawable.wecast_icon_left_gray_arrow_selector
                    "wecast_icon_left_white_arrow" -> R.drawable.wecast_icon_left_white_arrow_selector
                    "wecast_icon_right_arrow_gray" -> R.drawable.wecast_icon_right_arrow_gray
                    "wecast_casting_black_up_picture" -> R.drawable.wecast_casting_black_up_picture
                    "wecast_casting_white_up_picture" -> R.drawable.wecast_casting_white_up_picture
                    "wecast_casting_black_up_picture_2" -> R.drawable.wecast_casting_black_up_picture_2
                    "wecast_casting_white_up_picture_2" -> R.drawable.wecast_casting_white_up_picture_2
                    "wecast_btn_rectangle_yellow_bg" -> R.drawable.wecast_btn_rectangle_yellow_bg
                    "wecast_btn_rectangle_blue_bg" -> R.drawable.wecast_btn_rectangle_blue_bg
                    "wecast_btn_rectangle_white_bg" -> R.drawable.wecast_btn_rectangle_white_bg
                    "wecast_btn_rectangle_transparent_black_bg" -> R.drawable.wecast_btn_rectangle_transparent_black_bg
                    "wecast_btn_rectangle_transparent_white_bg" -> R.drawable.wecast_btn_rectangle_transparent_white_bg
                    "wecast_icon_yellow_error" -> R.drawable.wecast_icon_yellow_error
                    "wecast_icon_white_error" -> R.drawable.wecast_icon_white_error
                    "wecast_icon_footer" -> R.drawable.wecast_icon_footer
                    "wecast_medialab_logo_black" -> R.drawable.medialab_logo_black
                    "wecast_medialab_logo_white" -> R.drawable.medialab_logo_white
                    "wecast_lock_screen_bg_blue" -> R.drawable.wecast_lock_screen_bg_blue
                    "wecast_lock_screen_bg_black" -> R.drawable.wecast_lock_screen_bg_black
                    "wecast_lock_screen_bg_white" -> R.drawable.wecast_lock_screen_bg_white
                    "wecast_lock_screen_arrow_blue" -> R.drawable.wecast_lock_screen_arrow_blue
                    "wecast_lock_screen_arrow_white" -> R.drawable.wecast_lock_screen_arrow_white
                    "wecast_lock_screen_arrow_black" -> R.drawable.wecast_lock_screen_arrow_black

                    "wecast_style_common_yellow" -> R.style.WeCastButtonCommonYellow
                    "wecast_img_rectangle_yellow" -> R.drawable.wecast_btn_rectangle_yellow_bg

                    "wecast_style_rectangle_white" -> R.style.WeCastButtonRectangleWhite
                    "wecast_img_rectangle_white" -> R.drawable.wecast_btn_rectangle_white_bg

                    "wecast_style_common_white" -> R.style.WeCastButtonCommonWhite
                    "wecast_img_rectangle_transparent" -> R.drawable.wecast_btn_rectangle_transparent_black_bg

                    "wecast_style_rectangle_blue" -> R.style.WeCastButtonRectangleBlue
                    "wecast_img_rectangle_blue" -> R.drawable.wecast_btn_rectangle_blue_bg
                    else -> 0
                }
            }
        }
    }

    private fun getThemeStyleResId(resLabel: String?): Int {
        return when (resLabel) {
            "wecast_theme_style_blue" -> R.style.WeCastAppThemeBlue
            else -> 0
        }
    }

    override fun getMainBgResId(templateId: WeCastUIConfigManager.UITemplateId?): Int {
        val tId = autoCorrectTemplateId(templateId)
        return when (tId) {
            WeCastUIConfigManager.UITemplateId.TEMPLATE_2 -> 0    // 默认用TEMPLATE_1
            WeCastUIConfigManager.UITemplateId.TEMPLATE_3 -> 0    // 默认用TEMPLATE_1
            WeCastUIConfigManager.UITemplateId.TEMPLATE_4 -> 0    // 默认用TEMPLATE_1
            WeCastUIConfigManager.UITemplateId.TEMPLATE_5 -> 0    // 默认用TEMPLATE_1
            else -> {
                R.drawable.wecast_main_bg_1 // 模板1的bg id为xml文件id
            }
        }
    }

    private fun autoCorrectTemplateId(templateId: WeCastUIConfigManager.UITemplateId?)
            : WeCastUIConfigManager.UITemplateId {
        if (WeCastConfigManager.getInstance().isLanScheme) {
            // 当前局域网方案必须使用模版1
            if (templateId != WeCastUIConfigManager.UITemplateId.TEMPLATE_1) {
                return WeCastUIConfigManager.UITemplateId.TEMPLATE_1
            }
        } else {
            // 当前公网方案必须使用模版2
            if (templateId != WeCastUIConfigManager.UITemplateId.TEMPLATE_2) {
                return WeCastUIConfigManager.UITemplateId.TEMPLATE_2
            }
        }
        return templateId
    }
}
