package com.tencent.wecast.sender.cloud.activity

import android.app.Activity
import android.app.Dialog
import android.app.job.JobInfo
import android.app.job.JobScheduler
import android.content.*
import android.media.projection.MediaProjectionManager
import android.os.Bundle
import android.os.PersistableBundle
import android.support.v4.content.ContextCompat
import android.support.v7.app.AlertDialog
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.*
import com.google.gson.JsonArray
import com.tencent.wecast.WeCastEnv
import com.tencent.wecast.WeCastUIConfigManager
import com.tencent.wecast.c2c.C2CPauseXCastMsg
import com.tencent.wecast.c2c.C2CPushUpdateMsg
import com.tencent.wecast.c2c.WeCastC2CUtil
import com.tencent.wecast.jni.JniHelper
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.bean.WeCastInfo
import com.tencent.wecast.sender.cloud.service.SSDPDiscoveryJobService
import com.tencent.wecast.sender.cloud.utils.*
import com.tencent.wecast.sender.cloud.widget.PinCodeEditText
import com.tencent.wecast.sender.cloud.widget.WeCastAlert
import com.tencent.wecast.sender.eb.SenderEvents
import com.tencent.wecast.utils.*
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


class CloudMainActivity1 : BaseActivity(), View.OnClickListener {

    companion object {

        private const val TAG = "CloudMainActivity1"

        private val REQUEST_MEDIA_PROJECTION = 10002

        /**
         * 等待
         */
        private const val UI_STATE_WAITING = 0


        /**
         * 投屏中
         */
        private const val UI_STATE_IN_ROOM = 2


        /** 键盘最低高度 **/
        private const val KEYBOARD_MIN_HEIGHT = 200

        /** 键盘相关操作延迟毫秒数 **/
        private const val KEYBOARD_ACTION_DELAYED = 200L


        private const val ALERT_TYPE_NORMAL = 0
        private const val ALERT_TYPE_NET_DISCONNECTED = 20

        /** 息屏提示相关 **/
        private const val SENDER_MAIN_SP = "sender_main_sp"
        private const val KEY_SCREEN_OUT_ALERT_FIRST_SHOW = "key_screen_out_alert_first_show"

        // 用于进房时暂存googleCastRsp信息  避免onC2CMessageEvent DLNA重启服务时导致信息丢失
        private var mGCastRsp: String? = null

        private const val SSDP_JOB_ID = 1000

        public var mLimitedSsidComb = ""
    }

    private var mCurrentUIState = UI_STATE_WAITING


    private var mSuccessDialog: Dialog? = null

    /**
     * 输入页面
     */
    private var mLayoutInputPin: ViewGroup? = null

    /**
     * 投屏页面
     */
    private var mLayoutInRoom: ViewGroup? = null

    private var mTvWelcome: View? = null

    private var mBtnClose: Button? = null
    private var mEtPinCode: PinCodeEditText? = null
    private var mBtnConfirm: Button? = null
    private var mBtnConfirmTxt: String? = null

    private var mLayoutFooter: ImageView? = null

    private var mWcaAlert: WeCastAlert? = null
    private var mWcaAlertInRoom: WeCastAlert? = null

    private var mTvCasting: View? = null
    private var mTvNotice: TextView? = null

    private var mBtnChooseVideoApp: Button? = null
    private var mBtnExit: Button? = null

    /**
     * tips相关
     */
    private var mSvTips: ScrollView? = null
    private var mTvQualityTips: TextView? = null
    private var mNativeTips = ""

    /**
     * tips显示标志
     */
    private var mShowTipsFlag: Boolean = false
    private var mLastTapTimeMs: Long = 0
    private var mTapTimes: Int = 0

    /**
     * 环境切换标志
     */
    private var mLastChangeEnvTapTimeMs: Long = 0
    private var mChangeEnvTapTimes: Int = 0

    /**
     * PIN 码输入完成标志
     */
    private var mInputCompleteFlag: Boolean = false

    private lateinit var mScreenOutSettingInfo: SettingUtils.ScreenOutSettingInfo

    private var mMainSP: SharedPreferences? = null

    private var mChooseAppDialog: Dialog? = null

    // 发送端恢复进房（进程被杀等造成接收端还在房间，发送端再次进入时仍然会加到原房间）
    private var mIsRecover = false

    private var mScreenOffReceiver: BroadcastReceiver? = null

    private var mJobScheduler: JobScheduler? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val rootView = WeCastUIConfigManager.getInstance().getLayoutRootView(
                WeCastUIConfigManager.ActivityLabel.SENDER_MAIN_1, applicationContext)
        if (null == rootView) {
            Logger.t(TAG).e("rootView is null.")
            finish()
            return
        }
        WeCastUIConfigManager.getInstance().applyUIConfig(WeCastUIConfigManager.ActivityLabel.SENDER_MAIN_1, rootView)

        StatusBarUtils.setWindowStatusBarColor(this@CloudMainActivity1,
                WeCastUIConfigManager.getInstance().getStatusBarColor(ContextCompat.getColor(applicationContext, R.color.wecast_colorPrimary1)))
        StatusBarUtils.setStatusBarLightMode(this@CloudMainActivity1, true)
        window.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON)
        setContentView(rootView)

        mLayoutInputPin = findViewById(R.id.layout_input_pin)
        mLayoutInRoom = findViewById(R.id.layout_in_room)

        /**
         * 关闭按钮
         */
        mBtnClose = findViewById(R.id.btn_close)
        mBtnClose?.setOnClickListener(this)

        mTvWelcome = findViewById(R.id.tv_welcome)
        mTvWelcome?.setOnClickListener(this)

        /**
         * PIN 码输入框
         */
        mEtPinCode = findViewById(R.id.et_pin_code)
        mEtPinCode?.setInputListener(object : PinCodeEditText.InputListener {
            override fun inputComplete(completeFlag: Boolean) {
                mInputCompleteFlag = completeFlag
                mBaseHandler?.post {
                    setBtnConfirmEnable(NetworkUtil.isNetworkConnected(applicationContext))
                }
            }
        })
        mEtPinCode?.textAlignment = View.TEXT_ALIGNMENT_CENTER
        mEtPinCode?.requestFocus()

        /**
         * 错误提示
         */
        mWcaAlert = findViewById(R.id.wca_alert)

        mTvCasting = findViewById(R.id.tv_casting)
        mTvNotice = findViewById(R.id.tv_notice)
        mWcaAlertInRoom = findViewById(R.id.wca_alert_in_room)

        /**
         * 确认按钮
         */
        mBtnConfirm = findViewById(R.id.btn_confirm)
        mBtnConfirm?.setOnClickListener(this)
        mBtnConfirm?.isEnabled = false
        mBtnConfirmTxt = mBtnConfirm?.text.toString()

        /**
         * 底部footer
         */
        mLayoutFooter = findViewById(R.id.iv_logo)

        /**
         * 选择视频推流应用按钮
         */
        mBtnChooseVideoApp = findViewById(R.id.btn_choose_video_app)
        mBtnChooseVideoApp?.setOnClickListener(this)

        /**
         * 退出投屏按钮
         */
        mBtnExit = findViewById(R.id.btn_exit)
        mBtnExit?.setOnClickListener(this)

        /**
         * tips 显示
         */
        mSvTips = findViewById(R.id.sv_tips)
        mTvQualityTips = findViewById(R.id.tv_quality_tips)
        mTvQualityTips?.setOnClickListener(this)

        /**
         * 进房时上方的logo
         */
        val inRoomLogo = findViewById<View>(R.id.iv_in_room_logo)
        inRoomLogo?.setOnClickListener(this)

        /**
         * 防息屏提示
         */
        val layoutSetting = findViewById<View>(R.id.layout_setting)
        layoutSetting?.setOnClickListener(this)

        registerScreenOffBroadCast()

        setBtnConfirmEnable(NetworkUtil.isNetworkConnected(this))
        setVersionAndEnv()

        /** 处理键盘拉起事件 **/
        KeyboardUtils.registerSoftInputChangedListener(this, object : KeyboardUtils.OnSoftInputChangedListener {
            override fun onSoftInputChanged(height: Int) {
                try {
                    /** 处理版本环境 */
                    val tvVersionAndEnv = findViewById<TextView>(R.id.tv_version_and_env)
                    tvVersionAndEnv.visibility = if (height > KEYBOARD_MIN_HEIGHT)
                        View.GONE else View.VISIBLE
                    /** 处理欢迎文字 */
                    val lpTvWelcome = mTvWelcome!!.layoutParams as RelativeLayout.LayoutParams
                    lpTvWelcome.topMargin =
                            if (height > KEYBOARD_MIN_HEIGHT) {
                                resources.getDimensionPixelSize(R.dimen.wecast_main_welcome_margin_top_with_keyboard)
                            } else {
                                resources.getDimensionPixelSize(R.dimen.wecast_main_welcome_margin_top)
                            }
                    /** 处理关闭按钮 */
                    val btnClose = findViewById<Button>(R.id.btn_close)
                    val lpBtnClose = btnClose.layoutParams as RelativeLayout.LayoutParams
                    lpBtnClose.topMargin =
                            if (height > KEYBOARD_MIN_HEIGHT) {
                                resources.getDimensionPixelSize(R.dimen.wecast_main_btn_close_margin_top_with_keyboard)
                            } else {
                                resources.getDimensionPixelSize(R.dimen.wecast_main_btn_close_margin_top)
                            }
                } catch (e: Exception) {
                }
            }
        })
        /**
         * 息屏提示相关
         */
        mScreenOutSettingInfo = SettingUtils.getScreenOutSettingInfo(this)

        mMainSP = getSharedPreferences(SENDER_MAIN_SP, Context.MODE_PRIVATE)
        EventBusUtil.register(this)
    }

    public override fun onResume() {
        if (!WeCastInfo.instance.isRunning) {
            WeCastInfo.instance.mStateChangeListener?.onChanged(0)
        }
        WeCastInfo.instance.isRunning = true
        super.onResume()
    }

    override fun onDestroy() {
        super.onDestroy()

        EventBusUtil.unregister(this)
        try {
            stopSSDPJobService()
            unregisterReceiver(mScreenOffReceiver)
        } catch (e: Exception) {
        }

        KeyboardUtils.hideSoftInput(this)

        KeyboardUtils.registerSoftInputChangedListener(this, null)

        mSuccessDialog?.dismiss()
        mSuccessDialog = null

        mChooseAppDialog?.dismiss()
        mChooseAppDialog = null

        WeCastInfo.instance.isRunning = false
        WeCastInfo.instance.isCasting = false
        WeCastInfo.instance.mStateChangeListener?.onChanged(2)
    }

    override fun onBackPressed() {
        Logger.kp().d("Click back button, currentUIState = %d", mCurrentUIState)

        when (mCurrentUIState) {
            UI_STATE_WAITING -> {
                /** 等待状态，退出应用  */
                CloudUtil.JniMethod.unInitSender()
                finish()
            }
            else -> {
                /** 其他状态，暂不处理  */
                return
            }
        }
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.btn_confirm -> {
                tryEnterCast()
            }
            R.id.btn_exit -> {
                exitCast()
            }
            R.id.btn_close -> {
                CloudUtil.JniMethod.unInitSender()
                finish()
            }
            R.id.iv_in_room_logo -> {
                tryShowTips()
            }
            R.id.tv_quality_tips -> {
                mSvTips?.visibility = View.GONE
                mShowTipsFlag = false
            }
            R.id.tv_welcome -> {
                /**
                 * 5秒10下切换环境
                 */
                val currentTimeMs = System.currentTimeMillis()
                if (currentTimeMs - mLastChangeEnvTapTimeMs > 5 * 1000) {
                    mLastChangeEnvTapTimeMs = currentTimeMs
                    mChangeEnvTapTimes = 0
                } else {
                    mChangeEnvTapTimes++
                }

                if (mChangeEnvTapTimes >= 9) {
                    mLastChangeEnvTapTimeMs = 0
                    mChangeEnvTapTimes = 0

                    Thread(Runnable {
                        WeCastEnv.changeNextEnv()
                        val resultStr = WeCastEnv.getCurrentEnvDesc()
                        mBaseHandler?.post {
                            Toast.makeText(this, resultStr, Toast.LENGTH_LONG).show()
                        }
                    }).start()
                }
            }
            R.id.btn_choose_video_app -> {
                showChooseAppDialog()
            }
            R.id.layout_setting -> {
                ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_SCREEN_OUT_CLICK_BAR, 0, "")
                showScreenOutSettingDialog()
            }
            else -> {
            }
        }
    }


    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        if (requestCode == REQUEST_MEDIA_PROJECTION) {
            Logger.kp().i("Request screen capture permission: $resultCode")

            if (resultCode != Activity.RESULT_OK) {
                Toast.makeText(this, getString(R.string.wecast_screen_permission_failed), Toast.LENGTH_LONG).show()
                if (mIsRecover) {
                    CloudUtil.JniMethod.recoverCast(true)
                }
            } else {
                WeCastUtil.setCapturePermission(resultCode, data)
                if (!mIsRecover) {
                    enterCast()
                } else {
                    CloudUtil.JniMethod.recoverCast(false)
                }
            }
            mIsRecover = false
        }
    }

    private fun tryEnterCast() {
        if (mLimitedSsidComb != "") {
            val ssidList = mLimitedSsidComb.split(",")
            var needShowDlg = true
            for (ssid in ssidList) {
                if (NetworkUtil.isConnTheSsidWifi(applicationContext, ssid)) {
                    needShowDlg = false
                    break
                }
            }
            if (needShowDlg) {
                showDiffSSIDWifiDialog(ssidList[0])
                return
            }
        }
        if (!NetworkUtil.isUsingWifi(applicationContext)) {
            showNotUsingWiFiDialog()
            return
        }
        setCapturePermission()
    }

    private fun enterCast() {
        CloudUtil.JniMethod.enterCast(mEtPinCode?.getPinCode().toString())
        Logger.kp().d("Enter cast: ${mEtPinCode?.getPinCode()}")
    }


    private fun exitCast() {
        CloudUtil.JniMethod.exitCast(0)
        mIsXCastPause = false
        mIsRecover = false
    }

    private fun setUIState(uiState: Int) {
        mCurrentUIState = uiState
        refreshUI()
    }

    private fun refreshUI() {
        if (mCurrentUIState == UI_STATE_WAITING) {
            mLayoutInputPin?.visibility = View.VISIBLE
            mLayoutInRoom?.visibility = View.GONE
            mBtnClose?.visibility = View.VISIBLE
            mTvWelcome?.visibility = View.VISIBLE
            mLayoutFooter?.visibility = View.VISIBLE

            mChooseAppDialog?.dismiss()
            mChooseAppDialog = null

            if (WeCastInfo.instance.isCasting) {
                WeCastInfo.instance.mStateChangeListener?.onChanged(0)
            }
            WeCastInfo.instance.isCasting = false
        } else {
            mEtPinCode?.clearFocus()
            KeyboardUtils.hideSoftInput(this)
            mLayoutInputPin?.visibility = View.GONE
            mLayoutInRoom?.visibility = View.VISIBLE
            mBaseHandler?.postDelayed({
                mEtPinCode?.clearFocus()
                KeyboardUtils.hideSoftInput(this)
            }, KEYBOARD_ACTION_DELAYED)

            if (!WeCastInfo.instance.isCasting) {
                WeCastInfo.instance.mStateChangeListener?.onChanged(1)
            }
            WeCastInfo.instance.isCasting = true
        }
        /** 第一次息屏的提示 **/
        val setView = findViewById<View>(R.id.layout_setting)
        if (setView.visibility == View.VISIBLE) {
            tryShowScreenOutSettingDialogFirst()
        }
    }

    private fun showEnteringTips() {
        showLoading(getString(R.string.wecast_entering_cast))
    }

    private fun hideEnteringTips() {
        hideLoading()
    }


    private fun dealExitOrDisconnect() {
        mShowTipsFlag = false
        mSvTips?.visibility = View.GONE
        mTvNotice?.text = ""
    }


    private fun showNormalAlert(text: String) {
        showAlert(WeCastAlert.WeCastAlertInfo(ALERT_TYPE_NORMAL,
                text))
    }

    private fun hideNormalAlert() {
        hideAlert(ALERT_TYPE_NORMAL)
    }

    private fun showNetDisconnectedAlert(showFlag: Boolean) {
        if (showFlag) {
            val netTips = getString(R.string.wecast_alert_abnormal_net_text)
            showAlertInRoom(WeCastAlert.WeCastAlertInfo(ALERT_TYPE_NET_DISCONNECTED,
                    netTips))
        } else {
            hideAlertInRoom(ALERT_TYPE_NET_DISCONNECTED)
        }
    }


    private fun showAlert(alertInfo: WeCastAlert.WeCastAlertInfo) {
        mWcaAlert?.addAlert(alertInfo)
    }

    private fun hideAlert(alertType: Int) {
        mWcaAlert?.removeAlert(alertType)
    }

    private fun showAlertInRoom(alertInfo: WeCastAlert.WeCastAlertInfo) {
        mWcaAlertInRoom?.addAlert(alertInfo)

        if (mWcaAlertInRoom != null && mWcaAlertInRoom!!.hasAlert()) {
            mTvCasting?.visibility = View.INVISIBLE
        } else {
            mTvCasting?.visibility = View.VISIBLE
        }
    }

    private fun hideAlertInRoom(alertType: Int) {
        mWcaAlertInRoom?.removeAlert(alertType)

        if (mWcaAlertInRoom != null && mWcaAlertInRoom!!.hasAlert()) {
            mTvCasting?.visibility = View.INVISIBLE
        } else {
            mTvCasting?.visibility = View.VISIBLE
        }
    }

    private fun setVersionAndEnv() {
        try {
            val tvVersionAndEnv = findViewById<TextView>(R.id.tv_version_and_env)
            tvVersionAndEnv?.text = WeCastUtil.getVersionAndEnv()
        } catch (e: Exception) {

        }
    }

    /**
     * 设置确认按钮的可点击状态
     */
    private fun setBtnConfirmEnable(isConnected: Boolean) {
        mBtnConfirm?.isEnabled = (mInputCompleteFlag && isConnected)
    }


    private fun showChooseAppDialog() {
        mChooseAppDialog = CommonUtils.createChooseAppDialog(this)
        mChooseAppDialog?.show()
    }

    /**
     * 非WIFI网络下提示弹框
     */
    private fun showNotUsingWiFiDialog() {
        val dialog: AlertDialog = AlertDialog.Builder(this@CloudMainActivity1)
                .setMessage(getString(R.string.wecast_not_wifi_tips))
                .setPositiveButton(getString(R.string.wecast_continue_text)) { _, _ ->
                    setCapturePermission()
                }
                .setNegativeButton(getString(R.string.wecast_cancel_text)) { dialog, _ ->
                    dialog.dismiss()
                }
                .setCancelable(false)
                .create()
        dialog.show()
        dialog.getButton(Dialog.BUTTON_POSITIVE)?.setTextColor(
                ContextCompat.getColor(applicationContext,
                        R.color.wecast_common_font_color_1))
        dialog.getButton(Dialog.BUTTON_NEGATIVE)?.setTextColor(
                ContextCompat.getColor(applicationContext,
                        R.color.wecast_lock_screen_bg_blue_color))
    }

    private fun showDiffSSIDWifiDialog(ssid: String) {
        val dialog: AlertDialog = AlertDialog.Builder(this@CloudMainActivity1)
                .setTitle(getString(R.string.wecast_note_title))
                .setMessage(String.format(getString(R.string.wecast_connect_the_wifi_tips), ssid))
                .setPositiveButton(getString(R.string.wecast_confirm_text)) { dialog, _ ->
                    dialog.dismiss()
                }
                .setCancelable(false)
                .create()
        dialog.show()
        dialog.getButton(Dialog.BUTTON_POSITIVE)?.setTextColor(
                ContextCompat.getColor(applicationContext,
                        R.color.wecast_common_font_color_1))
    }

    /**
     * 息屏设置提示
     */
    private fun tryShowScreenOutSettingDialogFirst() {
        try {
            if (!(mMainSP!!.getBoolean(KEY_SCREEN_OUT_ALERT_FIRST_SHOW, false))) {
                mMainSP!!.edit().putBoolean(KEY_SCREEN_OUT_ALERT_FIRST_SHOW, true).apply()
                ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_SCREEN_OUT_FIRST_FORCE_SHOW_DIALOG, 0, "")
                showScreenOutSettingDialog()
            }
        } catch (e: Exception) {
            Logger.t(TAG).e("tryShowScreenOutSettingDialogFirst e = $e")
        }
    }

    private fun showScreenOutSettingDialog() {
        ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_SCREEN_OUT_SHOW_DIALOG, 0, "")
        val positiveTxt = if (mScreenOutSettingInfo.intentType
                == SettingUtils.ScreenOutSettingInfo.INTENT_TYPE_NONE) getString(R.string.wecast_confirm_text) else getString(R.string.wecast_go_setting)
        val screenOutDialog: AlertDialog = AlertDialog.Builder(this@CloudMainActivity1)
                .setMessage(mScreenOutSettingInfo.message)
                .setPositiveButton(positiveTxt) { dialog, _ ->
                    dialog.dismiss()
                    if (mScreenOutSettingInfo.intentType
                            != SettingUtils.ScreenOutSettingInfo.INTENT_TYPE_NONE) {
                        jumpScreenOutSetting()
                    }
                }
                .setNegativeButton(getString(R.string.wecast_cancel_text)
                ) { dialog, _ ->
                    dialog.dismiss()
                }
                .setCancelable(true)
                .create()

        screenOutDialog.show()
        screenOutDialog.getButton(Dialog.BUTTON_POSITIVE)?.setTextColor(
                ContextCompat.getColor(applicationContext,
                        R.color.wecast_lock_screen_bg_blue_color))
        screenOutDialog.getButton(Dialog.BUTTON_NEGATIVE)?.setTextColor(
                ContextCompat.getColor(applicationContext,
                        R.color.wecast_lock_screen_bg_blue_color))
    }

    private fun jumpScreenOutSetting() {
        try {
            ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_SCREEN_OUT_DIALOG_CLICK_SETTING, 0, "")
            startActivity(mScreenOutSettingInfo.intent)
        } catch (t: Throwable) {
            Logger.t(TAG).e("jumpScreenOutSetting t = $t")
        }
    }

    private fun getSdkTips(): String? {
        return mNativeTips +
                "\n======= NetWork Diagnosis Tips =======\n" +
                NetWorkDiagnosisUtil.getNetWorkDiagnosisInfo()
    }

    private fun showTipsUI(showFlag: Boolean) {
        mShowTipsFlag = showFlag

        if (showFlag) {
            mTvQualityTips?.text = getSdkTips()
        }
        mSvTips?.visibility = if (showFlag) View.VISIBLE else View.GONE
    }

    private fun tryShowTips() {
        if (mShowTipsFlag) {
            showTipsUI(false)
        } else {
            /**
             * 3秒5下开启tips
             */
            val currentTimeMs = System.currentTimeMillis()
            if (currentTimeMs - mLastTapTimeMs > 3 * 1000) {
                mLastTapTimeMs = currentTimeMs
                mTapTimes = 0
            } else {
                mTapTimes++
            }

            if (mTapTimes >= 4) {
                mLastTapTimeMs = 0
                mTapTimes = 0
                showTipsUI(true)
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onEnterLoadingEvent(event: SenderEvents.EEnterLoading) {
        Logger.t(TAG).d("onEnterLoadingEvent isLoading = ${event.isLoading}")

        if (event.isLoading) {
            showEnteringTips()
        } else {
            hideEnteringTips()
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onShowErrorEvent(event: SenderEvents.EShowError) {
        Logger.t(TAG).d("onShowErrorEvent errorCode = ${event.errorCode}")

        if (event.errorCode != 0) {
            showNormalAlert(ErrorUtils.getErrorMsg(baseContext, event.errorCode))
        } else {
            hideNormalAlert()
            hideAlertInRoom(ALERT_TYPE_NET_DISCONNECTED)
        }
        setBtnConfirmEnable(event.errorCode == 0)
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onPushToCastingEvent(event: SenderEvents.EPushToCastingView) {
        Logger.t(TAG).d("onPushToCastingEvent")
        mEtPinCode?.setText("")
        setUIState(UI_STATE_IN_ROOM)
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onExitCastViewEvent(event: SenderEvents.EExitCastView) {
        Logger.kp().i("Exit casting: ${event.exitReason}")
        mIsXCastPause = false

        setUIState(UI_STATE_WAITING)

        try {
            stopSSDPJobService()
        } catch (e: Exception) {
        }

        dealExitOrDisconnect()
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onEditFocusEvent(event: SenderEvents.EEditFocus) {
        Logger.t(TAG).d("onEditFocusEvent")
        mEtPinCode?.requestFocus()
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onClearEditEvent(event: SenderEvents.EClearEdit) {
        Logger.t(TAG).d("onClearEditEvent")
        mEtPinCode?.setText("")
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onNetWorkStateTipsEvent(event: SenderEvents.ENetWorkStateTips) {
        Logger.t(TAG).d("onNetWorkStateTipsEvent isDisconnected = ${event.isDisconnected}")

        if (event.isDisconnected) {
            showNetDisconnectedAlert(true)
        } else {
            showNetDisconnectedAlert(false)
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onUpdateReceiverMemberEvent(event: SenderEvents.EUpdateReceiverMember) {
        //Logger.t(TAG).d("onUpdateReceiverMemberEvent memberListJsonStr = ${event.memberListJsonStr}")
        try {
            val memberListJson = GsonUtil.getGson().fromJson(event.memberListJsonStr, JsonArray::class.java)
            var receiverName = ""
            for (member in memberListJson) {
                receiverName = member.asJsonObject.get("device_name").asString
            }

            mTvNotice?.text = resources.getString(R.string.wecast_main_in_room_notice_text_1, receiverName)
        } catch (e: Exception) {
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onMultiCastDiscoveryEvent(event: SenderEvents.EMultiCastDiscovery) { // 进房时回调
        mGCastRsp = event.mEMultiCastDiscoveryGoogleCastRsp
        startSSDPJobService(event.mEMultiCastDiscoveryDLNARsp, event.mEMultiCastDiscoveryGoogleCastRsp, 1L)
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    fun onCanRecoverEvent(event: SenderEvents.ECanRecover) {
        Logger.kp().d("Start recovery casting.")
        mIsRecover = true

        if (!WeCastUtil.hasCapturePermission()) {
            setCapturePermission()
        } else {
            CloudUtil.JniMethod.recoverCast(false)
        }

        EventBusUtil.removeStick(event)
    }


    @Subscribe(sticky = false, threadMode = ThreadMode.MAIN)
    fun onXCastPauseEvent(event: SenderEvents.EXCastPause) {
        Logger.kp().d("XCast pause state: ${event.isPause}")
        mIsXCastPause = event.isPause
    }

    private var mIsXCastPause = false
    @Subscribe(sticky = false, threadMode = ThreadMode.MAIN)
    fun onC2CMessageEvent(event: SenderEvents.EC2CMessage) {
        Logger.kp().d("Handle C2C message: " +
                "{dataType:${event.cmd}, " +
                "data:${event.data}}")
        val c2cMessage = WeCastC2CUtil.parse(event.cmd, event.data)
        if (c2cMessage is C2CPauseXCastMsg) {
            if (c2cMessage.isPause != mIsXCastPause) {
                mIsXCastPause = c2cMessage.isPause
                Logger.t(TAG).d("pause xcast > $mIsXCastPause")
                JniHelper.callJniFunc("pauseXCast")
            }
        } else if (c2cMessage is C2CPushUpdateMsg && (c2cMessage.updateType == "dlna")) { // 是pushUpdate消息并且key为dlna则重启DLNA服务
            restartSSDPJobService(c2cMessage.data, mGCastRsp, 1000L)
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onShowTips(event: SenderEvents.EShowTips) {
        mNativeTips = event.tips
        if (mSvTips?.visibility == View.VISIBLE) {
            showTipsUI(true)
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onStopCast(event: SenderEvents.EStopCast) {
        //退出Casting
        if (WeCastInfo.instance.isCasting) {
            CloudUtil.JniMethod.exitCast(0)
        }
        WeCastInfo.instance.isCasting = false
        //退出WeCast
        finish()
    }

    private fun registerScreenOffBroadCast() {
        try {
            /** 注册息屏事件 当在房间中 屏幕熄灭触发**/
            val filter = IntentFilter()
            filter.addAction(Intent.ACTION_SCREEN_OFF)
            mScreenOffReceiver = object : BroadcastReceiver() {
                override fun onReceive(context: Context?, intent: Intent?) {
                    if (intent != null) {
                        val action = intent.action
                        if (Intent.ACTION_SCREEN_OFF == action) {
                            if (mCurrentUIState == UI_STATE_IN_ROOM) {
                                Logger.t(TAG).d("screenOffReceiver action = $action")
                                ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_SCREEN_OUT, 0, "")
                            }
                        }
                    }
                }
            }
            applicationContext.registerReceiver(mScreenOffReceiver, filter)
        } catch (e: Exception) {
            Logger.t(TAG).e("Exception: " + e.toString())
        }
    }

    private fun startSSDPJobService(dlnaRsp: String, GCastRsp: String?, latency: Long) {
        if (mJobScheduler == null) {
            mJobScheduler = applicationContext.getSystemService(Context.JOB_SCHEDULER_SERVICE) as JobScheduler
        }
        val bundle = PersistableBundle()
        bundle.putString(SSDPDiscoveryJobService.DLNA_RESPONSE_KEY, dlnaRsp)
        bundle.putString(SSDPDiscoveryJobService.GOOGLECAST_RESPONSE_KEY, GCastRsp)
        val builder: JobInfo.Builder = JobInfo.Builder(SSDP_JOB_ID,
                ComponentName(applicationContext, SSDPDiscoveryJobService::class.java))
        builder.setMinimumLatency(latency)
        builder.setPersisted(false)
        builder.setExtras(bundle)
        mJobScheduler?.schedule(builder.build())
    }

    private fun stopSSDPJobService() {
        mJobScheduler?.cancel(SSDP_JOB_ID)
    }

    private fun restartSSDPJobService(dlnaRsp: String, GCastRsp: String?, latency: Long) {
        stopSSDPJobService()
        startSSDPJobService(dlnaRsp, GCastRsp, latency)
    }

    private fun setCapturePermission() {
        if (WeCastInfo.instance.usingMirror) {
            Logger.t(TAG).d("set capture permission.")
            /** 从 assets 中拷贝 xcast 流控配置文件 到 sdcard 中  **/
            WeCastUtil.copyXcastConfFromAssets2SDCard(JniHelper.getAppContext())

            val mMediaProjectionManager = getSystemService(Context.MEDIA_PROJECTION_SERVICE) as MediaProjectionManager
            val reqIntent = mMediaProjectionManager.createScreenCaptureIntent()
            startActivityForResult(reqIntent, REQUEST_MEDIA_PROJECTION)
        } else {
            if (!mIsRecover) {
                enterCast()
            } else {
                CloudUtil.JniMethod.recoverCast(false)
            }
            mIsRecover = false
        }
    }
}
