package com.tencent.wecast.sender.cloud

import android.app.Activity
import android.content.Context
import android.os.Build
import android.os.LocaleList
import com.tencent.wecast.WeCastConfigManager
import com.tencent.wecast.WeCastConstant
import com.tencent.wecast.sender.cloud.bean.WeCastInfo
import com.tencent.wecast.sender.cloud.utils.CloudUtil
import com.tencent.wecast.sender.eb.SenderEvents
import com.tencent.wecast.utils.EventBusUtil
import com.tencent.wecast.utils.Logger
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode
import java.util.*


object WeCast {
    @JvmField
    val LANGUAGE_ZH_CN = 0
    @JvmField
    val LANGUAGE_ZH_TW = 1
    @JvmField
    val LANGUAGE_EN = 2

    @JvmField
    val CAST_STATE_READY = 0
    @JvmField
    val CAST_STATE_CASTING = 1
    @JvmField
    val CAST_STATE_ClOSED = 2


    private const val TAG = "WeCast"

    private var mOnWeCastRunListener: OnWeCastRunListener? = null

    public interface OnWeCastRunListener {
        fun onAuthCodeError()
    }

    fun run(activity: Activity, corpId: String, authCode: String, userName: String) {
        run(activity, corpId, authCode, userName, null)
    }

    fun run(activity: Activity,
            corpId: String,
            authCode: String,
            userName: String,
            onWeCastRunListener: OnWeCastRunListener?,
            usingMirror: Boolean = true) {
        EventBusUtil.register(this)
        if (onWeCastRunListener != null) {
            this.mOnWeCastRunListener = onWeCastRunListener
        }
        WeCastInfo.instance.corpId = corpId
        WeCastInfo.instance.usingMirror = usingMirror
        if (!isRunning()) {
            WeCastInfo.instance.authCode = authCode
            CloudUtil.jump2WeCastPinPage(activity, WeCastInfo.instance.corpId,
                    WeCastInfo.instance.authCode, userName, usingMirror)
        } else {
            CloudUtil.jump2WeCastPage(activity)
        }
        WeCastInfo.instance.isRunning = true
    }

    fun stop() {
        EventBus.getDefault().post(SenderEvents.EStopCast())
        EventBusUtil.unregister(this)
    }

    fun isRunning(): Boolean {
        return WeCastInfo.instance.isRunning
    }

    fun isCasting(): Boolean {
        return WeCastInfo.instance.isCasting
    }

    fun setLimitSSID(ssid: String) {
        CloudUtil.setLimitSSID(ssid)
    }

    /**
     * 设置投屏语言
     * @params: type - 语言类型
     *              0 - 中文简体
     *              1 - 中文繁体
     *              2 - 英文
     */
    fun setLanguage(context: Context, type: Int) {
        WeCastConfigManager.getInstance().languageType = type
        setApplicationLanguage(context)
    }

    fun setCastStateChangeListener(listener: WeCastInfo.OnCastStateChangeListener) {
        WeCastInfo.instance.mStateChangeListener = listener
    }

    fun version(): String {
        return WeCastConstant.WECAST_VERSION
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onAuthCodeError(event: SenderEvents.EAuthCodeError) {
        Logger.t(TAG).d("onAuthCodeError")
        mOnWeCastRunListener?.onAuthCodeError()
    }

    private fun setApplicationLanguage(context: Context) {
        val resources = context.applicationContext.resources
        val dm = resources.displayMetrics
        val config = resources.configuration
        val locale = WeCastConfigManager.getInstance().languageLocale
        config.locale = locale
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            val localeList = LocaleList(locale)
            LocaleList.setDefault(localeList)
            config.locales = localeList
            context.applicationContext.createConfigurationContext(config)
            Locale.setDefault(locale)
        }
        resources.updateConfiguration(config, dm)
    }
}