/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.support.annotation.NonNull;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.RefCountDelegate;
import java.util.Locale;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

class EGLCore10
extends RefCountDelegate
implements EGLCoreContext {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    static final int[] CONFIG_RGB = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12344};
    static final int[] CONFIG_RGBA = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344};
    static int[] CONTEXT_ATTR = new int[]{12440, 2, 12344};
    @NonNull
    private EGL10 mEGL10 = (EGL10)EGLContext.getEGL();
    private EGLDisplay mEGLDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLSurface mEGLSurface = EGL10.EGL_NO_SURFACE;
    private EGLContext mEGLContext = EGL10.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private boolean mIsOffscreen = false;

    EGLCore10(int n2) {
        EGLCore10.CONTEXT_ATTR[1] = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createContext(EGLCoreContext eGLCoreContext, boolean bl) {
        if (eGLCoreContext != null && !(eGLCoreContext instanceof EGLCore10)) {
            Platform.logError("create.shared.context.type.error");
            return false;
        }
        this.mEGLDisplay = this.mEGL10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int[] nArray = new int[2];
        this.mEGL10.eglInitialize(this.mEGLDisplay, nArray);
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[1];
        if (!this.mEGL10.eglChooseConfig(this.mEGLDisplay, bl ? CONFIG_RGBA : CONFIG_RGB, eGLConfigArray, eGLConfigArray.length, nArray2) || nArray2[0] == 0) {
            Platform.logError("no.config.found");
            return false;
        }
        this.mEGLConfig = eGLConfigArray[0];
        EGLContext eGLContext = eGLCoreContext != null ? ((EGLCore10)eGLCoreContext).mEGLContext : EGL10.EGL_NO_CONTEXT;
        Object object = EGLCore.sLock;
        synchronized (object) {
            this.mEGLContext = this.mEGL10.eglCreateContext(this.mEGLDisplay, this.mEGLConfig, eGLContext, CONTEXT_ATTR);
        }
        if (EGLCore.LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.createContext.ctx.%h.tid.%d", this, this.mEGLContext, Thread.currentThread().getId()));
        }
        return this.hasContext();
    }

    @Override
    public void destroyContext() {
        if (EGLCore.LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.destroyContext.ctx.%h.tid.%d", this, this.mEGLContext, Thread.currentThread().getId()));
        }
        if (this.hasContext()) {
            this.mEGL10.eglDestroyContext(this.mEGLDisplay, this.mEGLContext);
            this.mEGLContext = EGL10.EGL_NO_CONTEXT;
        }
        if (!this.mEGLDisplay.equals(EGL10.EGL_NO_DISPLAY)) {
            this.mEGL10.eglTerminate(this.mEGLDisplay);
            this.mEGLDisplay = EGL10.EGL_NO_DISPLAY;
        }
        this.mEGLConfig = null;
    }

    @Override
    public boolean createSurface(Object object) {
        if (!this.hasContext()) {
            Platform.logError("mEGLContext.not.initialized");
            return false;
        }
        this.destroySurface();
        if (object != null) {
            try {
                int[] nArray = new int[]{12344};
                this.mEGLSurface = this.mEGL10.eglCreateWindowSurface(this.mEGLDisplay, this.mEGLConfig, object, nArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Platform.logError(String.format(Locale.CHINA, "%h.eglCreateWindowSurface.%s", this, illegalArgumentException.toString()));
                return false;
            }
            this.mIsOffscreen = false;
        } else {
            int[] nArray = new int[]{12375, 1, 12374, 1, 12376, 1, 12344};
            this.mEGLSurface = this.mEGL10.eglCreatePbufferSurface(this.mEGLDisplay, this.mEGLConfig, nArray);
            this.mIsOffscreen = true;
        }
        if (EGLCore.LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.createSurface.ctx.%h.sf.%h.tid.%d", this, this.mEGLContext, this.mEGLSurface, Thread.currentThread().getId()));
        }
        if (this.hasSurface()) {
            this.makeCurrent();
        }
        return true;
    }

    @Override
    public void destroySurface() {
        if (EGLCore.LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.destroySurface.ctx.%h.sf.%h.tid.%d", this, this.mEGLContext, this.mEGLSurface, Thread.currentThread().getId()));
        }
        if (this.hasSurface()) {
            this.detachCurrent();
            this.mEGL10.eglDestroySurface(this.mEGLDisplay, this.mEGLSurface);
            this.mEGLSurface = EGL10.EGL_NO_SURFACE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int makeCurrent() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            return this.mEGL10.eglMakeCurrent(this.mEGLDisplay, this.mEGLSurface, this.mEGLSurface, this.mEGLContext) ? 12288 : this.mEGL10.eglGetError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachCurrent() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            this.mEGL10.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        }
    }

    @Override
    public boolean isCurrentContext() {
        return this.mEGLContext.equals(this.mEGL10.eglGetCurrentContext()) && this.mEGLSurface.equals(this.mEGL10.eglGetCurrentSurface(12377));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int swapBuffers() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            return this.mIsOffscreen || this.mEGL10.eglSwapBuffers(this.mEGLDisplay, this.mEGLSurface) ? 12288 : this.mEGL10.eglGetError();
        }
    }

    @Override
    public int swapBuffers(long l2) {
        return this.swapBuffers();
    }

    @Override
    public boolean hasContext() {
        return !this.mEGLContext.equals(EGL10.EGL_NO_CONTEXT);
    }

    @Override
    public boolean hasSurface() {
        return !this.mEGLSurface.equals(EGL10.EGL_NO_SURFACE);
    }

    @Override
    public String eglQueryString(int n2) {
        return this.mEGL10.eglQueryString(this.mEGLDisplay, n2);
    }

    @Override
    public int eglGetError() {
        return this.mEGL10.eglGetError();
    }

    @Override
    public int release() {
        int n2 = super.release();
        if (n2 == 0) {
            this.destroySurface();
            this.destroyContext();
        }
        return n2;
    }
}

