/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.av.mediacodec;

import android.graphics.SurfaceTexture;
import android.support.annotation.AnyThread;
import android.support.annotation.WorkerThread;
import android.view.Surface;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLUtil;
import com.tencent.xcast.SurfaceTextureHolder;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class MediaCodecSurface {
    private static final String TAG = "MediaCodecSurface";
    private SurfaceTextureHolder mDecoderTextureHolder;
    private int mWidth;
    private int mHeight;
    private Surface mSurface;
    private final Semaphore mSemaphore = new Semaphore(0);

    @AnyThread
    private MediaCodecSurface(int n2, int n3) {
        this.mWidth = n2;
        this.mHeight = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public int createSurface() {
        EGLCore eGLCore = new EGLCore();
        try {
            if (!eGLCore.createContext(EGLUtil.getOffscreenContext(), true)) {
                throw new IllegalArgumentException("createContext.failed");
            }
            if (!eGLCore.createSurface(null)) {
                throw new IllegalArgumentException("createSurface.failed");
            }
            this.mDecoderTextureHolder = new SurfaceTextureHolder(this.mWidth, this.mHeight, (SurfaceTextureHolder.EventCallback)new SurfaceHolderEvent(this.mSemaphore), eGLCore);
            this.mSurface = this.mDecoderTextureHolder.getSurface();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Platform.logError("createMediaCodecSurface.failed");
            int n2 = -1;
            return n2;
        }
        finally {
            eGLCore.release();
        }
        return 0;
    }

    @AnyThread
    public Surface getSurface() {
        return this.mSurface;
    }

    @AnyThread
    public SurfaceTextureHolder getSurfaceHolder() {
        return this.mDecoderTextureHolder;
    }

    @AnyThread
    public void setSize(int n2, int n3) {
        this.mWidth = n2;
        this.mHeight = n3;
    }

    @AnyThread
    public int getFrameAvailable(long l2) {
        int n2;
        try {
            n2 = this.mSemaphore.tryAcquire(l2, TimeUnit.MICROSECONDS) ? 0 : -2;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return -2;
        }
        return this.mSurface != null ? n2 : -1;
    }

    @AnyThread
    public void release() {
        this.mSurface = null;
        this.mDecoderTextureHolder.release();
        this.mDecoderTextureHolder = null;
        this.mSemaphore.release();
    }

    private static class SurfaceHolderEvent
    implements SurfaceTextureHolder.EventCallback {
        private final Semaphore mParentSemaphore;

        SurfaceHolderEvent(Semaphore semaphore) {
            this.mParentSemaphore = semaphore;
        }

        @Override
        public void onFrameAvailable(SurfaceTextureHolder surfaceTextureHolder, SurfaceTexture surfaceTexture) {
            this.mParentSemaphore.release();
        }

        @Override
        public void onRelease(SurfaceTextureHolder surfaceTextureHolder) {
        }
    }
}

