package com.tencent.wecast.utils;

import android.os.Environment;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class SysLogPathUtil {

    private static final String WMP_SYS_LOGCAT_FILE_PREFIX = "wmp_sysLogcat";
    private static final String SDCARD_ROOT = Environment.getExternalStorageDirectory().getAbsolutePath();
    private static final String WMP_ROOT = SDCARD_ROOT + File.separatorChar + "Tencent" + File.separatorChar + "Wmp";
    public static final int TYPE_ERROR_KERNEL = 0;
    public static final int TYPE_KERNEL_INIT = 1;
    public static final int TYPE_LOGCAT = 2;

    /**
     * 获取当前System Logcat的日志名
     *
     * @param type TYPE_ERROR_KERNEL/TYPE_KERNEL_INIT/TYPE_LOGCAT
     */
    public static File getCurWmpSysLogcatFileName(int type, String packageName) {
        File logcatDirPath = new File(getWmpSysLogcatDirPath(packageName));
        if (!logcatDirPath.exists()) {
            logcatDirPath.mkdirs();
        }

        // 当前时间 yyyyMMdd
        Calendar now = Calendar.getInstance();
        now.set(Calendar.HOUR, 0);
        now.set(Calendar.MINUTE, 0);
        now.set(Calendar.SECOND, 0);
        now.set(Calendar.MILLISECOND, 0);
        now.set(Calendar.HOUR_OF_DAY, 0);

        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
        String dateString = formatter.format(now.getTime());
        long nowDateTimestamp = now.getTimeInMillis();

        // android 无法获取创建时间，所有将创建时间时间戳，写入文件名
        return new File(logcatDirPath, String.format(Locale.getDefault(),"%s_%s_%d.csv",
                getWmpSysLogcatFilePrefix(type), dateString, nowDateTimestamp));
    }

    /**
     * System Logcat路径
     */
    private static String getWmpSysLogcatDirPath(String packageName) {
        return WMP_ROOT + File.separatorChar + packageName + File.separatorChar + "log";
    }

    /**
     * sysLogcat日志前缀
     *
     * @param type TYPE_ERROR_KERNEL/TYPE_KERNEL_INIT/TYPE_LOGCAT
     */
    private static String getWmpSysLogcatFilePrefix(int type) {
        if (type == TYPE_ERROR_KERNEL) {
            return WMP_SYS_LOGCAT_FILE_PREFIX + "_kernel_error";
        }
        if (type == TYPE_KERNEL_INIT) {
            return WMP_SYS_LOGCAT_FILE_PREFIX + "_kernel_init";
        }
        return WMP_SYS_LOGCAT_FILE_PREFIX;
    }
}
