package com.tencent.wecast.sender.cloud.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.BaseAdapter
import android.widget.TextView
import com.tencent.wecast.WeCastUIConfigManager
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.bean.MemberInfo


class UserListAdapter(context: Context, private val mUserInfoList: List<MemberInfo>?) : BaseAdapter() {
    private val inflater: LayoutInflater = LayoutInflater.from(context)
    private val mContext = context
    override fun getCount(): Int {
        return mUserInfoList?.size ?: 0
    }

    override fun getItem(position: Int): Any? {
        return if (mUserInfoList == null || position >= mUserInfoList.size) {
            null
        } else {
            mUserInfoList[position]
        }
    }

    override fun getItemId(position: Int): Long {
        return position.toLong()
    }

    override fun getView(position: Int, convertView: View?, parent: ViewGroup): View {
        var rootView: View? = null
        val viewHolder: ViewHolder
        if (rootView == null) {
            rootView = WeCastUIConfigManager.getInstance().getLayoutRootView(
                    WeCastUIConfigManager.ActivityLabel.SENDER_USER_LIST, mContext)
            WeCastUIConfigManager.getInstance().applyUIConfig(WeCastUIConfigManager.ActivityLabel.SENDER_USER_LIST, rootView)
            viewHolder = ViewHolder()
            viewHolder.tvUserName = rootView!!.findViewById(R.id.tv_show_user_name) as TextView
            rootView.tag = viewHolder
        } else {
            viewHolder = rootView.tag as ViewHolder
        }

        val userInfo = mUserInfoList!![position]
        viewHolder.tvUserName!!.text = userInfo.userName

        return rootView
    }

    internal class ViewHolder {
        var tvUserName: TextView? = null
    }
}
