/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.BasicTexture;
import com.tencent.xcast.EGLUtil;
import com.tencent.xcast.GLCanvas;
import com.tencent.xcast.GLES20IdImpl;
import com.tencent.xcast.GLPaint;
import com.tencent.xcast.GLThread;
import com.tencent.xcast.Log;
import com.tencent.xcast.PreAllocIntArray;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 {2\u00020\u0001:\u0006z{|}~\u007fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013H\u0016J\b\u0010*\u001a\u00020(H\u0002J(\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020-H\u0016J\u0010\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020\u0004H\u0016J\b\u00103\u001a\u00020(H\u0016J\u0010\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\u0004H\u0016JP\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020-H\u0002J@\u00106\u001a\u00020(2\u0006\u0010@\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020-H\u0002J0\u0010A\u001a\u00020(2\u0006\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020-2\u0006\u0010D\u001a\u00020-2\u0006\u0010E\u001a\u00020-2\u0006\u0010F\u001a\u00020GH\u0016J0\u0010H\u001a\u00020(2\u0006\u0010I\u001a\u00020J2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0016J \u0010K\u001a\u00020(2\u0006\u0010I\u001a\u00020J2\u0006\u0010L\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020\u001bH\u0002J \u0010K\u001a\u00020(2\u0006\u0010I\u001a\u00020J2\u0006\u0010N\u001a\u00020\u00132\u0006\u0010M\u001a\u00020\u001bH\u0002J\b\u0010O\u001a\u00020(H\u0016J\u0010\u0010P\u001a\u00020(2\u0006\u0010P\u001a\u00020QH\u0002J0\u0010R\u001a\u00020(2\u0006\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020\u0004H\u0016J\u0010\u0010S\u001a\u00020\u00132\u0006\u0010>\u001a\u00020\u0004H\u0002J\u0018\u0010T\u001a\u00020(2\u0006\u0010I\u001a\u00020J2\u0006\u0010U\u001a\u00020VH\u0016J \u0010W\u001a\u00020(2\u0006\u0010I\u001a\u00020J2\u0006\u0010X\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0016J \u0010Y\u001a\u00020(2\u0006\u00108\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020-H\u0002J\u0012\u0010Z\u001a\u0004\u0018\u00010\u00182\u0006\u0010I\u001a\u00020JH\u0002J\b\u0010[\u001a\u00020(H\u0016J\b\u0010\\\u001a\u00020(H\u0017J\b\u0010]\u001a\u00020(H\u0016J(\u0010^\u001a\u00020(2\u0006\u0010_\u001a\u00020-2\u0006\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020-2\u0006\u0010`\u001a\u00020-H\u0016J\b\u0010a\u001a\u00020(H\u0016J\u0010\u0010a\u001a\u00020(2\u0006\u0010b\u001a\u00020\u0004H\u0016J \u0010c\u001a\u00020(2\u0006\u0010d\u001a\u00020-2\u0006\u0010e\u001a\u00020-2\u0006\u0010f\u001a\u00020-H\u0016J0\u0010g\u001a\u00020(2\u0006\u0010@\u001a\u00020\u00182\u0006\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020-H\u0002J\u0018\u0010h\u001a\u00020(2\u0006\u0010@\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0004H\u0002J\u0018\u0010i\u001a\u00020(2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0016J\u0010\u0010j\u001a\u00020(2\u0006\u0010L\u001a\u00020\u001bH\u0002J\u0010\u0010k\u001a\u00020(2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010l\u001a\u00020(2\u0006\u0010m\u001a\u00020\u0004H\u0002J\b\u0010n\u001a\u00020(H\u0002J8\u0010o\u001a\u00020(2\u0006\u0010I\u001a\u00020J2\u0006\u0010p\u001a\u00020\u00042\u0006\u0010q\u001a\u00020\u00042\u0006\u0010U\u001a\u00020V2\u0006\u0010X\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0016J\u0018\u0010r\u001a\u00020(2\u0006\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020-H\u0016J \u0010r\u001a\u00020(2\u0006\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020-2\u0006\u0010`\u001a\u00020-H\u0016J\u0010\u0010s\u001a\u00020Q2\u0006\u0010I\u001a\u00020JH\u0016J\u0018\u0010t\u001a\u00020\u00042\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020\u0004H\u0002J\u0010\u0010t\u001a\u00020\u00042\u0006\u0010u\u001a\u00020xH\u0016J\u0010\u0010t\u001a\u00020\u00042\u0006\u0010u\u001a\u00020yH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010!\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006\u0080\u0001"}, d2={"Lcom/tencent/xcast/GLES20Canvas;", "Lcom/tencent/xcast/GLCanvas;", "()V", "_boxCoordinates", "", "_clipRect", "Ljava/util/ArrayList;", "Landroid/graphics/Rect;", "_countDrawLine", "_countFillRect", "_countTextureRect", "_currentClipIndex", "_currentMatrixIndex", "_deleteBuffers", "Lcom/tencent/xcast/PreAllocIntArray;", "_drawProgram", "Lcom/tencent/xcast/GLES20Canvas$GLES20Program;", "_height", "_matrices", "", "_projectionMatrix", "_saveFlags", "_tempColor", "_tempIntArray", "", "_tempMatrix", "_tempSourceRect", "Landroid/graphics/RectF;", "_tempTargetRect", "_tempTextureMatrix", "_texturesProgram", "", "[Lcom/tencent/xcast/GLES20Canvas$GLES20Program;", "_unboundTextures", "_width", "id", "Lcom/tencent/xcast/GLES20IdImpl;", "getId", "()Lcom/tencent/xcast/GLES20IdImpl;", "clearBuffer", "", "argb", "clearClip", "clip", "l", "", "t", "r", "b", "deleteBuffer", "bufferId", "deleteRecycledResources", "deleteTexture", "texId", "draw", "type", "offset", "count", "x", "y", "width", "height", "color", "lineWidth", "params", "drawLine", "x1", "y1", "x2", "y2", "paint", "Lcom/tencent/xcast/GLPaint;", "drawTexture", "texture", "Lcom/tencent/xcast/BasicTexture;", "drawTextureRect", "source", "target", "textureMatrix", "dumpStatisticsAndClear", "enableBlending", "", "fillRect", "getColor", "initializeTexture", "bitmap", "Landroid/graphics/Bitmap;", "initializeTextureSize", "format", "prepareDraw", "prepareTexture", "recoverFromLightCycle", "release", "restore", "rotate", "angle", "z", "save", "saveFlags", "scale", "sx", "sy", "sz", "setMatrix", "setPosition", "setSize", "setTextureMatrix", "setTextureParameters", "setupBlendingParam", "blendMode", "setupClip", "texSubImage2D", "xOffset", "yOffset", "translate", "unloadTexture", "uploadBuffer", "buffer", "Ljava/nio/Buffer;", "elementSize", "Ljava/nio/ByteBuffer;", "Ljava/nio/FloatBuffer;", "AttributeShaderParameter", "Companion", "GLES20Program", "GLES20ProgramCreator", "ShaderParameter", "UniformShaderParameter", "libxcast_release"})
public final class GLES20Canvas
implements GLCanvas {
    private float[] _matrices = new float[128];
    private final ArrayList<Rect> _clipRect = new ArrayList();
    private final PreAllocIntArray _saveFlags = new PreAllocIntArray();
    private int _currentMatrixIndex;
    private int _currentClipIndex;
    private int _width;
    private int _height;
    private final float[] _projectionMatrix = new float[16];
    private final GLES20Program[] _texturesProgram;
    private final GLES20Program _drawProgram;
    private int _boxCoordinates;
    private final PreAllocIntArray _unboundTextures = new PreAllocIntArray();
    private final PreAllocIntArray _deleteBuffers = new PreAllocIntArray();
    private int _countTextureRect;
    private int _countFillRect;
    private int _countDrawLine;
    private final float[] _tempMatrix = new float[32];
    private final float[] _tempColor = new float[4];
    private final RectF _tempSourceRect = new RectF();
    private final RectF _tempTargetRect = new RectF();
    private final float[] _tempTextureMatrix = new float[16];
    private final int[] _tempIntArray = new int[1];
    @NotNull
    private final GLES20IdImpl id = new GLES20IdImpl();
    private static final String TAG = "GLES20Canvas";
    private static boolean DEBUG_LOG;
    public static final int BLENDMODE_SRCOVER = 0;
    public static final int BLENDMODE_NONE = 2;
    public static final int BLENDMODE_XOR = 9;
    public static final int BLENDMODE_AND = 10;
    private static final int FLOAT_SIZE = 4;
    private static final int COORDS_PER_VERTEX = 2;
    private static final int VERTEX_STRIDE = 8;
    private static final int COUNT_FILL_VERTEX = 4;
    private static final int COUNT_LINE_VERTEX = 2;
    private static final int OFFSET_FILL_RECT = 0;
    private static final int OFFSET_DRAW_LINE = 4;
    private static final float[] BOX_COORDINATES;
    private static final String POSITION_ATTRIBUTE = "aPosition";
    private static final String COLOR_UNIFORM = "uColor";
    private static final String MATRIX_UNIFORM = "uMatrix";
    private static final String TEXTURE_MATRIX_UNIFORM = "uTextureMatrix";
    private static final String TEXTURE_SAMPLER_UNIFORM0 = "uTextureSampler0";
    private static final String TEXTURE_SAMPLER_UNIFORM1 = "uTextureSampler1";
    private static final String TEXTURE_SAMPLER_UNIFORM2 = "uTextureSampler2";
    private static final String ALPHA_UNIFORM = "uAlpha";
    private static final String DRAW_VERTEX_SHADER = "uniform mat4 uMatrix;\nattribute vec2 aPosition;\nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n  gl_Position = uMatrix * pos;\n}\n";
    private static final String DRAW_FRAGMENT_SHADER = "precision mediump float;\nuniform vec4 uColor;\nvoid main() {\n  gl_FragColor = uColor;\n}\n";
    private static final String TEXTURE_VERTEX_SHADER = "uniform mat4 uMatrix;\nuniform mat4 uTextureMatrix;\nattribute vec2 aPosition;\nvarying vec2 vTextureCoord;\nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n  gl_Position = uMatrix * pos;\n  vTextureCoord = (uTextureMatrix * pos).xy;\n}\n";
    private static final String ARGB_TEXTURE_FRAGMENT_SHADER = "%sprecision mediump float;\n#define SamplerType %s\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform SamplerType uTextureSampler0;\nvoid main() {\n  gl_FragColor = texture2D(uTextureSampler0, vTextureCoord).bgra;\n  gl_FragColor *= uAlpha;\n}\n";
    private static final String BGRA_TEXTURE_FRAGMENT_SHADER = "%sprecision mediump float;\n#define SamplerType %s\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform SamplerType uTextureSampler0;\nvoid main() {\n  gl_FragColor = texture2D(uTextureSampler0, vTextureCoord).gbar;\n  gl_FragColor *= uAlpha;\n}\n";
    private static final String ABGR_TEXTURE_FRAGMENT_SHADER = "%sprecision mediump float;\n#define SamplerType %s\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform SamplerType uTextureSampler0;\nvoid main() {\n  gl_FragColor = texture2D(uTextureSampler0, vTextureCoord);\n  gl_FragColor *= uAlpha;\n}\n";
    private static final String YUV_I4XX_TEXTURE_FRAGMENT_SHADER = "%sprecision mediump float;\n#define SamplerType %s\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform SamplerType uTextureSampler0;\nuniform SamplerType uTextureSampler1;\nuniform SamplerType uTextureSampler2;\nconst vec3 matYUVRGB1 = vec3(1.164,  0.0,   1.596);\nconst vec3 matYUVRGB2 = vec3(1.164, -0.391, -0.813);\nconst vec3 matYUVRGB3 = vec3(1.164,  2.018,  0.0);\nvoid main() {\n  vec3 yuvData;\n  vec3 rgbData;\n  yuvData.x = texture2D(uTextureSampler0, vTextureCoord).x - 16.0 / 255.0;\n  yuvData.y = texture2D(uTextureSampler1, vTextureCoord).x - 128.0 / 255.0;\n  yuvData.z = texture2D(uTextureSampler2, vTextureCoord).x - 128.0 / 255.0;\n  rgbData.x = dot(yuvData, matYUVRGB1);\n  rgbData.y = dot(yuvData, matYUVRGB2);\n  rgbData.z = dot(yuvData, matYUVRGB3);\n  gl_FragColor = vec4(rgbData, 1.0) * uAlpha;\n}\n";
    private static final String YUV_I4XXF_TEXTURE_FRAGMENT_SHADER = "%sprecision mediump float;\n#define SamplerType %s\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform SamplerType uTextureSampler0;\nuniform SamplerType uTextureSampler1;\nuniform SamplerType uTextureSampler2;\nconst vec3 matYUVRGB1 = vec3(1.0,  0.0,   1.402);\nconst vec3 matYUVRGB2 = vec3(1.0, -0.344, -0.714);\nconst vec3 matYUVRGB3 = vec3(1.0,  1.772,  0.0);\nvoid main() {\n  vec3 yuvData;\n  vec3 rgbData;\n  yuvData.x = texture2D(uTextureSampler0, vTextureCoord).x;\n  yuvData.y = texture2D(uTextureSampler1, vTextureCoord).x - 128.0 / 255.0;\n  yuvData.z = texture2D(uTextureSampler2, vTextureCoord).x - 128.0 / 255.0;\n  rgbData.x = dot(yuvData, matYUVRGB1);\n  rgbData.y = dot(yuvData, matYUVRGB2);\n  rgbData.z = dot(yuvData, matYUVRGB3);\n  gl_FragColor = vec4(rgbData, 1.0) * uAlpha;\n}\n";
    private static final String YUV_NVXY_TEXTURE_FRAGMENT_SHADER = "%sprecision mediump float;\n#define SamplerType %s\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform SamplerType uTextureSampler0;\nuniform SamplerType uTextureSampler1;\nconst vec3 matYUVRGB1 = vec3(1.164,  0.0,   1.596);\nconst vec3 matYUVRGB2 = vec3(1.164, -0.391, -0.813);\nconst vec3 matYUVRGB3 = vec3(1.164,  2.018,  0.0);\nvoid main() {\n  vec3 yuvData;\n  vec3 rgbData;\n  yuvData.x = texture2D(uTextureSampler0, vTextureCoord).x - 16.0 / 255.0;\n  yuvData.yz = texture2D(uTextureSampler1, vTextureCoord).ra - 128.0 / 255.0;\n  rgbData.x = dot(yuvData, matYUVRGB1);\n  rgbData.y = dot(yuvData, matYUVRGB2);\n  rgbData.z = dot(yuvData, matYUVRGB3);\n  gl_FragColor = vec4(rgbData, 1.0) * uAlpha;\n}\n";
    private static final String YUV_NVXYF_TEXTURE_FRAGMENT_SHADER = "%sprecision mediump float;\n#define SamplerType %s\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform SamplerType uTextureSampler0;\nuniform SamplerType uTextureSampler1;\nconst vec3 matYUVRGB1 = vec3(1.0,  0.0,   1.402);\nconst vec3 matYUVRGB2 = vec3(1.0, -0.344, -0.714);\nconst vec3 matYUVRGB3 = vec3(1.0,  1.772,  0.0);\nvoid main() {\n  vec3 yuvData;\n  vec3 rgbData;\n  yuvData.x = texture2D(uTextureSampler0, vTextureCoord).x;\n  yuvData.yz = texture2D(uTextureSampler1, vTextureCoord).ra - 128.0 / 255.0;\n  rgbData.x = dot(yuvData, matYUVRGB1);\n  rgbData.y = dot(yuvData, matYUVRGB2);\n  rgbData.z = dot(yuvData, matYUVRGB3);\n  gl_FragColor = vec4(rgbData, 1.0) * uAlpha;\n}\n";
    private static final String YUV_NVYX_TEXTURE_FRAGMENT_SHADER = "%sprecision mediump float;\n#define SamplerType %s\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform SamplerType uTextureSampler0;\nuniform SamplerType uTextureSampler1;\nconst vec3 matYUVRGB1 = vec3(1.164,  0.0,   1.596);\nconst vec3 matYUVRGB2 = vec3(1.164, -0.391, -0.813);\nconst vec3 matYUVRGB3 = vec3(1.164,  2.018,  0.0);\nvoid main() {\n  vec3 yuvData;\n  vec3 rgbData;\n  yuvData.x = texture2D(uTextureSampler0, vTextureCoord).x - 16.0 / 255.0;\n  yuvData.yz = texture2D(uTextureSampler1, vTextureCoord).ar - 128.0 / 255.0;\n  rgbData.x = dot(yuvData, matYUVRGB1);\n  rgbData.y = dot(yuvData, matYUVRGB2);\n  rgbData.z = dot(yuvData, matYUVRGB3);\n  gl_FragColor = vec4(rgbData, 1.0) * uAlpha;\n}\n";
    private static final String TEX_PREFIX = "";
    private static final String TEX_SAMPLER = "sampler2D";
    private static final String OES_PREFIX = "#extension GL_OES_EGL_image_external : require\n";
    private static final String OES_SAMPLER = "samplerExternalOES";
    private static final int FRAGMENT_ARGB32 = 0;
    private static final int FRAGMENT_BGRA32 = 1;
    private static final int FRAGMENT_I4XX = 2;
    private static final int FRAGMENT_I4XXF = 3;
    private static final int FRAGMENT_NVXY = 4;
    private static final int FRAGMENT_NVXYF = 5;
    private static final int FRAGMENT_NVYX = 6;
    private static final int FRAGMENT_ABGR32 = 7;
    private static final int FRAGMENT_OES_ARGB32 = 8;
    private static final int FRAGMENT_OES_BGRA32 = 9;
    private static final int FRAGMENT_OES_ABGR32 = 10;
    private static final GLES20ProgramCreator DRAW_PROGRAM_CREATOR;
    private static final GLES20ProgramCreator[] PROGRAM_CREATORS;
    private static final int INITIAL_RESTORE_STATE_SIZE = 8;
    private static final int MATRIX_SIZE = 16;
    private static final int INDEX_POSITION = 0;
    private static final int INDEX_MATRIX = 1;
    private static final int INDEX_COLOR = 2;
    private static final int INDEX_TEXTURE_MATRIX = 2;
    private static final int INDEX_ALPHA = 3;
    private static final int INDEX_TEXTURE_SAMPLER = 4;
    public static final Companion Companion;

    @Override
    @NotNull
    public GLES20IdImpl getId() {
        return this.id;
    }

    @Override
    public void setSize(int n2, int n3) {
        this._width = n2;
        this._height = n3;
        GLES20.glViewport((int)0, (int)0, (int)this._width, (int)this._height);
        Companion.checkError();
        Matrix.setIdentityM((float[])this._matrices, (int)this._currentMatrixIndex);
        Matrix.orthoM((float[])this._projectionMatrix, (int)0, (float)0.0f, (float)n2, (float)n3, (float)0.0f, (float)-1.0f, (float)1.0f);
    }

    @Override
    public void clearBuffer() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Companion.checkErrorDebug();
        GLES20.glClear((int)16384);
        Companion.checkError();
    }

    @Override
    public void clearBuffer(@NotNull float[] fArray) {
        Intrinsics.checkParameterIsNotNull((Object)fArray, (String)"argb");
        GLES20.glClearColor((float)fArray[1], (float)fArray[2], (float)fArray[3], (float)fArray[0]);
        Companion.checkErrorDebug();
        GLES20.glClear((int)16384);
        Companion.checkError();
    }

    @Override
    public void translate(float f2, float f3, float f4) {
        Matrix.translateM((float[])this._matrices, (int)this._currentMatrixIndex, (float)f2, (float)f3, (float)f4);
    }

    @Override
    public void translate(float f2, float f3) {
        int n2 = this._currentMatrixIndex;
        float[] fArray = this._matrices;
        int n3 = n2 + 12;
        fArray[n3] = fArray[n3] + (fArray[n2] * f2 + fArray[n2 + 4] * f3);
        int n4 = n2 + 13;
        fArray[n4] = fArray[n4] + (fArray[n2 + 1] * f2 + fArray[n2 + 5] * f3);
        int n5 = n2 + 14;
        fArray[n5] = fArray[n5] + (fArray[n2 + 2] * f2 + fArray[n2 + 6] * f3);
        int n6 = n2 + 15;
        fArray[n6] = fArray[n6] + (fArray[n2 + 3] * f2 + fArray[n2 + 7] * f3);
    }

    @Override
    public void scale(float f2, float f3, float f4) {
        Matrix.scaleM((float[])this._matrices, (int)this._currentMatrixIndex, (float)f2, (float)f3, (float)f4);
    }

    @Override
    public void rotate(float f2, float f3, float f4, float f5) {
        if (f2 == 0.0f) {
            return;
        }
        float[] fArray = this._tempMatrix;
        Matrix.setRotateM((float[])fArray, (int)0, (float)f2, (float)f3, (float)f4, (float)f5);
        float[] fArray2 = this._matrices;
        int n2 = this._currentMatrixIndex;
        Matrix.multiplyMM((float[])fArray, (int)16, (float[])fArray2, (int)n2, (float[])fArray, (int)0);
        System.arraycopy(fArray, 16, fArray2, n2, 16);
    }

    @Override
    public void clip(float f2, float f3, float f4, float f5) {
        Rect rect;
        int n2;
        this._tempMatrix[0] = f2;
        this._tempMatrix[1] = f3;
        this._tempMatrix[2] = 1.0f;
        this._tempMatrix[3] = 1.0f;
        Matrix.multiplyMV((float[])this._tempMatrix, (int)4, (float[])this._matrices, (int)this._currentMatrixIndex, (float[])this._tempMatrix, (int)0);
        int n3 = (int)this._tempMatrix[4];
        int n4 = (int)this._tempMatrix[5];
        this._tempMatrix[0] = f4;
        this._tempMatrix[1] = f5;
        Matrix.multiplyMV((float[])this._tempMatrix, (int)4, (float[])this._matrices, (int)this._currentMatrixIndex, (float[])this._tempMatrix, (int)0);
        int n5 = (int)this._tempMatrix[4];
        int n6 = (int)this._tempMatrix[5];
        if (n4 > n6) {
            n2 = n4;
            n4 = n6;
            n6 = n2;
        }
        if (n3 > n5) {
            n2 = n3;
            n3 = n5;
            n5 = n2;
        }
        Rect rect2 = rect = this._clipRect.get(this._currentClipIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)rect2, (String)"current");
        if (rect2.isEmpty()) {
            rect.set(n3, n4, n5, n6);
        } else if (!rect.intersect(n3, n4, n5, n6)) {
            rect.setEmpty();
        }
        if (DEBUG_LOG) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.CHINA;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.CHINA");
            Locale locale2 = locale;
            String string = "clip.(%.0f,%.0f,%.0f,%.0f).to.(%d,%d,%d,%d).clip.(%d,%d,%d,%d)";
            Object[] objectArray = new Object[]{Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), n3, n4, n5, n6, rect.left, rect.top, rect.right, rect.bottom};
            String string2 = TAG;
            Log log = Log.INSTANCE;
            String string3 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            String string4 = string3;
            log.d(string2, string4);
        }
    }

    @Override
    public void save() {
        this.save(-1);
    }

    @Override
    public void save(int n2) {
        int n3;
        int n4;
        boolean bl;
        boolean bl2 = bl = (n2 & 1) == 1;
        if (bl) {
            n4 = this._currentMatrixIndex;
            this._currentMatrixIndex += 16;
            if (this._matrices.length <= this._currentMatrixIndex) {
                float[] fArray = this._matrices;
                n3 = this._matrices.length * 2;
                GLES20Canvas gLES20Canvas = this;
                float[] fArray2 = Arrays.copyOf(fArray, n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)fArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
                float[] fArray3 = fArray2;
                gLES20Canvas._matrices = fArray3;
            }
            System.arraycopy(this._matrices, n4, this._matrices, this._currentMatrixIndex, 16);
        }
        int n5 = n4 = (n2 & 2) == 2 ? 1 : 0;
        if (n4 != 0) {
            int n6 = this._currentClipIndex;
            n3 = this._currentClipIndex;
            this._currentClipIndex = n3 + 1;
            if (this._clipRect.size() <= this._currentClipIndex) {
                n3 = this._clipRect.size() * 2;
                int n7 = n3;
                for (int i2 = 0; i2 < n7; ++i2) {
                    this._clipRect.add(new Rect());
                }
            }
            this._clipRect.get(this._currentClipIndex).set(this._clipRect.get(n6));
        }
        this._saveFlags.add(n2);
    }

    @Override
    public void restore() {
        boolean bl;
        boolean bl2;
        int n2 = this._saveFlags.removeLast();
        boolean bl3 = bl2 = (n2 & 1) == 1;
        if (bl2) {
            this._currentMatrixIndex -= 16;
        }
        boolean bl4 = bl = (n2 & 2) == 2;
        if (bl) {
            int n3 = this._currentClipIndex;
            this._currentClipIndex = n3 + -1;
        }
    }

    @Override
    public void drawLine(float f2, float f3, float f4, float f5, @NotNull GLPaint gLPaint) {
        Intrinsics.checkParameterIsNotNull((Object)gLPaint, (String)"paint");
        this.draw(3, 4, 2, f2, f3, f4 - f2, f5 - f3, gLPaint.getColor(), gLPaint.getLineWidth());
        int n2 = this._countDrawLine;
        this._countDrawLine = n2 + 1;
    }

    private final void draw(int n2, int n3, int n4, float f2, float f3, float f4, float f5, int n5, float f6) {
        this.prepareDraw(n3, n5, f6);
        this.draw(this._drawProgram.getHandles(), n2, n4, f2, f3, f4, f5);
        this.clearClip();
    }

    private final void prepareDraw(int n2, int n3, float f2) {
        float[] fArray;
        GLES20.glUseProgram((int)this._drawProgram.getProgram());
        Companion.checkError();
        if (f2 > 0.0f) {
            GLES20.glLineWidth((float)f2);
            Companion.checkErrorDebug();
        }
        boolean bl = (fArray = this.getColor(n3))[3] < 1.0f;
        this.enableBlending(bl);
        if (bl) {
            GLES20.glBlendColor((float)fArray[0], (float)fArray[1], (float)fArray[2], (float)fArray[3]);
            Companion.checkErrorDebug();
        }
        GLES20.glUniform4fv((int)this._drawProgram.getHandles()[2], (int)1, (float[])fArray, (int)0);
        this.setPosition(this._drawProgram.getHandles(), n2);
        Companion.checkError();
        this.setupClip();
    }

    private final float[] getColor(int n2) {
        float f2 = (float)(n2 >>> 24 & 0xFF) / 255.0f;
        float f3 = (float)(n2 >>> 16 & 0xFF) / 255.0f * f2;
        float f4 = (float)(n2 >>> 8 & 0xFF) / 255.0f * f2;
        float f5 = (float)(n2 & 0xFF) / 255.0f * f2;
        this._tempColor[0] = f3;
        this._tempColor[1] = f4;
        this._tempColor[2] = f5;
        this._tempColor[3] = f2;
        return this._tempColor;
    }

    private final void enableBlending(boolean bl) {
        if (bl) {
            GLES20.glEnable((int)3042);
            Companion.checkErrorDebug();
        } else {
            GLES20.glDisable((int)3042);
            Companion.checkErrorDebug();
        }
    }

    private final void setupBlendingParam(int n2) {
        switch (n2) {
            case 2: {
                GLES20.glBlendEquation((int)32774);
                GLES20.glBlendFunc((int)1, (int)0);
                break;
            }
            case 0: {
                GLES20.glBlendEquation((int)32774);
                GLES20.glBlendFunc((int)770, (int)771);
                break;
            }
            case 9: {
                GLES20.glBlendEquation((int)32774);
                GLES20.glBlendFunc((int)775, (int)769);
                break;
            }
            case 10: {
                GLES20.glBlendEquation((int)32774);
                GLES20.glBlendFunc((int)774, (int)0);
            }
        }
    }

    private final void setupClip() {
        Rect rect;
        Rect rect2 = rect = this._clipRect.get(this._currentClipIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)rect2, (String)"rc");
        if (!rect2.isEmpty()) {
            int n2 = this._height - rect.bottom;
            GLES20.glScissor((int)rect.left, (int)n2, (int)rect.width(), (int)rect.height());
            GLES20.glEnable((int)3089);
        } else {
            GLES20.glDisable((int)3089);
        }
        Companion.checkError();
    }

    private final void clearClip() {
        GLES20.glDisable((int)3089);
    }

    private final void setPosition(int[] nArray, int n2) {
        GLES20.glBindBuffer((int)34962, (int)this._boxCoordinates);
        Companion.checkErrorDebug();
        GLES20.glVertexAttribPointer((int)nArray[0], (int)2, (int)5126, (boolean)false, (int)8, (int)(n2 * 8));
        Companion.checkError();
        GLES20.glBindBuffer((int)34962, (int)0);
        Companion.checkErrorDebug();
    }

    private final void draw(int[] nArray, int n2, int n3, float f2, float f3, float f4, float f5) {
        this.setMatrix(nArray, f2, f3, f4, f5);
        int n4 = nArray[0];
        GLES20.glEnableVertexAttribArray((int)n4);
        Companion.checkErrorDebug();
        GLES20.glDrawArrays((int)n2, (int)0, (int)n3);
        Companion.checkError();
        GLES20.glDisableVertexAttribArray((int)n4);
        Companion.checkErrorDebug();
    }

    private final void setMatrix(int[] nArray, float f2, float f3, float f4, float f5) {
        Matrix.translateM((float[])this._tempMatrix, (int)0, (float[])this._matrices, (int)this._currentMatrixIndex, (float)f2, (float)f3, (float)0.0f);
        Matrix.scaleM((float[])this._tempMatrix, (int)0, (float)f4, (float)f5, (float)1.0f);
        Matrix.multiplyMM((float[])this._tempMatrix, (int)16, (float[])this._projectionMatrix, (int)0, (float[])this._tempMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)nArray[1], (int)1, (boolean)false, (float[])this._tempMatrix, (int)16);
        Companion.checkError();
    }

    @Override
    public void fillRect(float f2, float f3, float f4, float f5, int n2) {
        this.draw(5, 0, 4, f2, f3, f4, f5, n2, 0.0f);
        int n3 = this._countFillRect;
        this._countFillRect = n3 + 1;
    }

    @Override
    public void drawTexture(@NotNull BasicTexture basicTexture, int n2, int n3, int n4, int n5) {
        Intrinsics.checkParameterIsNotNull((Object)basicTexture, (String)"texture");
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        GLES20Canvas.Companion.copyTextureCoordinates(basicTexture, this._tempSourceRect);
        this._tempTargetRect.set((float)n2, (float)n3, (float)(n2 + n4), (float)(n3 + n5));
        GLES20Canvas.Companion.convertCoordinate(this._tempSourceRect, basicTexture);
        this.drawTextureRect(basicTexture, this._tempSourceRect, this._tempTargetRect);
    }

    private final void drawTextureRect(BasicTexture basicTexture, RectF rectF, RectF rectF2) {
        this.setTextureMatrix(rectF);
        this.drawTextureRect(basicTexture, this._tempTextureMatrix, rectF2);
    }

    private final void setTextureMatrix(RectF rectF) {
        this._tempTextureMatrix[0] = rectF.width();
        this._tempTextureMatrix[5] = rectF.height();
        this._tempTextureMatrix[12] = rectF.left;
        this._tempTextureMatrix[13] = rectF.top;
    }

    private final void drawTextureRect(BasicTexture basicTexture, float[] fArray, RectF rectF) {
        int[] nArray = this.prepareTexture(basicTexture);
        if (nArray == null) {
            return;
        }
        int[] nArray2 = nArray;
        this.setPosition(nArray2, 0);
        GLES20.glUniformMatrix4fv((int)nArray2[2], (int)1, (boolean)false, (float[])fArray, (int)0);
        Companion.checkError();
        if (basicTexture.isFlippedVertically()) {
            this.save(1);
            this.translate(0.0f, rectF.centerY());
            this.scale(1.0f, -1.0f, 1.0f);
            this.translate(0.0f, -rectF.centerY());
        }
        this.draw(nArray2, 5, 4, rectF.left, rectF.top, rectF.width(), rectF.height());
        if (basicTexture.isFlippedVertically()) {
            this.restore();
        }
        this.clearClip();
        int n2 = this._countTextureRect;
        this._countTextureRect = n2 + 1;
    }

    private final int[] prepareTexture(BasicTexture basicTexture) {
        int n2;
        int n3;
        if (!basicTexture.onBind(this)) {
            Log.INSTANCE.e(TAG, "bind.texture.failed!");
            return null;
        }
        int n4 = basicTexture.getTarget();
        if (n4 == 3553) {
            switch (basicTexture.getFormat()) {
                case 0: {
                    n3 = 0;
                    break;
                }
                case 1: {
                    n3 = 1;
                    break;
                }
                case 2: {
                    n3 = 7;
                    break;
                }
                case 6: {
                    n3 = 2;
                    break;
                }
                case 21: {
                    n3 = 3;
                    break;
                }
                case 9: {
                    n3 = 4;
                    break;
                }
                case 24: {
                    n3 = 5;
                    break;
                }
                case 10: {
                    n3 = 6;
                    break;
                }
                case 8: {
                    n3 = 2;
                    break;
                }
                case 23: {
                    n3 = 3;
                    break;
                }
                default: {
                    n3 = 0;
                    break;
                }
            }
        } else {
            switch (basicTexture.getFormat()) {
                case 0: {
                    n3 = 8;
                    break;
                }
                case 1: {
                    n3 = 9;
                    break;
                }
                default: {
                    n3 = 10;
                }
            }
        }
        int n5 = n3;
        int[] nArray = this._texturesProgram[n5].getHandles();
        int n6 = this._texturesProgram[n5].getProgram();
        GLES20.glUseProgram((int)n6);
        Companion.checkError();
        boolean bl = !basicTexture.isOpaque();
        this.enableBlending(bl);
        if (bl) {
            this.setupBlendingParam(basicTexture.getBlendMode());
        }
        if ((n2 = basicTexture.getTexCount()) > 0) {
            if (4 + n2 > nArray.length) {
                throw (Throwable)((Object)new AssertionError((Object)("texture.count." + n2 + ".mismatch.target." + n4 + ".index." + n5)));
            }
            int n7 = n2;
            for (int i2 = 0; i2 < n7; ++i2) {
                int n8 = basicTexture.getTexIdByIndex(i2);
                GLES20.glActiveTexture((int)(33984 + i2));
                Companion.checkErrorDebug();
                GLES20.glBindTexture((int)n4, (int)n8);
                Companion.checkErrorDebug();
                GLES20.glUniform1i((int)nArray[4 + i2], (int)i2);
                Companion.checkError();
            }
        }
        GLES20.glUniform1f((int)nArray[3], (float)1.0f);
        Companion.checkError();
        this.setupClip();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unloadTexture(@NotNull BasicTexture basicTexture) {
        Intrinsics.checkParameterIsNotNull((Object)basicTexture, (String)"texture");
        boolean bl = basicTexture.isLoaded();
        if (bl) {
            PreAllocIntArray preAllocIntArray = this._unboundTextures;
            synchronized (preAllocIntArray) {
                int n2 = basicTexture.getTexCount();
                int n3 = n2;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = basicTexture.getTexIdByIndex(i2);
                    if (n4 == 0) continue;
                    if (Platform.isDebugBuild) {
                        Platform.logInfo("unloadTexture.tex." + n4);
                    }
                    this._unboundTextures.add(n4);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTexture(int n2) {
        PreAllocIntArray preAllocIntArray = this._unboundTextures;
        synchronized (preAllocIntArray) {
            if (Platform.isDebugBuild) {
                Platform.logInfo("deleteTexture.tex." + this.getId());
            }
            this._unboundTextures.add(n2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBuffer(int n2) {
        PreAllocIntArray preAllocIntArray = this._deleteBuffers;
        synchronized (preAllocIntArray) {
            this._deleteBuffers.add(n2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRecycledResources() {
        Unit unit;
        PreAllocIntArray preAllocIntArray;
        PreAllocIntArray preAllocIntArray2 = this._unboundTextures;
        synchronized (preAllocIntArray2) {
            preAllocIntArray = this._unboundTextures;
            if (preAllocIntArray.getSize() > 0) {
                this.getId().glDeleteTextures(preAllocIntArray.getSize(), preAllocIntArray.getInternalArray(), 0);
                preAllocIntArray.clear();
            }
            unit = Unit.INSTANCE;
        }
        preAllocIntArray2 = this._deleteBuffers;
        synchronized (preAllocIntArray2) {
            preAllocIntArray = this._deleteBuffers;
            if (preAllocIntArray.getSize() > 0) {
                this.getId().glDeleteBuffers(preAllocIntArray.getSize(), preAllocIntArray.getInternalArray(), 0);
                preAllocIntArray.clear();
            }
            unit = Unit.INSTANCE;
        }
    }

    @Override
    public void dumpStatisticsAndClear() {
        String string = "TEX_RECT:" + this._countTextureRect + ", FILL_RECT:" + this._countFillRect + ", LINE:" + this._countDrawLine;
        this._countTextureRect = 0;
        this._countFillRect = 0;
        this._countDrawLine = 0;
        Log.INSTANCE.d(TAG, string);
    }

    @Override
    public void setTextureParameters(@NotNull BasicTexture basicTexture) {
        Intrinsics.checkParameterIsNotNull((Object)basicTexture, (String)"texture");
        int n2 = basicTexture.getTexCount();
        if (n2 > 0) {
            int n3 = basicTexture.getTarget();
            int n4 = n2;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = basicTexture.getTexIdByIndex(i2);
                GLES20.glBindTexture((int)n3, (int)n5);
                Companion.checkError();
                GLES20.glTexParameteri((int)n3, (int)10242, (int)33071);
                GLES20.glTexParameteri((int)n3, (int)10243, (int)33071);
                GLES20.glTexParameteri((int)n3, (int)10241, (int)9729);
                GLES20.glTexParameteri((int)n3, (int)10240, (int)9729);
                Companion.checkErrorDebug();
            }
        }
    }

    @Override
    public void initializeTextureSize(@NotNull BasicTexture basicTexture, int n2, int n3) {
        Intrinsics.checkParameterIsNotNull((Object)basicTexture, (String)"texture");
        int n4 = basicTexture.getTexCount();
        if (n4 > 0) {
            int n5 = basicTexture.getTarget();
            int n6 = n4;
            for (int i2 = 0; i2 < n6; ++i2) {
                int n7 = basicTexture.getTexIdByIndex(i2);
                GLES20.glBindTexture((int)n5, (int)n7);
                Companion.checkError();
                int n8 = basicTexture.getTextureWidth();
                int n9 = basicTexture.getTextureHeight();
                GLES20.glTexImage2D((int)n5, (int)0, (int)n2, (int)n8, (int)n9, (int)0, (int)n2, (int)n3, null);
            }
        }
    }

    @Override
    public void initializeTexture(@NotNull BasicTexture basicTexture, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)basicTexture, (String)"texture");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int n2 = basicTexture.getTexCount();
        if (n2 > 0) {
            int n3 = basicTexture.getTarget();
            int n4 = n2;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = basicTexture.getTexIdByIndex(i2);
                GLES20.glBindTexture((int)n3, (int)n5);
                Companion.checkError();
                GLUtils.texImage2D((int)n3, (int)0, (Bitmap)bitmap, (int)0);
            }
        }
    }

    @Override
    public void texSubImage2D(@NotNull BasicTexture basicTexture, int n2, int n3, @NotNull Bitmap bitmap, int n4, int n5) {
        Intrinsics.checkParameterIsNotNull((Object)basicTexture, (String)"texture");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int n6 = basicTexture.getTexCount();
        if (n6 > 0) {
            int n7 = basicTexture.getTarget();
            int n8 = n6;
            for (int i2 = 0; i2 < n8; ++i2) {
                int n9 = basicTexture.getTexIdByIndex(i2);
                GLES20.glBindTexture((int)n7, (int)n9);
                Companion.checkError();
                GLUtils.texSubImage2D((int)n7, (int)0, (int)n2, (int)n3, (Bitmap)bitmap, (int)n4, (int)n5);
            }
        }
    }

    @Override
    public int uploadBuffer(@NotNull FloatBuffer floatBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)floatBuffer, (String)"buffer");
        return this.uploadBuffer(floatBuffer, 4);
    }

    @Override
    public int uploadBuffer(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)byteBuffer, (String)"buffer");
        return this.uploadBuffer(byteBuffer, 1);
    }

    private final int uploadBuffer(Buffer buffer, int n2) {
        this.getId().glGenBuffers(1, this._tempIntArray, 0);
        Companion.checkErrorDebug();
        int n3 = this._tempIntArray[0];
        GLES20.glBindBuffer((int)34962, (int)n3);
        Companion.checkErrorDebug();
        GLES20.glBufferData((int)34962, (int)(buffer.capacity() * n2), (Buffer)buffer, (int)35044);
        Companion.checkError();
        return n3;
    }

    @Override
    public void recoverFromLightCycle() {
        GLES20.glViewport((int)0, (int)0, (int)this._width, (int)this._height);
        GLES20.glDisable((int)2929);
        GLES20.glBlendFunc((int)1, (int)771);
        Companion.checkError();
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public void release() {
        if (GLThread.INSTANCE.getLOG_SURFACE$libxcast_release()) {
            String string = "GLES20Canvas.%h.release";
            Locale locale = Locale.CHINA;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.CHINA");
            Locale locale2 = locale;
            Object[] objectArray = new Object[]{this};
            String string2 = TAG;
            Log log = Log.INSTANCE;
            String string3 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
            String string4 = string3;
            log.i(string2, string4);
        }
        if (EGLUtil.isPBOAvailable()) {
            GLES20.glBindBuffer((int)35052, (int)0);
        }
        int n2 = 8;
        for (int i2 = 0; i2 < n2; ++i2) {
            GLES20.glActiveTexture((int)(33984 + i2));
            GLES20.glBindTexture((int)3553, (int)0);
        }
        GLES20.glBindBuffer((int)34962, (int)0);
        this.deleteBuffer(this._boxCoordinates);
        this._boxCoordinates = 0;
        this.deleteRecycledResources();
        GLES20.glUseProgram((int)0);
        this._drawProgram.deleteProgram();
        for (GLES20Program gLES20Program : this._texturesProgram) {
            gLES20Program.deleteProgram();
        }
    }

    public GLES20Canvas() {
        Object object;
        Matrix.setIdentityM((float[])this._tempTextureMatrix, (int)0);
        Matrix.setIdentityM((float[])this._matrices, (int)this._currentMatrixIndex);
        FloatBuffer floatBuffer = GLES20Canvas.Companion.createBuffer(GLES20Canvas.BOX_COORDINATES);
        this._boxCoordinates = this.uploadBuffer(floatBuffer);
        this._drawProgram = DRAW_PROGRAM_CREATOR.assembleProgram();
        int n2 = PROGRAM_CREATORS.length;
        Object object2 = this;
        GLES20Program[] gLES20ProgramArray = new GLES20Program[n2];
        int n3 = 0;
        int n4 = gLES20ProgramArray.length;
        while (n3 < n4) {
            GLES20Program gLES20Program;
            int n5 = n3;
            int n6 = n3++;
            object = gLES20ProgramArray;
            object[n6] = gLES20Program = PROGRAM_CREATORS[n5].assembleProgram();
        }
        object = gLES20ProgramArray;
        ((GLES20Canvas)object2)._texturesProgram = object;
        GLES20.glBlendFunc((int)1, (int)771);
        Companion.checkError();
        int n7 = 8;
        for (n2 = 0; n2 < n7; ++n2) {
            this._clipRect.add(new Rect());
        }
        if (GLThread.INSTANCE.getLOG_SURFACE$libxcast_release()) {
            String string = "GLES20Canvas.%h.create";
            Locale locale = Locale.CHINA;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.CHINA");
            Locale locale2 = locale;
            Object[] objectArray = new Object[]{this};
            object = TAG;
            object2 = Log.INSTANCE;
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            String string3 = string2;
            ((Log)object2).i((String)object, string3);
        }
    }

    static {
        GLES20ProgramCreator gLES20ProgramCreator;
        GLES20ProgramCreator gLES20ProgramCreator2;
        GLES20ProgramCreator gLES20ProgramCreator3;
        GLES20ProgramCreator gLES20ProgramCreator4;
        GLES20ProgramCreator gLES20ProgramCreator5;
        GLES20ProgramCreator gLES20ProgramCreator6;
        GLES20ProgramCreator gLES20ProgramCreator7;
        GLES20ProgramCreator gLES20ProgramCreator8;
        GLES20ProgramCreator gLES20ProgramCreator9;
        GLES20ProgramCreator gLES20ProgramCreator10;
        GLES20ProgramCreator[] gLES20ProgramCreatorArray;
        GLES20ProgramCreator gLES20ProgramCreator11;
        Companion = new Companion(null);
        BOX_COORDINATES = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
        DRAW_PROGRAM_CREATOR = new GLES20ProgramCreator(DRAW_VERTEX_SHADER, DRAW_FRAGMENT_SHADER, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(COLOR_UNIFORM)});
        String string = ARGB_TEXTURE_FRAGMENT_SHADER;
        Object[] objectArray = new Object[]{TEX_PREFIX, TEX_SAMPLER};
        String string2 = TEXTURE_VERTEX_SHADER;
        GLES20ProgramCreator gLES20ProgramCreator12 = gLES20ProgramCreator11;
        GLES20ProgramCreator gLES20ProgramCreator13 = gLES20ProgramCreator11;
        int n2 = 0;
        GLES20ProgramCreator[] gLES20ProgramCreatorArray2 = gLES20ProgramCreatorArray = new GLES20ProgramCreator[11];
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
        String string4 = string3;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        string = BGRA_TEXTURE_FRAGMENT_SHADER;
        objectArray = new Object[]{TEX_PREFIX, TEX_SAMPLER};
        string2 = TEXTURE_VERTEX_SHADER;
        gLES20ProgramCreator12 = gLES20ProgramCreator10;
        gLES20ProgramCreator13 = gLES20ProgramCreator10;
        n2 = 1;
        gLES20ProgramCreatorArray = gLES20ProgramCreatorArray2;
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(this, *args)");
        string4 = string5;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        string = YUV_I4XX_TEXTURE_FRAGMENT_SHADER;
        objectArray = new Object[]{TEX_PREFIX, TEX_SAMPLER};
        string2 = TEXTURE_VERTEX_SHADER;
        gLES20ProgramCreator12 = gLES20ProgramCreator9;
        gLES20ProgramCreator13 = gLES20ProgramCreator9;
        n2 = 2;
        gLES20ProgramCreatorArray = gLES20ProgramCreatorArray2;
        String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(this, *args)");
        string4 = string6;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM1), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM2)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        string = YUV_I4XXF_TEXTURE_FRAGMENT_SHADER;
        objectArray = new Object[]{TEX_PREFIX, TEX_SAMPLER};
        string2 = TEXTURE_VERTEX_SHADER;
        gLES20ProgramCreator12 = gLES20ProgramCreator8;
        gLES20ProgramCreator13 = gLES20ProgramCreator8;
        n2 = 3;
        gLES20ProgramCreatorArray = gLES20ProgramCreatorArray2;
        String string7 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(this, *args)");
        string4 = string7;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM1), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM2)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        string = YUV_NVXY_TEXTURE_FRAGMENT_SHADER;
        objectArray = new Object[]{TEX_PREFIX, TEX_SAMPLER};
        string2 = TEXTURE_VERTEX_SHADER;
        gLES20ProgramCreator12 = gLES20ProgramCreator7;
        gLES20ProgramCreator13 = gLES20ProgramCreator7;
        n2 = 4;
        gLES20ProgramCreatorArray = gLES20ProgramCreatorArray2;
        String string8 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.String.format(this, *args)");
        string4 = string8;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM1)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        string = YUV_NVXYF_TEXTURE_FRAGMENT_SHADER;
        objectArray = new Object[]{TEX_PREFIX, TEX_SAMPLER};
        string2 = TEXTURE_VERTEX_SHADER;
        gLES20ProgramCreator12 = gLES20ProgramCreator6;
        gLES20ProgramCreator13 = gLES20ProgramCreator6;
        n2 = 5;
        gLES20ProgramCreatorArray = gLES20ProgramCreatorArray2;
        String string9 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"java.lang.String.format(this, *args)");
        string4 = string9;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM1)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        string = YUV_NVYX_TEXTURE_FRAGMENT_SHADER;
        objectArray = new Object[]{TEX_PREFIX, TEX_SAMPLER};
        string2 = TEXTURE_VERTEX_SHADER;
        gLES20ProgramCreator12 = gLES20ProgramCreator5;
        gLES20ProgramCreator13 = gLES20ProgramCreator5;
        n2 = 6;
        gLES20ProgramCreatorArray = gLES20ProgramCreatorArray2;
        String string10 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"java.lang.String.format(this, *args)");
        string4 = string10;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM1)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        string = ABGR_TEXTURE_FRAGMENT_SHADER;
        objectArray = new Object[]{TEX_PREFIX, TEX_SAMPLER};
        string2 = TEXTURE_VERTEX_SHADER;
        gLES20ProgramCreator12 = gLES20ProgramCreator4;
        gLES20ProgramCreator13 = gLES20ProgramCreator4;
        n2 = 7;
        gLES20ProgramCreatorArray = gLES20ProgramCreatorArray2;
        String string11 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"java.lang.String.format(this, *args)");
        string4 = string11;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        string = ARGB_TEXTURE_FRAGMENT_SHADER;
        objectArray = new Object[]{OES_PREFIX, OES_SAMPLER};
        string2 = TEXTURE_VERTEX_SHADER;
        gLES20ProgramCreator12 = gLES20ProgramCreator3;
        gLES20ProgramCreator13 = gLES20ProgramCreator3;
        n2 = 8;
        gLES20ProgramCreatorArray = gLES20ProgramCreatorArray2;
        String string12 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"java.lang.String.format(this, *args)");
        string4 = string12;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        string = BGRA_TEXTURE_FRAGMENT_SHADER;
        objectArray = new Object[]{OES_PREFIX, OES_SAMPLER};
        string2 = TEXTURE_VERTEX_SHADER;
        gLES20ProgramCreator12 = gLES20ProgramCreator2;
        gLES20ProgramCreator13 = gLES20ProgramCreator2;
        n2 = 9;
        gLES20ProgramCreatorArray = gLES20ProgramCreatorArray2;
        String string13 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"java.lang.String.format(this, *args)");
        string4 = string13;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        string = ABGR_TEXTURE_FRAGMENT_SHADER;
        objectArray = new Object[]{OES_PREFIX, OES_SAMPLER};
        string2 = TEXTURE_VERTEX_SHADER;
        gLES20ProgramCreator12 = gLES20ProgramCreator;
        gLES20ProgramCreator13 = gLES20ProgramCreator;
        n2 = 10;
        gLES20ProgramCreatorArray = gLES20ProgramCreatorArray2;
        String string14 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"java.lang.String.format(this, *args)");
        string4 = string14;
        gLES20ProgramCreator12(string2, string4, new ShaderParameter[]{new AttributeShaderParameter(POSITION_ATTRIBUTE), new UniformShaderParameter(MATRIX_UNIFORM), new UniformShaderParameter(TEXTURE_MATRIX_UNIFORM), new UniformShaderParameter(ALPHA_UNIFORM), new UniformShaderParameter(TEXTURE_SAMPLER_UNIFORM0)});
        gLES20ProgramCreatorArray[n2] = gLES20ProgramCreator13;
        PROGRAM_CREATORS = gLES20ProgramCreatorArray2;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/tencent/xcast/GLES20Canvas$ShaderParameter;", "", "_name", "", "(Ljava/lang/String;)V", "get_name", "()Ljava/lang/String;", "loadHandle", "", "program", "libxcast_release"})
    private static abstract class ShaderParameter {
        @NotNull
        private final String _name;

        public abstract int loadHandle(int var1);

        @NotNull
        protected final String get_name() {
            return this._name;
        }

        public ShaderParameter(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"_name");
            this._name = string;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/tencent/xcast/GLES20Canvas$UniformShaderParameter;", "Lcom/tencent/xcast/GLES20Canvas$ShaderParameter;", "name", "", "(Ljava/lang/String;)V", "loadHandle", "", "program", "libxcast_release"})
    private static final class UniformShaderParameter
    extends ShaderParameter {
        @Override
        public int loadHandle(int n2) {
            int n3 = GLES20.glGetUniformLocation((int)n2, (String)this.get_name());
            Companion.checkError();
            return n3;
        }

        public UniformShaderParameter(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"name");
            super(string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/tencent/xcast/GLES20Canvas$AttributeShaderParameter;", "Lcom/tencent/xcast/GLES20Canvas$ShaderParameter;", "name", "", "(Ljava/lang/String;)V", "loadHandle", "", "program", "libxcast_release"})
    private static final class AttributeShaderParameter
    extends ShaderParameter {
        @Override
        public int loadHandle(int n2) {
            int n3 = GLES20.glGetAttribLocation((int)n2, (String)this.get_name());
            Companion.checkError();
            return n3;
        }

        public AttributeShaderParameter(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"name");
            super(string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0003H\u0002R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/tencent/xcast/GLES20Canvas$GLES20Program;", "", "vertexShader", "", "fragmentShader", "params", "", "Lcom/tencent/xcast/GLES20Canvas$ShaderParameter;", "(Ljava/lang/String;Ljava/lang/String;[Lcom/tencent/xcast/GLES20Canvas$ShaderParameter;)V", "<set-?>", "", "handles", "getHandles", "()[I", "setHandles", "([I)V", "", "program", "getProgram", "()I", "setProgram", "(I)V", "deleteProgram", "", "loadShader", "type", "shaderCode", "libxcast_release"})
    private static final class GLES20Program {
        private int program;
        @NotNull
        private int[] handles;

        public final int getProgram() {
            return this.program;
        }

        private final void setProgram(int n2) {
            this.program = n2;
        }

        @NotNull
        public final int[] getHandles() {
            return this.handles;
        }

        private final void setHandles(int[] nArray) {
            this.handles = nArray;
        }

        public final void deleteProgram() {
            this.handles = new int[0];
            GLES20.glDeleteProgram((int)this.program);
            this.program = 0;
        }

        private final int loadShader(int n2, String string) {
            int n3 = GLES20.glCreateShader((int)n2);
            GLES20.glShaderSource((int)n3, (String)string);
            Companion.checkError();
            GLES20.glCompileShader((int)n3);
            Companion.checkError();
            return n3;
        }

        public GLES20Program(@NotNull String string, @NotNull String string2, @NotNull ShaderParameter[] shaderParameterArray) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"vertexShader");
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"fragmentShader");
            Intrinsics.checkParameterIsNotNull((Object)shaderParameterArray, (String)"params");
            this.handles = new int[shaderParameterArray.length];
            this.program = GLES20.glCreateProgram();
            Companion.checkErrorDebug();
            if (this.program == 0) {
                throw (Throwable)new RuntimeException("Cannot create GL program: " + GLES20.glGetError());
            }
            int n2 = this.loadShader(35633, string);
            GLES20.glAttachShader((int)this.program, (int)n2);
            Companion.checkError();
            int n3 = this.loadShader(35632, string2);
            GLES20.glAttachShader((int)this.program, (int)n3);
            Companion.checkError();
            GLES20.glLinkProgram((int)this.program);
            Companion.checkError();
            GLES20.glDeleteShader((int)n2);
            GLES20.glDeleteShader((int)n3);
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])nArray, (int)0);
            if (nArray[0] != 1) {
                Log.INSTANCE.e(GLES20Canvas.TAG, "Could not link program: ");
                String string3 = GLES20.glGetProgramInfoLog((int)this.program);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"glGetProgramInfoLog(program)");
                Log.INSTANCE.e(GLES20Canvas.TAG, string3);
                GLES20.glDeleteProgram((int)this.program);
                this.program = 0;
            } else {
                int n4 = shaderParameterArray.length;
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.handles[i2] = shaderParameterArray[i2].loadHandle(this.program);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/tencent/xcast/GLES20Canvas$GLES20ProgramCreator;", "", "vertexShader", "", "fragmentShader", "params", "", "Lcom/tencent/xcast/GLES20Canvas$ShaderParameter;", "(Ljava/lang/String;Ljava/lang/String;[Lcom/tencent/xcast/GLES20Canvas$ShaderParameter;)V", "getFragmentShader", "()Ljava/lang/String;", "getParams", "()[Lcom/tencent/xcast/GLES20Canvas$ShaderParameter;", "[Lcom/tencent/xcast/GLES20Canvas$ShaderParameter;", "getVertexShader", "assembleProgram", "Lcom/tencent/xcast/GLES20Canvas$GLES20Program;", "libxcast_release"})
    private static final class GLES20ProgramCreator {
        @NotNull
        private final String vertexShader;
        @NotNull
        private final String fragmentShader;
        @NotNull
        private final ShaderParameter[] params;

        @NotNull
        public final GLES20Program assembleProgram() {
            return new GLES20Program(this.vertexShader, this.fragmentShader, this.params);
        }

        @NotNull
        public final String getVertexShader() {
            return this.vertexShader;
        }

        @NotNull
        public final String getFragmentShader() {
            return this.fragmentShader;
        }

        @NotNull
        public final ShaderParameter[] getParams() {
            return this.params;
        }

        public GLES20ProgramCreator(@NotNull String string, @NotNull String string2, @NotNull ShaderParameter[] shaderParameterArray) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"vertexShader");
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"fragmentShader");
            Intrinsics.checkParameterIsNotNull((Object)shaderParameterArray, (String)"params");
            this.vertexShader = string;
            this.fragmentShader = string2;
            this.params = shaderParameterArray;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010H\u001a\u00020IJ\u000e\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0004J\u0006\u0010K\u001a\u00020IJ\u0018\u0010L\u001a\u00020I2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020PH\u0002J\u0018\u0010Q\u001a\u00020I2\u0006\u0010O\u001a\u00020P2\u0006\u0010R\u001a\u00020NH\u0002J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u001b08X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00109R\u000e\u0010:\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/tencent/xcast/GLES20Canvas$Companion;", "", "()V", "ABGR_TEXTURE_FRAGMENT_SHADER", "", "ALPHA_UNIFORM", "ARGB_TEXTURE_FRAGMENT_SHADER", "BGRA_TEXTURE_FRAGMENT_SHADER", "BLENDMODE_AND", "", "BLENDMODE_NONE", "BLENDMODE_SRCOVER", "BLENDMODE_XOR", "BOX_COORDINATES", "", "COLOR_UNIFORM", "COORDS_PER_VERTEX", "COUNT_FILL_VERTEX", "COUNT_LINE_VERTEX", "DEBUG_LOG", "", "getDEBUG_LOG", "()Z", "setDEBUG_LOG", "(Z)V", "DRAW_FRAGMENT_SHADER", "DRAW_PROGRAM_CREATOR", "Lcom/tencent/xcast/GLES20Canvas$GLES20ProgramCreator;", "DRAW_VERTEX_SHADER", "FLOAT_SIZE", "FRAGMENT_ABGR32", "FRAGMENT_ARGB32", "FRAGMENT_BGRA32", "FRAGMENT_I4XX", "FRAGMENT_I4XXF", "FRAGMENT_NVXY", "FRAGMENT_NVXYF", "FRAGMENT_NVYX", "FRAGMENT_OES_ABGR32", "FRAGMENT_OES_ARGB32", "FRAGMENT_OES_BGRA32", "INDEX_ALPHA", "INDEX_COLOR", "INDEX_MATRIX", "INDEX_POSITION", "INDEX_TEXTURE_MATRIX", "INDEX_TEXTURE_SAMPLER", "INITIAL_RESTORE_STATE_SIZE", "MATRIX_SIZE", "MATRIX_UNIFORM", "OES_PREFIX", "OES_SAMPLER", "OFFSET_DRAW_LINE", "OFFSET_FILL_RECT", "POSITION_ATTRIBUTE", "PROGRAM_CREATORS", "", "[Lcom/tencent/xcast/GLES20Canvas$GLES20ProgramCreator;", "TAG", "TEXTURE_MATRIX_UNIFORM", "TEXTURE_SAMPLER_UNIFORM0", "TEXTURE_SAMPLER_UNIFORM1", "TEXTURE_SAMPLER_UNIFORM2", "TEXTURE_VERTEX_SHADER", "TEX_PREFIX", "TEX_SAMPLER", "VERTEX_STRIDE", "YUV_I4XXF_TEXTURE_FRAGMENT_SHADER", "YUV_I4XX_TEXTURE_FRAGMENT_SHADER", "YUV_NVXYF_TEXTURE_FRAGMENT_SHADER", "YUV_NVXY_TEXTURE_FRAGMENT_SHADER", "YUV_NVYX_TEXTURE_FRAGMENT_SHADER", "checkError", "", "str", "checkErrorDebug", "convertCoordinate", "source", "Landroid/graphics/RectF;", "texture", "Lcom/tencent/xcast/BasicTexture;", "copyTextureCoordinates", "outRect", "createBuffer", "Ljava/nio/FloatBuffer;", "values", "libxcast_release"})
    public static final class Companion {
        public final boolean getDEBUG_LOG() {
            return DEBUG_LOG;
        }

        public final void setDEBUG_LOG(boolean bl) {
            DEBUG_LOG = bl;
        }

        private final FloatBuffer createBuffer(float[] fArray) {
            int n2 = fArray.length * 4;
            FloatBuffer floatBuffer = ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder()).asFloatBuffer();
            floatBuffer.put(fArray, 0, fArray.length).position(0);
            FloatBuffer floatBuffer2 = floatBuffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)floatBuffer2, (String)"buffer");
            return floatBuffer2;
        }

        private final void copyTextureCoordinates(BasicTexture basicTexture, RectF rectF) {
            int n2 = basicTexture.getPaddingX();
            int n3 = basicTexture.getPaddingY();
            int n4 = n2 + basicTexture.getWidth();
            int n5 = n3 + basicTexture.getHeight();
            rectF.set((float)n2, (float)n3, (float)n4, (float)n5);
        }

        private final void convertCoordinate(RectF rectF, BasicTexture basicTexture) {
            int n2 = basicTexture.getTextureWidth();
            int n3 = basicTexture.getTextureHeight();
            if (n2 > basicTexture.getWidth() || n3 > basicTexture.getHeight()) {
                rectF.right = rectF.right > rectF.left + 1.0f ? rectF.right - 1.0f : rectF.right;
                rectF.bottom = rectF.bottom > rectF.top + 1.0f ? rectF.bottom - 1.0f : rectF.bottom;
            }
            rectF.left /= (float)n2;
            rectF.right /= (float)n2;
            rectF.top /= (float)n3;
            rectF.bottom /= (float)n3;
        }

        public final void checkError() {
            int n2 = GLES20.glGetError();
            if (n2 != 0) {
                Log.INSTANCE.e(GLES20Canvas.TAG, "GL error: " + n2);
            }
        }

        public final void checkErrorDebug() {
            if (this.getDEBUG_LOG()) {
                this.checkError();
            }
        }

        public final void checkError(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"str");
            int n2 = GLES20.glGetError();
            if (n2 != 0) {
                Log.INSTANCE.e(GLES20Canvas.TAG, string + ".GL.error." + n2);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

