/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.opengl.GLUtils;
import android.os.Build;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore10;
import com.tencent.xcast.EGLCore14;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.EGLUtil;
import java.util.Locale;

public class EGLCore
implements EGLCoreContext {
    private static final boolean EGL14_AVAILABLE = Build.VERSION.SDK_INT >= 17;
    public static boolean LOG_EGL = false;
    public static final Object sLock = new Object();
    private EGLCoreContext mEgl;

    public EGLCore() {
        this.mEgl = EGL14_AVAILABLE ? new EGLCore14(EGLUtil.getGLMajorVersion()) : new EGLCore10(EGLUtil.getGLMajorVersion());
        if (Platform.isDebugBuild) {
            try {
                Platform.logDebug(String.format("EGLCore.%h.new.mEgl.%h", this, this.mEgl));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
    }

    EGLCore(int n2) {
        this.mEgl = EGL14_AVAILABLE ? new EGLCore14(n2) : new EGLCore10(n2);
        if (Platform.isDebugBuild) {
            try {
                Platform.logDebug(String.format(Locale.CHINA, "EGLCore.%h.new.with.version.%d.mEgl.%h", this, n2, this.mEgl));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
    }

    @Override
    public boolean createContext(EGLCoreContext eGLCoreContext, boolean bl) {
        if (eGLCoreContext != null && !(eGLCoreContext instanceof EGLCore)) {
            try {
                Platform.logError("create.shared.context.type.error");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
            return false;
        }
        return this.mEgl.createContext(eGLCoreContext != null ? ((EGLCore)eGLCoreContext).mEgl : null, bl);
    }

    @Override
    public void destroyContext() {
        this.mEgl.destroyContext();
    }

    @Override
    public boolean createSurface(Object object) {
        return this.mEgl.createSurface(object);
    }

    @Override
    public void destroySurface() {
        this.mEgl.destroySurface();
    }

    @Override
    public int makeCurrent() {
        if (this.mEgl.isCurrentContext()) {
            return 12288;
        }
        int n2 = this.mEgl.makeCurrent();
        if (n2 != 12288) {
            Platform.logError(String.format(Locale.CHINA, "%h.eglMakeCurrent.fail.%s.tid.%d", this, GLUtils.getEGLErrorString((int)n2), Thread.currentThread().getId()));
        }
        if (LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.makeCurrent.tid.%d.mEgl.%h", this, Thread.currentThread().getId(), this.mEgl));
        }
        return n2;
    }

    @Override
    public void detachCurrent() {
        if (this.mEgl.isCurrentContext()) {
            this.mEgl.detachCurrent();
            if (LOG_EGL) {
                Platform.logInfo(String.format(Locale.CHINA, "%h.detachCurrent.tid.%d.mEgl.%h", this, Thread.currentThread().getId(), this.mEgl));
            }
        }
    }

    @Override
    public boolean isCurrentContext() {
        return this.mEgl.isCurrentContext();
    }

    @Override
    public int swapBuffers() {
        int n2 = this.mEgl.swapBuffers();
        if (n2 != 12288) {
            Platform.logError(String.format(Locale.CHINA, "%h.eglSwapBuffers.fail.%s.tid.%d", this, GLUtils.getEGLErrorString((int)n2), Thread.currentThread().getId()));
        }
        return n2;
    }

    @Override
    public int swapBuffers(long l2) {
        int n2 = this.mEgl.swapBuffers(l2);
        if (n2 != 12288) {
            Platform.logError(String.format(Locale.CHINA, "%h.eglSwapBuffers.time.%d.fail.%s.tid.%d", this, l2, GLUtils.getEGLErrorString((int)n2), Thread.currentThread().getId()));
        }
        return n2;
    }

    @Override
    public boolean hasContext() {
        return this.mEgl.hasContext();
    }

    @Override
    public boolean hasSurface() {
        return this.mEgl.hasSurface();
    }

    @Override
    public String eglQueryString(int n2) {
        return this.mEgl.eglQueryString(n2);
    }

    @Override
    public int eglGetError() {
        return this.mEgl.eglGetError();
    }

    @Override
    public int retain() {
        int n2 = this.mEgl.retain();
        if (LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.retain.%d.mEgl.%h", this, n2, this.mEgl));
        }
        return n2;
    }

    @Override
    public int release() {
        int n2 = this.mEgl.release();
        if (LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.release.%d.mEgl.%h", this, n2, this.mEgl));
        }
        return n2;
    }
}

