/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.tencent.avlab.sdk.Platform;
import java.util.ArrayList;
import java.util.List;

public class AppLifecycle
implements Runnable {
    private static final String TAG = "AppLifecycle";
    private final Object mObj = new Object();
    private List<LifecycleObserver> mObservers;
    private AppLifecycleListener mListener;
    private boolean mIsForeground;
    private Handler mHandler;
    private Application mApp;
    private ActivityManager mActivityManager;
    private String mProcessName;
    private ScreenBroadcastReceiver mReceiver;

    public static AppLifecycle create(Context context, Handler handler) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            Platform.logDebug("called int none main thread");
        }
        Application application = (Application)context.getApplicationContext();
        return new AppLifecycle(application, handler);
    }

    private AppLifecycle(Application application, Handler handler) {
        this.mApp = application;
        this.mObservers = new ArrayList<LifecycleObserver>();
        this.mListener = new AppLifecycleListener();
        this.mHandler = handler;
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mListener);
        this.mActivityManager = (ActivityManager)application.getSystemService("activity");
        this.mProcessName = String.valueOf(application.getApplicationInfo().processName);
        this.mIsForeground = AppLifecycle.isAppForeground(this.mActivityManager, this.mProcessName);
        this.mReceiver = new ScreenBroadcastReceiver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        application.registerReceiver((BroadcastReceiver)this.mReceiver, intentFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addObserver(LifecycleObserver lifecycleObserver) {
        Object object = this.mObj;
        synchronized (object) {
            if (this.mObservers != null) {
                return this.mObservers.add(lifecycleObserver);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(LifecycleObserver lifecycleObserver) {
        Object object = this.mObj;
        synchronized (object) {
            if (this.mObservers != null) {
                this.mObservers.remove(lifecycleObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mObj;
        synchronized (object) {
            this.mApp.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mListener);
            this.mApp.unregisterReceiver((BroadcastReceiver)this.mReceiver);
            this.mObservers.clear();
            this.mListener = null;
            this.mActivityManager = null;
            this.mObservers = null;
            this.mHandler = null;
            this.mApp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.mObj;
        synchronized (object) {
            boolean bl;
            if (this.mActivityManager != null && (bl = AppLifecycle.isAppForeground(this.mActivityManager, this.mProcessName)) != this.mIsForeground) {
                this.mIsForeground = bl;
                for (LifecycleObserver lifecycleObserver : this.mObservers) {
                    if (bl) {
                        lifecycleObserver.onAppForegrounded();
                        continue;
                    }
                    lifecycleObserver.onAppBackgrounded();
                }
            }
        }
    }

    public static boolean isAppForeground(ActivityManager activityManager, String string) {
        List list = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (runningAppProcessInfo.importance != 100 || !runningAppProcessInfo.processName.equals(string)) continue;
            return true;
        }
        return false;
    }

    public class AppLifecycleListener
    implements Application.ActivityLifecycleCallbacks {
        public void onActivityCreated(Activity activity, Bundle bundle) {
            if (Platform.isDebugLevel()) {
                Platform.logInfo("onActivityCreated:" + activity.getLocalClassName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityStarted(Activity activity) {
            Platform.logInfo("onActivityStarted:" + activity.getLocalClassName());
            Object object = AppLifecycle.this.mObj;
            synchronized (object) {
                if (AppLifecycle.this.mHandler != null) {
                    AppLifecycle.this.mHandler.post((Runnable)AppLifecycle.this);
                }
            }
        }

        public void onActivityResumed(Activity activity) {
            if (Platform.isDebugLevel()) {
                Platform.logInfo("onActivityResumed:" + activity.getLocalClassName());
            }
        }

        public void onActivityPaused(Activity activity) {
            if (Platform.isDebugLevel()) {
                Platform.logInfo("onActivityPaused:" + activity.getLocalClassName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityStopped(Activity activity) {
            Platform.logInfo("onActivityStopped:" + activity.getLocalClassName());
            Object object = AppLifecycle.this.mObj;
            synchronized (object) {
                if (AppLifecycle.this.mHandler != null) {
                    AppLifecycle.this.mHandler.post((Runnable)AppLifecycle.this);
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (Platform.isDebugLevel()) {
                Platform.logDebug("onActivityDestroyed:" + activity.getLocalClassName());
            }
        }
    }

    private class ScreenBroadcastReceiver
    extends BroadcastReceiver
    implements Runnable {
        private ScreenBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(string)) {
                Platform.logInfo("receive screen off");
                Object object = AppLifecycle.this.mObj;
                synchronized (object) {
                    if (AppLifecycle.this.mHandler != null) {
                        AppLifecycle.this.mHandler.post((Runnable)this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AppLifecycle.this.mObj;
            synchronized (object) {
                if (AppLifecycle.this.mActivityManager != null) {
                    if (AppLifecycle.this.mIsForeground) {
                        Platform.logInfo("notify background");
                        AppLifecycle.this.mIsForeground = false;
                        for (LifecycleObserver lifecycleObserver : AppLifecycle.this.mObservers) {
                            lifecycleObserver.onAppBackgrounded();
                        }
                    } else {
                        Platform.logInfo("already background");
                    }
                }
            }
        }
    }

    public static interface LifecycleObserver {
        public void onAppBackgrounded();

        public void onAppForegrounded();
    }
}

