/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wecast.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;
import com.tencent.wecast.utils.e;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NetworkUtil {
    @SuppressLint(value={"MissingPermission"})
    private static NetworkInfo g(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return null;
        }
        return connectivityManager.getActiveNetworkInfo();
    }

    private static NetworkCapabilities h(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
        }
        return null;
    }

    public static NetworkType a(Context context) {
        NetworkType networkType = NetworkType.NETWORK_UNKNOWN;
        NetworkInfo networkInfo = NetworkUtil.g(context);
        if (networkInfo != null && networkInfo.isAvailable()) {
            if (networkInfo.getType() == 1) {
                networkType = NetworkType.NETWORK_WIFI;
            } else if (networkInfo.getType() == 9) {
                networkType = NetworkType.NETWORK_ETHERNET;
            } else if (networkInfo.getType() == 0) {
                switch (networkInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        networkType = NetworkType.NETWORK_2G;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        networkType = NetworkType.NETWORK_3G;
                        break;
                    }
                    case 13: 
                    case 18: {
                        networkType = NetworkType.NETWORK_4G;
                        break;
                    }
                    default: {
                        String string = networkInfo.getSubtypeName();
                        if (string.equalsIgnoreCase("TD-SCDMA") || string.equalsIgnoreCase("WCDMA") || string.equalsIgnoreCase("CDMA2000")) {
                            networkType = NetworkType.NETWORK_3G;
                            break;
                        }
                        networkType = NetworkType.NETWORK_UNKNOWN;
                        break;
                    }
                }
            } else {
                networkType = NetworkType.NETWORK_UNKNOWN;
            }
        }
        return networkType;
    }

    public static boolean b(Context context) {
        block4: {
            try {
                if (Build.VERSION.SDK_INT >= 28) {
                    NetworkCapabilities networkCapabilities = NetworkUtil.h(context);
                    if (networkCapabilities != null) {
                        return networkCapabilities.hasTransport(1);
                    }
                    break block4;
                }
                String string = NetworkUtil.e(context);
                return string.equalsIgnoreCase("wifi");
            }
            catch (Exception exception) {
                e.a("NetworkUtil").b("Exception: " + exception.toString(), new Object[0]);
            }
        }
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String c(Context context) {
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            if (wifiInfo != null) {
                String string = wifiInfo.getSSID();
                if (!TextUtils.isEmpty((CharSequence)string) && string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "Unknown";
    }

    @SuppressLint(value={"MissingPermission"})
    public static String d(Context context) {
        String string = "";
        if (context == null) {
            return string;
        }
        try {
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            string = wifiInfo.getBSSID();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public static String e(Context context) {
        NetworkType networkType = NetworkUtil.a(context);
        switch (networkType) {
            case NETWORK_2G: {
                return "2G";
            }
            case NETWORK_3G: {
                return "3G";
            }
            case NETWORK_4G: {
                return "4G";
            }
            case NETWORK_WIFI: {
                return "wifi";
            }
            case NETWORK_ETHERNET: {
                return "wired";
            }
        }
        return "unknown";
    }

    public static NetworkInterface a() {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            return null;
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                return networkInterface;
            }
        }
        return null;
    }

    public static InetAddress a(NetworkInterface networkInterface) {
        Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress = enumeration.nextElement();
            if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
            return inetAddress;
        }
        return null;
    }

    public static String b() {
        InetAddress inetAddress;
        NetworkInterface networkInterface = NetworkUtil.a();
        if (null != networkInterface && (inetAddress = NetworkUtil.a(networkInterface)) != null) {
            return inetAddress.getHostAddress();
        }
        return "";
    }

    public static boolean f(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager connectivityManager;
        if (context != null && (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")) != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null) {
            return networkInfo.isAvailable();
        }
        return false;
    }

    public static enum NetworkType {
        NETWORK_ETHERNET,
        NETWORK_WIFI,
        NETWORK_4G,
        NETWORK_3G,
        NETWORK_2G,
        NETWORK_UNKNOWN;

    }
}

