/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tiwlogger.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class Util {
    private static Context context;
    private static int lastMemUsage;
    private static boolean isMemCheck;
    private static int[] lastCpuUsage;
    private static float totoalCpuTime1;
    private static float totoalCpuTime2;
    private static float processCpuTime1;
    private static float processCpuTime2;
    private static float idleCpuTime1;
    private static float idleCpuTime2;
    private static boolean isCpuFirstRun;

    public static void init(Context context) {
        Util.context = context;
    }

    public static String getPlatform() {
        return "android";
    }

    public static String getDevType() {
        return String.format("%s=%s", Build.BRAND, Build.MODEL);
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getAndroidSdkVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static int getNetType() {
        NetworkInfo.State state;
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == connManager) {
            return 1;
        }
        NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
        if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
            return 1;
        }
        NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
        if (null != wifiInfo && null != (state = wifiInfo.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return 6;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        int networkType = telephonyManager.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 3;
            }
            case 13: {
                return 4;
            }
        }
        return 1;
    }

    private static long getAppCPUTime() {
        String[] cpuInfos = null;
        long appCpuTime = 0L;
        try {
            int pid = Process.myPid();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + pid + "/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
            if (cpuInfos != null && !TextUtils.isEmpty((CharSequence)cpuInfos[13])) {
                appCpuTime = Long.parseLong(cpuInfos[13]) + Long.parseLong(cpuInfos[14]) + Long.parseLong(cpuInfos[15]) + Long.parseLong(cpuInfos[16]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return appCpuTime;
    }

    private static void getTotalIdleCpuTime() {
        String[] cpuInfos = null;
        long totalCpu = 0L;
        long idleCpu = 0L;
        if (Build.VERSION.SDK_INT < 26) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1000);
                if (reader != null) {
                    String load = reader.readLine();
                    reader.close();
                    cpuInfos = load.split(" ");
                    if (cpuInfos != null && cpuInfos.length >= 9) {
                        totalCpu = Long.parseLong(cpuInfos[2]) + Long.parseLong(cpuInfos[3]) + Long.parseLong(cpuInfos[4]) + Long.parseLong(cpuInfos[6]) + Long.parseLong(cpuInfos[5]) + Long.parseLong(cpuInfos[7]) + Long.parseLong(cpuInfos[8]);
                        idleCpu = Long.parseLong(cpuInfos[5]) + Long.parseLong(cpuInfos[6]);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (isCpuFirstRun) {
            totoalCpuTime1 = totalCpu;
            idleCpuTime1 = idleCpu;
        } else {
            totoalCpuTime2 = totalCpu;
            idleCpuTime2 = idleCpu;
        }
    }

    private static int[] getCPUUsage() {
        int[] result = new int[2];
        if (isCpuFirstRun) {
            processCpuTime1 = Util.getAppCPUTime();
            Util.getTotalIdleCpuTime();
            isCpuFirstRun = false;
            result[0] = 0;
            result[1] = 0;
            return result;
        }
        float processRate = 0.0f;
        float totalRate = 0.0f;
        processCpuTime2 = Util.getAppCPUTime();
        Util.getTotalIdleCpuTime();
        if (totoalCpuTime2 != totoalCpuTime1) {
            processRate = 100.0f * (processCpuTime2 - processCpuTime1) / (totoalCpuTime2 - totoalCpuTime1);
            totalRate = 100.0f * (totoalCpuTime2 - totoalCpuTime1 - (idleCpuTime2 - idleCpuTime1)) / (totoalCpuTime2 - totoalCpuTime1);
        }
        totoalCpuTime1 = totoalCpuTime2;
        processCpuTime1 = processCpuTime2;
        idleCpuTime1 = idleCpuTime2;
        result[0] = (int)(processRate * 10.0f);
        result[1] = (int)(totalRate * 10.0f);
        Util.lastCpuUsage[0] = result[0];
        Util.lastCpuUsage[1] = result[1];
        return result;
    }

    public static int getAppCpuUsage() {
        return Util.getCPUUsage()[0] / 10;
    }

    public static int getSysCpuUsage() {
        return Util.getCPUUsage()[1] / 10;
    }

    public static int getAppMemUsage() {
        isMemCheck = true;
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                int totalPss = 0;
                long ts = System.currentTimeMillis();
                isMemCheck = false;
                try {
                    Debug.MemoryInfo memoryInfo = new Debug.MemoryInfo();
                    Debug.getMemoryInfo((Debug.MemoryInfo)memoryInfo);
                    totalPss = memoryInfo.getTotalPss();
                    lastMemUsage = totalPss / 1024;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return lastMemUsage;
    }

    public static int getAvailableMemUsage() {
        Runtime r = Runtime.getRuntime();
        long used = r.totalMemory() - r.freeMemory();
        long available = r.maxMemory() - used;
        return (int)(available / 1024L / 1024L);
    }

    static {
        lastMemUsage = 0;
        isMemCheck = false;
        lastCpuUsage = new int[2];
        totoalCpuTime1 = 0.0f;
        totoalCpuTime2 = 0.0f;
        processCpuTime1 = 0.0f;
        processCpuTime2 = 0.0f;
        idleCpuTime1 = 0.0f;
        idleCpuTime2 = 0.0f;
        isCpuFirstRun = true;
    }

    private class NetType {
        public static final int NONE = 1;
        public static final int G2 = 2;
        public static final int G3 = 3;
        public static final int G4 = 4;
        public static final int G5 = 5;
        public static final int WIFI = 6;

        private NetType() {
        }
    }
}

