/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tiwlogger;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import com.tencent.tiwlogger.TIWLogParam;
import com.tencent.tiwlogger.TIWLoggerConfig;
import com.tencent.tiwlogger.logger.Logger;
import com.tencent.tiwlogger.util.Util;

public class TIWLoggerImpl {
    private Logger logger = new Logger();
    private Context context;
    private boolean isConsoleEnable;

    public TIWLoggerImpl(Context context) {
        this.context = context.getApplicationContext();
        this.isConsoleEnable = true;
        Util.init(this.context);
    }

    public void setConfig(TIWLoggerConfig config) {
        config.bundleId = this.context.getPackageName();
        try {
            config.appVersion = this.context.getPackageManager().getPackageInfo((String)config.bundleId, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            config.appVersion = "";
        }
        this.logger.setConfig(config);
    }

    public void log(TIWLogParam param) {
        this.logEnded("", param);
    }

    public void logStart(String label) {
        this.logger.logStart(label);
    }

    public void logEnded(String label, TIWLogParam param) {
        String content = this.logger.logEnded(label, param);
        if (this.isConsoleEnable) {
            switch (param.level) {
                case 1: {
                    Log.d((String)param.module, (String)content);
                    break;
                }
                case 2: {
                    Log.i((String)param.module, (String)content);
                    break;
                }
                case 3: {
                    Log.w((String)param.module, (String)content);
                    break;
                }
                case 4: {
                    Log.e((String)param.module, (String)content);
                    break;
                }
                case 5: {
                    Log.e((String)param.module, (String)content);
                    break;
                }
            }
        }
    }

    public static String getVersion() {
        return "1.0.1.23";
    }

    public String getSessionId() {
        return this.logger.getSessionId();
    }

    public String getGlobalRandom() {
        return this.logger.getGlobalRandom();
    }

    public void enableConsole(boolean enable) {
        this.isConsoleEnable = enable;
    }
}

