/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tiw.logger;

import android.content.Context;
import com.tencent.tiw.logger.TIWLoggerConfig;
import com.tencent.tiw.logger.TIWLoggerImpl;
import com.tencent.tiw.logger.TIWReportParam;

public class TIWLogger {
    private TIWLoggerImpl loggerImpl;
    private static TIWLoggerImpl gLoggerImpl;

    public TIWLogger(Context context) {
        this.loggerImpl = new TIWLoggerImpl(context);
    }

    public void setConfig(TIWLoggerConfig config) {
        this.loggerImpl.setConfig(config);
    }

    public void log(int level, String tag, String content) {
        this.loggerImpl.log(level, tag, content);
    }

    public void reportStart(String label) {
        this.loggerImpl.reportStart(label);
    }

    public void reportEnded(String label, TIWReportParam param) {
        this.loggerImpl.reportEnded(label, param);
    }

    public void report(TIWReportParam param) {
        this.loggerImpl.report(param);
    }

    public static String getVersion() {
        return TIWLoggerImpl.getVersion();
    }

    public String getSessionId() {
        return this.loggerImpl.getSessionId();
    }

    public String getGlobalRandom() {
        return this.loggerImpl.getGlobalRandom();
    }

    public static void INIT(Context context) {
        gLoggerImpl = new TIWLoggerImpl(context);
    }

    public static void CONFIG(TIWLoggerConfig config) {
        gLoggerImpl.setConfig(config);
    }

    public static void LOG(int level, String tag, String content) {
        gLoggerImpl.log(level, tag, content);
    }

    public static void DLOG(String tag, String content) {
        gLoggerImpl.log(1, tag, content);
    }

    public static void ILOG(String tag, String content) {
        gLoggerImpl.log(2, tag, content);
    }

    public static void WLOG(String tag, String content) {
        gLoggerImpl.log(3, tag, content);
    }

    public static void ELOG(String tag, String content) {
        gLoggerImpl.log(4, tag, content);
    }

    public static void FLOG(String tag, String content) {
        gLoggerImpl.log(5, tag, content);
    }

    public static void DREPORT(String action, String param, String ext, int code, String desc, String stack) {
        TIWLogger.REPORT(1, action, param, ext, code, desc, stack);
    }

    public static void IREPORT(String action, String param, String ext, int code, String desc, String stack) {
        TIWLogger.REPORT(2, action, param, ext, code, desc, stack);
    }

    public static void WREPORT(String action, String param, String ext, int code, String desc, String stack) {
        TIWLogger.REPORT(3, action, param, ext, code, desc, stack);
    }

    public static void EREPORT(String action, String param, String ext, int code, String desc, String stack) {
        TIWLogger.REPORT(4, action, param, ext, code, desc, stack);
    }

    public static void FREPORT(String action, String param, String ext, int code, String desc, String stack) {
        TIWLogger.REPORT(5, action, param, ext, code, desc, stack);
    }

    public static void REPORT(int level, String action, String param, String ext, int code, String desc, String stack) {
        TIWReportParam rp = new TIWReportParam();
        rp.level = level;
        rp.actionName = action;
        rp.actionParam = param;
        rp.actionExt = ext;
        rp.errorCode = code;
        rp.errorDesc = desc;
        rp.errorStack = stack;
        gLoggerImpl.report(rp);
    }

    public static void REPORT_START(String label) {
        gLoggerImpl.reportStart(label);
    }

    public static void REPORT_ENDED(String label, int level, String action, String param, String ext, int code, String desc, String stack) {
        TIWReportParam rp = new TIWReportParam();
        rp.level = level;
        rp.actionName = action;
        rp.actionParam = param;
        rp.actionExt = ext;
        rp.errorCode = code;
        rp.errorDesc = desc;
        rp.errorStack = stack;
        gLoggerImpl.reportEnded(label, rp);
    }

    public static void DREPORT_END(String label, String action, String param, String ext, int code, String desc, String stack) {
        TIWLogger.REPORT_ENDED(label, 1, action, param, ext, code, desc, stack);
    }

    public static void IREPORT_END(String label, String action, String param, String ext, int code, String desc, String stack) {
        TIWLogger.REPORT_ENDED(label, 2, action, param, ext, code, desc, stack);
    }

    public static void WREPORT_END(String label, String action, String param, String ext, int code, String desc, String stack) {
        TIWLogger.REPORT_ENDED(label, 3, action, param, ext, code, desc, stack);
    }

    public static void EREPORT_END(String label, String action, String param, String ext, int code, String desc, String stack) {
        TIWLogger.REPORT_ENDED(label, 4, action, param, ext, code, desc, stack);
    }

    public static void FREPORT_END(String label, String action, String param, String ext, int code, String desc, String stack) {
        TIWLogger.REPORT_ENDED(label, 5, action, param, ext, code, desc, stack);
    }

    public static void UNINIT() {
        gLoggerImpl = null;
    }

    public static String SESSIONID() {
        return gLoggerImpl.getSessionId();
    }

    public static String GLOBALRANDOM() {
        return gLoggerImpl.getGlobalRandom();
    }
}

