package com.tencent.tiw.logger.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Debug;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class Util {
    private class NetType {
        public static final int NONE  = 1;
        public static final int G2    = 2;
        public static final int G3    = 3;
        public static final int G4    = 4;
        public static final int G5    = 5;
        public static final int WIFI  = 6;
    }

    private static Context context;

    private static int lastMemUsage = 0;
    private static boolean isMemCheck = false;
    private static int[] lastCpuUsage = new int[2];
    private static float totoalCpuTime1  = 0;
    private static float totoalCpuTime2  = 0;
    private static float processCpuTime1 = 0;
    private static float processCpuTime2 = 0;
    private static float idleCpuTime1    = 0;
    private static float idleCpuTime2    = 0;
    private static boolean isCpuFirstRun  = true;

    public static void init(Context context) {
        Util.context = context;
    }

    public static String getPlatform() {
        return "android";
    }

    public static String getDevType() {
        return String.format("%s=%s", Build.BRAND, Build.MODEL);
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getAndroidSdkVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static int getNetType() {
        ConnectivityManager connManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE); // 获取网络服务
        if (null == connManager) { // 为空则认为无网络
            return NetType.NONE;
        }
        // 获取网络类型，如果为空，返回无网络
        NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
        if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
            return NetType.NONE;
        }
        // 判断是否为WIFI
        NetworkInfo wifiInfo = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
        if (null != wifiInfo) {
            NetworkInfo.State state = wifiInfo.getState();
            if (null != state) {
                if (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING) {
                    return NetType.WIFI;
                }
            }
        }
        // 若不是WIFI，则去判断是2G、3G、4G网
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        int networkType = telephonyManager.getNetworkType();
        switch (networkType) {
            /*
             GPRS : 2G(2.5) General Packet Radia Service 114kbps
             EDGE : 2G(2.75G) Enhanced Data Rate for GSM Evolution 384kbps
             UMTS : 3G WCDMA 联通3G Universal Mobile Telecommunication System 完整的3G移动通信技术标准
             CDMA : 2G 电信 Code Division Multiple Access 码分多址
             EVDO_0 : 3G (EVDO 全程 CDMA2000 1xEV-DO) Evolution - Data Only (Data Optimized) 153.6kps - 2.4mbps 属于3G
             EVDO_A : 3G 1.8mbps - 3.1mbps 属于3G过渡，3.5G
             1xRTT : 2G CDMA2000 1xRTT (RTT - 无线电传输技术) 144kbps 2G的过渡,
             HSDPA : 3.5G 高速下行分组接入 3.5G WCDMA High Speed Downlink Packet Access 14.4mbps
             HSUPA : 3.5G High Speed Uplink Packet Access 高速上行链路分组接入 1.4 - 5.8 mbps
             HSPA : 3G (分HSDPA,HSUPA) High Speed Packet Access
             IDEN : 2G Integrated Dispatch Enhanced Networks 集成数字增强型网络 （属于2G，来自维基百科）
             EVDO_B : 3G EV-DO Rev.B 14.7Mbps 下行 3.5G
             LTE : 4G Long Term Evolution FDD-LTE 和 TDD-LTE , 3G过渡，升级版 LTE Advanced 才是4G
             EHRPD : 3G CDMA2000向LTE 4G的中间产物 Evolved High Rate Packet Data HRPD的升级
             HSPAP : 3G HSPAP 比 HSDPA 快些
             */
            // 2G网络
            case TelephonyManager.NETWORK_TYPE_GPRS:
            case TelephonyManager.NETWORK_TYPE_CDMA:
            case TelephonyManager.NETWORK_TYPE_EDGE:
            case TelephonyManager.NETWORK_TYPE_1xRTT:
            case TelephonyManager.NETWORK_TYPE_IDEN:
                return NetType.G2;
            // 3G网络
            case TelephonyManager.NETWORK_TYPE_EVDO_A:
            case TelephonyManager.NETWORK_TYPE_UMTS:
            case TelephonyManager.NETWORK_TYPE_EVDO_0:
            case TelephonyManager.NETWORK_TYPE_HSDPA:
            case TelephonyManager.NETWORK_TYPE_HSUPA:
            case TelephonyManager.NETWORK_TYPE_HSPA:
            case TelephonyManager.NETWORK_TYPE_EVDO_B:
            case TelephonyManager.NETWORK_TYPE_EHRPD:
            case TelephonyManager.NETWORK_TYPE_HSPAP:
                return NetType.G3;
            // 4G网络
            case TelephonyManager.NETWORK_TYPE_LTE:
                return NetType.G4;
            default:
                return NetType.NONE;
        }
    }

    private static long getAppCPUTime() {
        String[] cpuInfos = null;
        long appCpuTime = 0;
        try
        {
            int pid = android.os.Process.myPid();
            BufferedReader reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream("/proc/" + pid + "/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
            if (cpuInfos != null && !TextUtils.isEmpty(cpuInfos[13])) {
                appCpuTime = Long.parseLong(cpuInfos[13])
                        + Long.parseLong(cpuInfos[14]) + Long.parseLong(cpuInfos[15])
                        + Long.parseLong(cpuInfos[16]);
            }
        }
        catch (Exception ex)
        {
            ex.printStackTrace();
        }
        return appCpuTime;
    }

    private static void getTotalIdleCpuTime() {
        String[] cpuInfos = null;
        long totalCpu = 0;
        long idleCpu = 0;
        if (Build.VERSION.SDK_INT < 26) {
            try
            {
                BufferedReader reader = new BufferedReader(new InputStreamReader(
                        new FileInputStream("/proc/stat")), 1000);
                if (reader != null) {
                    String load = reader.readLine();
                    reader.close();
                    cpuInfos = load.split(" ");
                    if (cpuInfos != null && cpuInfos.length >= 9) {
                        totalCpu = Long.parseLong(cpuInfos[2])
                                + Long.parseLong(cpuInfos[3]) + Long.parseLong(cpuInfos[4])
                                + Long.parseLong(cpuInfos[6]) + Long.parseLong(cpuInfos[5])
                                + Long.parseLong(cpuInfos[7]) + Long.parseLong(cpuInfos[8]);
                        idleCpu =Long.parseLong(cpuInfos[5]) + Long.parseLong(cpuInfos[6]);
                    }
                }
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }

        if (isCpuFirstRun) {
            totoalCpuTime1  = totalCpu;
            idleCpuTime1    = idleCpu;
        } else {
            totoalCpuTime2   = totalCpu;
            idleCpuTime2     = idleCpu;
        }
    }

    private static int[] getCPUUsage(){
        int[] result = new int[2];
        if (isCpuFirstRun){
            processCpuTime1 = getAppCPUTime();
            getTotalIdleCpuTime();
            isCpuFirstRun    = false;
            result[0] = 0;
            result[1] = 0;
            return result;
        }

        float processRate = 0.0f;
        float totalRate = 0.0f;

        processCpuTime2  = getAppCPUTime();
        getTotalIdleCpuTime();
        if (totoalCpuTime2 != totoalCpuTime1) {
            processRate = 100 * (processCpuTime2 - processCpuTime1) / (totoalCpuTime2 - totoalCpuTime1);
            totalRate   = 100 * (totoalCpuTime2 - totoalCpuTime1 - (idleCpuTime2 - idleCpuTime1)) / (totoalCpuTime2 - totoalCpuTime1);
        }


        totoalCpuTime1   = totoalCpuTime2;
        processCpuTime1  = processCpuTime2;
        idleCpuTime1     = idleCpuTime2;


        result[0] = (int)(processRate*10);  ///< app cpu rate.
        result[1] = (int)(totalRate*10);    ///< total cpu rate.
        lastCpuUsage[0] = result[0];
        lastCpuUsage[1] = result[1];
        return result;
    }

    public static int getAppCpuUsage() {
        return getCPUUsage()[0] / 10;
    }

    public static int getSysCpuUsage() {
        return getCPUUsage()[1] / 10;
    }

    public static int getAppMemUsage() {
        isMemCheck = true;
        AsyncTask.execute(new Runnable() {
            @Override
            public void run() {
                int totalPss = 0;
                long ts = System.currentTimeMillis();
                isMemCheck = false;
                try {
                    Debug.MemoryInfo memoryInfo = new Debug.MemoryInfo();
                    Debug.getMemoryInfo(memoryInfo);
                    totalPss = memoryInfo.getTotalPss();
                    lastMemUsage = totalPss / 1024;
                } catch (Exception e) {
                }
            }
        });
        return lastMemUsage ;
    }

    public static int getAvailableMemUsage() {
        Runtime r = Runtime.getRuntime();
        long used = r.totalMemory() - r.freeMemory();
        long available = r.maxMemory() - used;
        return (int)(available / 1024 / 1024);
    }
}
