package com.tencent.tiw.logger.logger;

import com.tencent.tiw.logger.TIWLogParam;
import com.tencent.tiw.logger.TIWLoggerConfig;
import com.tencent.tiw.logger.TIWReportParam;

public class Logger {
    protected long cptr;
    static {
        try {
            System.loadLibrary("TIWLogger");
        } catch (UnsatisfiedLinkError e) {
        }
    }

    public Logger() {
        this.initLogger();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.unInitLogger();
    }

    private native void initLogger();
    private native void unInitLogger();

    public native void setConfig(TIWLoggerConfig config);
    public native void reportStart(String label);
    public native void reportEnded(String label, TIWReportParam param);
    public native void report(TIWReportParam param);
    public native void log(TIWLogParam param);
    public native String getSessionId();
    public native String getGlobalRandom();
}
