package com.tencent.tiw.logger;

import android.content.Context;
import android.util.Log;

import com.tencent.tiw.logger.logger.Logger;
import com.tencent.tiw.logger.util.Util;

public class TIWLoggerImpl {
    private Logger logger;
    private Context context;

    public TIWLoggerImpl(Context context) {
        this.logger = new Logger();
        this.context = context.getApplicationContext();
        Util.init(this.context);
    }
    public void setConfig(TIWLoggerConfig config) {
        this.logger.setConfig(config);
    }

    public void log(int level, String tag, String content) {
        switch (level) {
            case TIWLogLevel.DEBUG:
                Log.d(tag, content);
                break;
            case TIWLogLevel.INFO:
                Log.i(tag, content);
                break;
            case TIWLogLevel.WARN:
                Log.w(tag, content);
                break;
            case TIWLogLevel.ERROR:
                Log.e(tag, content);
                break;
            case TIWLogLevel.FATAL:
                Log.e(tag, content);
                break;
                default:
                    break;
        }
        TIWLogParam param = new TIWLogParam();
        param.level = level;
        param.module = tag;
        param.content = content;
        param.funcName = "";
        param.fileName = "";
        this.logger.log(param);
    }

    public void reportStart(String label) {
        this.logger.reportStart(label);
    }

    public void reportEnded(String label, TIWReportParam param) {
        this.logger.reportEnded(label, param);
    }

    public void report(TIWReportParam param) {
        this.logger.report(param);
    }

    public static String getVersion() {
        return BuildConfig.VERSION_NAME;
    }

    public String getSessionId() {
        return this.logger.getSessionId();
    }

    public String getGlobalRandom() {
        return this.logger.getGlobalRandom();
    }
}
