/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.quic;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.CallMetricsListener;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.NetworkProxy;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import com.tencent.qcloud.core.http.ResponseFileConverter;
import com.tencent.qcloud.quic.ProgressCallback;
import com.tencent.qcloud.quic.QLog;
import com.tencent.qcloud.quic.QuicImpl;
import com.tencent.qcloud.quic.QuicManager;
import com.tencent.qcloud.quic.QuicRequest;
import com.tencent.qcloud.quic.QuicResponse;
import java.io.Closeable;
import java.net.InetAddress;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;

public class QuicProxy<T>
extends NetworkProxy<T> {
    private QuicImpl quic;
    private QuicManager quicManager;

    public QuicProxy(QuicManager quicManager) {
        this.quicManager = quicManager;
    }

    public void cancel() {
        if (this.quic != null) {
            this.quic.cancelConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResult<T> executeHttpRequest(HttpRequest<T> httpRequest) throws QCloudClientException, QCloudServiceException {
        Response response = null;
        HttpResult<T> httpResult = null;
        QCloudClientException clientException = null;
        QCloudServiceException serviceException = null;
        int attempt = 0;
        long startTime = System.nanoTime();
        while (true) {
            try {
                httpRequest.setOkHttpRequestTag(this.identifier);
                Request okHttpRequest = httpRequest.buildRealRequest();
                HttpUrl httpUrl = okHttpRequest.url();
                String host = httpUrl.host();
                boolean isHttps = httpUrl.isHttps();
                String url = httpUrl.toString();
                int index = url.indexOf("/", isHttps ? 8 : 7);
                String path = "/";
                if (index > 0) {
                    path = url.substring(index);
                }
                String ip = null;
                CallMetricsListener callMetricsListener = new CallMetricsListener(null);
                callMetricsListener.dnsStart(null, host);
                List inetAddresses = this.quicManager.dns.lookup(host);
                if (inetAddresses != null && inetAddresses.size() > 0) {
                    ip = ((InetAddress)inetAddresses.get(0)).getHostAddress();
                    QLog.d("dns ip: " + ip, new Object[0]);
                }
                callMetricsListener.dnsEnd(null, host, inetAddresses);
                int port = httpUrl.port();
                int tcpPort = 80;
                String method = okHttpRequest.method().toUpperCase();
                QuicRequest quicRequest = new QuicRequest(host, ip, port, tcpPort);
                quicRequest.addHeader(":scheme", isHttps ? "https" : "http");
                quicRequest.addHeader(":method", method);
                quicRequest.addHeader(":path", path);
                Headers headers = okHttpRequest.headers();
                int size = headers.size();
                for (int i = 0; i < size; ++i) {
                    String headerKey = headers.name(i);
                    if ("Host".equalsIgnoreCase(headerKey)) {
                        quicRequest.addHeader("Vod-Forward-Cos".toLowerCase(), headers.value(i));
                        continue;
                    }
                    if ("User-Agent".equalsIgnoreCase(headerKey)) {
                        String headerValue = headers.value(i);
                        int pos = headerValue.lastIndexOf(45);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(headerValue.substring(0, pos)).append("-").append("quic").append(headerValue.substring(pos + 1));
                        quicRequest.addHeader("User-Agent".toLowerCase(), stringBuilder.toString());
                        continue;
                    }
                    quicRequest.addHeader(headers.name(i).toLowerCase(), headers.value(i));
                }
                quicRequest.addHeader(":authority", host);
                quicRequest.setRequestBody(okHttpRequest.body());
                String requestStartMessage = "--> " + okHttpRequest.method() + ' ' + okHttpRequest.url() + ' ' + "quic";
                this.quicManager.httpLogger.logRequest(requestStartMessage);
                this.quic = this.quicManager.newQuicImpl(quicRequest);
                this.quic.setCallMetricsListener(callMetricsListener);
                ResponseBodyConverter converter = httpRequest.getResponseBodyConverter();
                if (converter instanceof ResponseFileConverter) {
                    ((ResponseFileConverter)converter).enableQuic(true);
                    ((ResponseFileConverter)converter).setProgressListener(this.mProgressListener);
                    final QCloudProgressListener progressListener = ((ResponseFileConverter)converter).getProgressListener();
                    this.quic.setProgressCallback(new ProgressCallback(){

                        @Override
                        public void onProgress(long current, long total) {
                            progressListener.onProgress(current, total);
                        }
                    });
                    this.quic.setOutputDestination(((ResponseFileConverter)converter).getOutputStream());
                }
                QuicResponse quicResponse = this.quic.call();
                response = quicResponse.covertResponse(okHttpRequest);
                this.quicManager.httpLogger.logResponse(response, "<-- " + response.code() + ' ' + response.message() + ' ' + response.request().url());
                httpResult = this.convertResponse(httpRequest, response);
                callMetricsListener.dumpMetrics(this.metrics);
                Util.closeQuietly((Closeable)response);
            }
            catch (Exception e) {
                block17: {
                    if (e.getCause() instanceof QCloudServiceException) {
                        serviceException = (QCloudServiceException)e.getCause();
                        break;
                    }
                    if (!this.quicManager.retryStrategy.shouldRetry(attempt++, System.nanoTime() - startTime)) break block17;
                    QLog.d("%s failed for %s, %d", httpRequest.url().toString(), e.getMessage(), attempt);
                    continue;
                }
                if (e.getCause() instanceof QCloudClientException) {
                    clientException = (QCloudClientException)e.getCause();
                    break;
                }
                clientException = new QCloudClientException((Throwable)e);
            }
            finally {
                Util.closeQuietly(response);
                continue;
            }
            break;
        }
        if (clientException != null) {
            throw clientException;
        }
        if (serviceException != null) {
            throw serviceException;
        }
        return httpResult;
    }

    protected HttpResult<T> convertResponse(HttpRequest<T> httpRequest, Response response) throws QCloudClientException, QCloudServiceException {
        HttpResponse httpResponse = new HttpResponse(httpRequest, response);
        ResponseBodyConverter converter = httpRequest.getResponseBodyConverter();
        Object content = converter.convert(httpResponse);
        return new HttpResult(httpResponse, content);
    }
}

