package com.tencent.qcloud.quic;

import com.tencent.qcloud.core.http.HttpLogger;
import com.tencent.qcloud.core.task.RetryStrategy;

/**
 * 开启一个线程池跑request
 */
public class QuicManager {

    private ConnectPool connectPool = new ConnectPool();
    protected RetryStrategy retryStrategy;
    protected HttpLogger httpLogger;

    public void init(boolean isEnableDebugLog, RetryStrategy retryStrategy, HttpLogger httpLogger){
        connectPool.init(isEnableDebugLog);
        QLog.isDebug = isEnableDebugLog;
        this.retryStrategy = retryStrategy;
        this.httpLogger = httpLogger;
    }


    public QuicImpl newQuicImpl(QuicRequest quicRequest){
        QuicImpl quic = new QuicImpl(quicRequest, connectPool);
        return quic;
    }

    public void destroy(){
        connectPool.destroy();
    }

}
