/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.COSXmlSigner;
import com.tencent.qcloud.core.auth.QCloudSigner;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SignerFactory {
    private static final String COS_XML_SIGNER = "CosXmlSigner";
    private static final Map<String, Class<? extends QCloudSigner>> SIGNERS = new ConcurrentHashMap<String, Class<? extends QCloudSigner>>(5);
    private static final Map<String, QCloudSigner> SIGNER_INSTANCES = new ConcurrentHashMap<String, QCloudSigner>(5);

    private SignerFactory() {
    }

    public static void registerSigner(String signerType, Class<? extends QCloudSigner> signerClass) {
        if (signerType == null) {
            throw new IllegalArgumentException("signerType cannot be null");
        }
        if (signerClass == null) {
            throw new IllegalArgumentException("signerClass cannot be null");
        }
        SIGNERS.put(signerType, signerClass);
    }

    public static <T extends QCloudSigner> void registerSigner(String signerType, T signer) {
        if (signerType == null) {
            throw new IllegalArgumentException("signerType cannot be null");
        }
        if (signer == null) {
            throw new IllegalArgumentException("signer instance cannot be null");
        }
        SIGNER_INSTANCES.put(signerType, signer);
    }

    public static QCloudSigner getSigner(String signerType) {
        return SignerFactory.lookupAndCreateSigner(signerType);
    }

    private static QCloudSigner lookupAndCreateSigner(String signerType) {
        if (SIGNER_INSTANCES.containsKey(signerType)) {
            return SIGNER_INSTANCES.get(signerType);
        }
        return SignerFactory.createSigner(signerType);
    }

    private static QCloudSigner createSigner(String signerType) {
        QCloudSigner signer;
        Class<? extends QCloudSigner> signerClass = SIGNERS.get(signerType);
        if (signerClass == null) {
            return null;
        }
        try {
            signer = signerClass.newInstance();
            SIGNER_INSTANCES.put(signerType, signer);
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Cannot create an instance of " + signerClass.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot create an instance of " + signerClass.getName(), ex);
        }
        return signer;
    }

    static {
        SIGNERS.put(COS_XML_SIGNER, COSXmlSigner.class);
    }
}

