/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.content.ContentResolver;
import android.net.Uri;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.http.CountingSink;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.util.QCloudUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class StreamingRequestBody
extends RequestBody
implements ProgressBody {
    private File file;
    private byte[] bytes;
    private InputStream stream;
    private URL url;
    private Uri uri;
    private ContentResolver contentResolver;
    private long offset = 0L;
    private long requiredLength = -1L;
    private long contentRawLength = -1L;
    private String contentType;
    private QCloudProgressListener progressListener;
    private CountingSink countingSink;

    @Override
    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    private StreamingRequestBody() {
    }

    @Override
    public long getBytesTransferred() {
        return this.countingSink != null ? this.countingSink.getTotalTransferred() : 0L;
    }

    static StreamingRequestBody file(File file, String contentType) {
        return StreamingRequestBody.file(file, contentType, 0L, Long.MAX_VALUE);
    }

    static StreamingRequestBody file(File file, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.file = file;
        requestBody.contentType = contentType;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.requiredLength = length;
        return requestBody;
    }

    static StreamingRequestBody bytes(byte[] bytes, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.bytes = bytes;
        requestBody.contentType = contentType;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.requiredLength = length;
        return requestBody;
    }

    static StreamingRequestBody steam(InputStream inputStream, File tmpFile, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.stream = inputStream;
        requestBody.contentType = contentType;
        requestBody.file = tmpFile;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.requiredLength = length;
        return requestBody;
    }

    static StreamingRequestBody url(URL url, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.url = url;
        requestBody.contentType = contentType;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.requiredLength = length;
        return requestBody;
    }

    static StreamingRequestBody uri(Uri uri, ContentResolver contentResolver, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.uri = uri;
        requestBody.contentResolver = contentResolver;
        requestBody.contentType = contentType;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.requiredLength = length;
        return requestBody;
    }

    boolean isLargeData() {
        return this.file != null || this.stream != null;
    }

    public MediaType contentType() {
        if (this.contentType != null) {
            return MediaType.parse((String)this.contentType);
        }
        return null;
    }

    public long contentLength() throws IOException {
        long contentMaxLength = this.getContentRawLength();
        if (contentMaxLength <= 0L) {
            return Math.max(this.requiredLength, -1L);
        }
        if (this.requiredLength <= 0L) {
            return Math.max(contentMaxLength - this.offset, -1L);
        }
        return Math.min(contentMaxLength - this.offset, this.requiredLength);
    }

    private long getContentRawLength() throws IOException {
        if (this.contentRawLength < 0L) {
            if (this.stream != null) {
                this.contentRawLength = this.stream.available();
            } else if (this.file != null) {
                this.contentRawLength = this.file.length();
            } else if (this.bytes != null) {
                this.contentRawLength = this.bytes.length;
            } else if (this.uri != null) {
                this.contentRawLength = QCloudUtils.getUriContentLength(this.uri, this.contentResolver);
            }
        }
        return this.contentRawLength;
    }

    private InputStream getStream() throws IOException {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        if (this.stream != null) {
            try {
                this.saveInputStreamToTmpFile(this.stream, this.file);
            }
            finally {
                Util.closeQuietly((Closeable)this.stream);
                this.stream = null;
                this.offset = 0L;
            }
            return new FileInputStream(this.file);
        }
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.url != null) {
            return this.url.openStream();
        }
        if (this.uri != null) {
            return this.contentResolver.openInputStream(this.uri);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInputStreamToTmpFile(InputStream stream, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int bytesRead;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            long bytesTotal = 0L;
            long bytesLimit = this.contentLength();
            if (bytesLimit < 0L) {
                bytesLimit = Long.MAX_VALUE;
            }
            if (this.offset > 0L) {
                long l = stream.skip(this.offset);
            }
            while (bytesTotal < bytesLimit && (bytesRead = stream.read(buffer)) != -1) {
                fos.write(buffer, 0, (int)Math.min((long)bytesRead, bytesLimit - bytesTotal));
                bytesTotal += (long)bytesRead;
            }
            fos.flush();
        }
        catch (Throwable throwable) {
            Util.closeQuietly(fos);
            throw throwable;
        }
        Util.closeQuietly((Closeable)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        InputStream inputStream = null;
        Source source = null;
        try {
            inputStream = this.getStream();
            if (inputStream != null) {
                if (this.offset > 0L) {
                    long l = inputStream.skip(this.offset);
                }
                source = Okio.source((InputStream)inputStream);
                long contentLength = this.contentLength();
                this.countingSink = new CountingSink((Sink)sink, contentLength, this.progressListener);
                BufferedSink bufferedSink = Okio.buffer((Sink)this.countingSink);
                if (contentLength > 0L) {
                    bufferedSink.write(source, contentLength);
                } else {
                    bufferedSink.writeAll(source);
                }
                bufferedSink.flush();
            }
        }
        finally {
            Util.closeQuietly((Closeable)inputStream);
            Util.closeQuietly(source);
            Util.closeQuietly((Closeable)((Object)this.countingSink));
        }
    }
}

