/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.RetryStrategy;
import com.tencent.qcloud.core.task.TaskManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

class RetryAndTrafficControlInterceptor
implements Interceptor {
    private TrafficStrategy uploadTrafficStrategy = new ModerateTrafficStrategy("UploadStrategy-", 2);
    private TrafficStrategy downloadTrafficStrategy = new AggressiveTrafficStrategy("DownloadStrategy-", 3);
    private RetryStrategy retryStrategy;

    RetryAndTrafficControlInterceptor(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpTask task = (HttpTask)TaskManager.getInstance().get((String)request.tag());
        return this.processRequest(chain, request, task);
    }

    Response processRequest(Interceptor.Chain chain, Request request, HttpTask task) throws IOException {
        Response response = null;
        IOException e = null;
        if (task == null || task.isCanceled()) {
            throw new IOException("CANCELED");
        }
        int attempts = 0;
        long startTime = System.currentTimeMillis();
        TrafficStrategy strategy = this.getSuitableStrategy(task);
        while (attempts < 1 || this.retryStrategy.shouldRetry(attempts, System.currentTimeMillis() - startTime)) {
            long waitTook = 0L;
            if (strategy != null) {
                long before = System.currentTimeMillis();
                strategy.waitForPermit();
                waitTook = System.currentTimeMillis() - before;
            }
            if (attempts > 0) {
                long delay = this.retryStrategy.getNextDelay(attempts);
                try {
                    if (delay > waitTook + 500L) {
                        TimeUnit.MILLISECONDS.sleep(delay - waitTook);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            QCloudLogger.i("QCloudHttp", "%s start to execute, attempts is %d", request, attempts);
            ++attempts;
            long startNs = System.nanoTime();
            int statusCode = -1;
            try {
                response = this.executeTaskOnce(chain, request, task);
                if (task.isDownloadTask()) {
                    task.convertResponse(response);
                }
                e = null;
            }
            catch (IOException exception) {
                e = exception;
            }
            catch (QCloudClientException e1) {
                e = e1.getCause() instanceof IOException ? (IOException)e1.getCause() : new IOException(e1);
            }
            catch (QCloudServiceException e2) {
                e = e2.getCause() instanceof IOException ? (IOException)e2.getCause() : new IOException(e2);
                statusCode = e2.getStatusCode();
            }
            long networkMillsTook = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            if (e == null) {
                if (strategy == null) break;
                strategy.reportSpeed(request, task.getAverageStreamingSpeed(networkMillsTook));
                break;
            }
            if (!this.isUserCancelled(e) && this.isRecoverable(e) && this.isRecoverable(statusCode)) {
                QCloudLogger.i("QCloudHttp", "%s failed for %s", request, e);
                if (strategy == null) continue;
                if (e instanceof SocketTimeoutException) {
                    strategy.reportTimeOut(request);
                    continue;
                }
                strategy.reportException(request, e);
                continue;
            }
            QCloudLogger.i("QCloudHttp", "%s failed for %s, and is not recoverable", request, e);
            if (strategy == null) break;
            strategy.reportException(request, e);
            break;
        }
        if (e != null) {
            QCloudLogger.i("QCloudHttp", "%s ends with error, %s", request, e);
            throw e;
        }
        return response;
    }

    private TrafficStrategy getSuitableStrategy(HttpTask task) {
        return task.isDownloadTask() ? this.downloadTrafficStrategy : (task.isUploadTask() ? this.uploadTrafficStrategy : null);
    }

    private Response executeTaskOnce(Interceptor.Chain chain, Request request, HttpTask task) throws IOException {
        try {
            if (task.isCanceled()) {
                throw new IOException("CANCELED");
            }
            return this.processSingleRequest(chain, request);
        }
        catch (ProtocolException exception) {
            if (exception.getMessage() != null && exception.getMessage().contains("HTTP 204 had non-zero Content-Length: ")) {
                return new Response.Builder().request(request).message(exception.toString()).code(204).protocol(Protocol.HTTP_1_1).build();
            }
            exception.printStackTrace();
            throw exception;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private boolean isUserCancelled(IOException exception) {
        return exception.getMessage() != null && exception.getMessage().toLowerCase().equals("canceled");
    }

    Response processSingleRequest(Interceptor.Chain chain, Request request) throws IOException {
        return chain.proceed(request);
    }

    private boolean isRecoverable(int statusCode) {
        return statusCode != 401 && statusCode != 404;
    }

    private boolean isRecoverable(IOException e) {
        if (e instanceof ProtocolException) {
            return false;
        }
        if (e instanceof InterruptedIOException) {
            return e instanceof SocketTimeoutException;
        }
        if (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException) {
            return false;
        }
        return !(e instanceof SSLPeerUnverifiedException);
    }

    private static class ModerateTrafficStrategy
    extends TrafficStrategy {
        ModerateTrafficStrategy(String name, int maxConcurrent) {
            super(name, 1, maxConcurrent);
        }
    }

    private static class AggressiveTrafficStrategy
    extends TrafficStrategy {
        AggressiveTrafficStrategy(String name, int maxConcurrent) {
            super(name, maxConcurrent, maxConcurrent);
        }
    }

    private static abstract class TrafficStrategy {
        private final int[] historySpeed = new int[5];
        private int current = 0;
        private final int maxConcurrent;
        private final String name;
        static final int MIN_FAST_SPEED = 300;
        static final int MIN_TIMEOUT_COUNT = 2;
        private ResizableSemaphore controller;
        private AtomicInteger concurrent;
        private AtomicInteger historyConsecutiveTimeoutError = new AtomicInteger(0);

        TrafficStrategy(String name, int concurrent, int maxConcurrent) {
            this.name = name;
            this.maxConcurrent = maxConcurrent;
            this.controller = new ResizableSemaphore(concurrent, true);
            this.concurrent = new AtomicInteger(concurrent);
            QCloudLogger.d("QCloudHttp", name + " init concurrent is " + concurrent, new Object[0]);
        }

        void reportException(Request request, IOException exception) {
            this.controller.release();
        }

        void reportTimeOut(Request request) {
            if (this.historyConsecutiveTimeoutError.get() < 0) {
                this.historyConsecutiveTimeoutError.set(1);
            } else {
                this.historyConsecutiveTimeoutError.incrementAndGet();
            }
            if (this.historyConsecutiveTimeoutError.get() >= 2) {
                this.adjustConcurrentAndRelease(1);
            } else {
                this.controller.release();
            }
        }

        synchronized void reportSpeed(Request request, double averageSpeed) {
            this.historyConsecutiveTimeoutError.decrementAndGet();
            if (averageSpeed > 0.0) {
                QCloudLogger.d("QCloudHttp", this.name + " %s streaming speed is %1.3f KBps", request, averageSpeed);
                int average = this.updateAverageSpeed(averageSpeed);
                int concurrent = this.concurrent.get();
                if (average > (concurrent + 1) * 300 && concurrent < this.maxConcurrent) {
                    this.adjustConcurrentAndRelease(concurrent + 1);
                } else if (average > 0 && average < (concurrent - 1) * 300 && concurrent > 1) {
                    this.adjustConcurrentAndRelease(concurrent - 1);
                } else {
                    this.controller.release();
                }
            } else {
                this.controller.release();
            }
        }

        void waitForPermit() {
            try {
                this.controller.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int updateAverageSpeed(double averageSpeed) {
            int[] nArray = this.historySpeed;
            synchronized (this.historySpeed) {
                this.historySpeed[this.current] = (int)Math.floor(averageSpeed);
                this.current = (this.current + 1) % this.historySpeed.length;
                int sum = 0;
                boolean notEnoughData = false;
                for (int speed : this.historySpeed) {
                    if (speed == 0) {
                        notEnoughData = true;
                        break;
                    }
                    sum += speed;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return notEnoughData ? 0 : sum / this.historySpeed.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearAverageSpeed() {
            int[] nArray = this.historySpeed;
            synchronized (this.historySpeed) {
                for (int i = 0; i < this.historySpeed.length; ++i) {
                    this.historySpeed[i] = 0;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private synchronized void adjustConcurrentAndRelease(int expect) {
            int current = this.concurrent.get();
            int delta = expect - current;
            if (delta == 0) {
                this.controller.release();
            } else {
                this.concurrent.set(expect);
                if (delta > 0) {
                    this.controller.release(1 + delta);
                    this.clearAverageSpeed();
                } else {
                    this.controller.reducePermits(delta *= -1);
                    this.controller.release();
                    this.clearAverageSpeed();
                }
                QCloudLogger.i("QCloudHttp", this.name + " adjust concurrent to " + expect, new Object[0]);
            }
        }
    }

    private static class ResizableSemaphore
    extends Semaphore {
        ResizableSemaphore(int permit, boolean fair) {
            super(permit, fair);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

