/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.support.annotation.NonNull;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.http.HttpLoggingInterceptor;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.http.RetryAndTrafficControlInterceptor;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.QCloudTask;
import com.tencent.qcloud.core.task.RetryStrategy;
import com.tencent.qcloud.core.task.TaskManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import okhttp3.Call;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public final class QCloudHttpClient {
    static final String HTTP_LOG_TAG = "QCloudHttp";
    private final OkHttpClient okHttpClient;
    private final TaskManager taskManager;
    private final HttpLoggingInterceptor logInterceptor;
    private final Set<String> verifiedHost;
    private final Map<String, List<InetAddress>> dnsMap;
    private static volatile QCloudHttpClient gDefault;
    private HostnameVerifier mHostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            if (QCloudHttpClient.this.verifiedHost.size() > 0) {
                for (String host : QCloudHttpClient.this.verifiedHost) {
                    if (!HttpsURLConnection.getDefaultHostnameVerifier().verify(host, session)) continue;
                    return true;
                }
            }
            return HttpsURLConnection.getDefaultHostnameVerifier().verify(hostname, session);
        }
    };
    private Dns mDns = new Dns(){

        public List<InetAddress> lookup(String hostname) throws UnknownHostException {
            if (QCloudHttpClient.this.dnsMap.containsKey(hostname)) {
                return (List)QCloudHttpClient.this.dnsMap.get(hostname);
            }
            return Dns.SYSTEM.lookup(hostname);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QCloudHttpClient getDefault() {
        if (gDefault != null) return gDefault;
        Class<QCloudHttpClient> clazz = QCloudHttpClient.class;
        synchronized (QCloudHttpClient.class) {
            if (gDefault != null) return gDefault;
            gDefault = new Builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gDefault;
        }
    }

    public void addVerifiedHost(String hostname) {
        if (hostname != null) {
            this.verifiedHost.add(hostname);
        }
    }

    public void addDnsRecord(@NonNull String hostName, @NonNull String[] ipAddress) throws UnknownHostException {
        if (ipAddress.length > 0) {
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(ipAddress.length);
            for (String ip : ipAddress) {
                addresses.add(InetAddress.getByName(ip));
            }
            this.dnsMap.put(hostName, addresses);
        }
    }

    public void setDebuggable(boolean debuggable) {
        this.logInterceptor.setLevel(debuggable || QCloudLogger.isLoggableOnLogcat(3, HTTP_LOG_TAG) ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
    }

    private QCloudHttpClient(Builder b) {
        this.verifiedHost = new HashSet<String>(5);
        this.dnsMap = new HashMap<String, List<InetAddress>>(3);
        this.taskManager = TaskManager.getInstance();
        this.logInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            @Override
            public void log(String message) {
                QCloudLogger.i(QCloudHttpClient.HTTP_LOG_TAG, message, new Object[0]);
            }
        });
        this.setDebuggable(false);
        this.okHttpClient = b.mBuilder.followRedirects(true).followSslRedirects(true).hostnameVerifier(this.mHostnameVerifier).dns(this.mDns).connectTimeout((long)b.connectionTimeout, TimeUnit.MILLISECONDS).readTimeout((long)b.socketTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)b.socketTimeout, TimeUnit.MILLISECONDS).addInterceptor((Interceptor)this.logInterceptor).addInterceptor((Interceptor)new RetryAndTrafficControlInterceptor(b.retryStrategy)).build();
    }

    public List<HttpTask> getTasksByTag(String tag) {
        ArrayList<HttpTask> tasks = new ArrayList<HttpTask>();
        if (tag == null) {
            return tasks;
        }
        List<QCloudTask> taskManagerSnapshot = this.taskManager.snapshot();
        for (QCloudTask task : taskManagerSnapshot) {
            if (!(task instanceof HttpTask) || !tag.equals(task.getTag())) continue;
            tasks.add((HttpTask)task);
        }
        return tasks;
    }

    public <T> HttpTask<T> resolveRequest(HttpRequest<T> request) {
        return this.handleRequest(request, null);
    }

    public <T> HttpTask<T> resolveRequest(QCloudHttpRequest<T> request, QCloudCredentialProvider credentialProvider) {
        return this.handleRequest(request, credentialProvider);
    }

    Call getOkHttpCall(Request okHttpRequest) {
        return this.okHttpClient.newCall(okHttpRequest);
    }

    private <T> HttpTask<T> handleRequest(HttpRequest<T> request, QCloudCredentialProvider credentialProvider) {
        request.addHeader("Host", request.host());
        return new HttpTask<T>(request, credentialProvider, this);
    }

    public static final class Builder {
        int connectionTimeout = 15000;
        int socketTimeout = 30000;
        RetryStrategy retryStrategy;
        OkHttpClient.Builder mBuilder;

        public Builder setConnectionTimeout(int connectionTimeout) {
            if (connectionTimeout < 10000) {
                throw new IllegalArgumentException("connection timeout must be larger than 10 seconds.");
            }
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            if (socketTimeout < 10000) {
                throw new IllegalArgumentException("socket timeout must be larger than 10 seconds.");
            }
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public Builder setInheritBuilder(OkHttpClient.Builder builder) {
            this.mBuilder = builder;
            return this;
        }

        public QCloudHttpClient build() {
            if (this.retryStrategy == null) {
                this.retryStrategy = RetryStrategy.DEFAULT;
            }
            if (this.mBuilder == null) {
                this.mBuilder = new OkHttpClient.Builder();
            }
            return new QCloudHttpClient(this);
        }
    }
}

