/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResponse;
import java.util.List;
import java.util.Map;

public final class HttpResult<T> {
    private final int code;
    private final String message;
    private final Map<String, List<String>> headers;
    private final HttpRequest<T> request;
    private final T content;

    HttpResult(HttpResponse<T> response, T content) {
        this.code = response.code();
        this.message = response.message();
        this.headers = response.response.headers().toMultimap();
        this.content = content;
        this.request = response.request;
    }

    public T content() {
        return this.content;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public HttpRequest<T> request() {
        return this.request;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public final boolean isSuccessful() {
        return this.code >= 200 && this.code < 300;
    }

    public QCloudServiceException asException() {
        QCloudServiceException exception = new QCloudServiceException(this.message);
        exception.setStatusCode(this.code);
        return exception;
    }

    public String header(String name) {
        List<String> values = this.headers.get(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }
}

