/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpMetric {
    public static final String ATTR_REQUEST_URL = "request_url";
    public static final String ATTR_REQUEST_METHOD = "request_method";
    public static final String ATTR_REQUEST_CONTENT_LENGTH = "request_content_length";
    public static final String ATTR_REQUEST_CONTENT_TYPE = "request_content_type";
    public static final String ATTR_RESPONSE_CONTENT_LENGTH = "response_content_type";
    public static final String ATTR_RESPONSE_CONTENT_TYPE = "response_content_length";
    public static final String ATTR_RESPONSE_STATUS_CODE = "response_status_code";
    public static final String ATTR_HTTP_TOOK_TIME = "http_took_time";
    public static final String ATTR_EXCEPTION = "exception";
    private Map<String, String> mAttributes = new HashMap<String, String>(16);
    private String requestMethod;
    private String requestUrl;
    private int statusCode;
    private Throwable exception;
    private long mStartNs;
    private long mTookTime;

    public String getAttribute(String attribute) {
        return this.mAttributes.get(attribute);
    }

    public Map<String, String> getAttributes() {
        return this.mAttributes;
    }

    public void putAttribute(String attribute, String value) {
        this.mAttributes.put(attribute, value);
    }

    public void removeAttribute(String attribute) {
        this.mAttributes.remove(attribute);
    }

    public void setRequestUrl(String url) {
        this.requestUrl = url;
        this.mAttributes.put(ATTR_REQUEST_URL, url);
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestMethod(String method) {
        this.requestMethod = method;
        this.mAttributes.put(ATTR_REQUEST_METHOD, method);
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setStatusCode(int responseCode) {
        this.statusCode = responseCode;
        this.mAttributes.put(ATTR_RESPONSE_STATUS_CODE, String.valueOf(this.statusCode));
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setRequestPayloadSize(long bytes) {
        this.mAttributes.put(ATTR_REQUEST_CONTENT_LENGTH, String.valueOf(bytes));
    }

    public void setRequestContentType(String contentType) {
        this.mAttributes.put(ATTR_REQUEST_CONTENT_TYPE, contentType);
    }

    public void setResponseContentType(String contentType) {
        this.mAttributes.put(ATTR_RESPONSE_CONTENT_TYPE, contentType);
    }

    public void setResponsePayloadSize(long bytes) {
        this.mAttributes.put(ATTR_RESPONSE_CONTENT_LENGTH, String.valueOf(bytes));
    }

    public void traceException(Throwable e) {
        this.exception = e;
        this.mAttributes.put(ATTR_EXCEPTION, e.toString());
    }

    public Throwable getError() {
        return this.exception;
    }

    public void start() {
        this.mStartNs = System.nanoTime();
    }

    public void stop() {
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.mStartNs);
        this.mAttributes.put(ATTR_HTTP_TOOK_TIME, String.valueOf(tookMs) + "ms");
        this.mTookTime = tookMs;
    }

    public boolean isStoped() {
        return this.mAttributes.containsKey(ATTR_HTTP_TOOK_TIME);
    }

    public String toString() {
        return "--> " + this.requestMethod + ' ' + this.requestUrl + "  (" + this.mTookTime + "ms)\n" + "<-- " + this.statusCode + " Attributes = " + this.mAttributes.toString() + (this.exception == null ? "" : "\n<-- Exception: " + Log.getStackTraceString((Throwable)this.exception));
    }
}

