/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.BasicLifecycleCredentialProvider;
import com.tencent.qcloud.core.auth.BasicQCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.Utils;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.QCloudHttpClient;

public class ShortTimeCredentialProvider
extends BasicLifecycleCredentialProvider {
    private String secretKey;
    private long duration;
    private String secretId;
    protected HttpRequest<String> httpRequest;

    @Deprecated
    public ShortTimeCredentialProvider(String secretId, String secretKey, long keyDuration) {
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.duration = keyDuration;
    }

    public ShortTimeCredentialProvider(HttpRequest<String> httpRequest) {
        this.httpRequest = httpRequest;
    }

    @Override
    protected QCloudLifecycleCredentials fetchNewCredentials() throws QCloudClientException {
        if (this.secretId != null && this.secretKey != null) {
            return this.onGetCredentialFromLocal(this.secretId, this.secretKey);
        }
        if (this.httpRequest != null) {
            try {
                String json = (String)((HttpResult)QCloudHttpClient.getDefault().resolveRequest(this.httpRequest).executeNow()).content();
                return this.onRemoteCredentialReceived(json);
            }
            catch (QCloudServiceException e) {
                throw new QCloudClientException("get session json fails", e);
            }
        }
        return null;
    }

    QCloudLifecycleCredentials onGetCredentialFromLocal(String secretId, String secretKey) throws QCloudClientException {
        long current = System.currentTimeMillis() / 1000L;
        long expired = current + this.duration;
        String keyTime = current + ";" + expired;
        String signKey = this.secretKey2SignKey(secretKey, keyTime);
        return new BasicQCloudCredentials(secretId, signKey, keyTime);
    }

    protected QCloudLifecycleCredentials onRemoteCredentialReceived(String jsonContent) throws QCloudClientException {
        return null;
    }

    private String secretKey2SignKey(String secretKey, String keyTime) {
        byte[] hmacSha1 = Utils.hmacSha1(keyTime, secretKey);
        if (hmacSha1 != null) {
            return new String(Utils.encodeHex(hmacSha1));
        }
        return null;
    }
}

