/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.Utils;

public class SessionQCloudCredentials
implements QCloudLifecycleCredentials {
    private final String secretId;
    private final String signKey;
    private final String keyTime;
    private final String token;

    public SessionQCloudCredentials(String secretId, String secretKey, String token, long expiredTime) {
        this(secretId, secretKey, token, System.currentTimeMillis() / 1000L, expiredTime);
    }

    public SessionQCloudCredentials(String secretId, String secretKey, String token, long beginTime, long expiredTime) {
        if (secretId == null) {
            throw new IllegalArgumentException("secretId cannot be null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("secretKey cannot be null.");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null.");
        }
        if (beginTime >= expiredTime) {
            throw new IllegalArgumentException("beginTime must be larger than expiredTime.");
        }
        this.secretId = secretId;
        this.keyTime = this.getKeyTime(beginTime, expiredTime);
        this.signKey = this.getSignKey(secretKey, this.keyTime);
        this.token = token;
    }

    public SessionQCloudCredentials(String secretId, String secretKey, String token, String keyTime) {
        if (secretId == null) {
            throw new IllegalArgumentException("secretId cannot be null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("secretKey cannot be null.");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null.");
        }
        if (keyTime == null) {
            throw new IllegalArgumentException("keyTime cannot be null.");
        }
        this.secretId = secretId;
        this.keyTime = keyTime;
        this.signKey = this.getSignKey(secretKey, keyTime);
        this.token = token;
    }

    private String getKeyTime(long beginTime, long expiredTime) {
        return Utils.handleTimeAccuracy(beginTime) + ";" + Utils.handleTimeAccuracy(expiredTime);
    }

    private String getSignKey(String secretKey, String keyTime) {
        byte[] hmacSha1 = Utils.hmacSha1(keyTime, secretKey);
        if (hmacSha1 != null) {
            return new String(Utils.encodeHex(hmacSha1));
        }
        return null;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public String getKeyTime() {
        return this.keyTime;
    }

    @Override
    public String getSecretId() {
        return this.secretId;
    }

    @Override
    public String getSignKey() {
        return this.signKey;
    }
}

