/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import android.text.TextUtils;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.common.QCloudClientException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BasicLifecycleCredentialProvider
implements QCloudCredentialProvider {
    private QCloudLifecycleCredentials credentials;
    private ReentrantLock lock = new ReentrantLock();

    @Override
    public final QCloudCredentials getCredentials() throws QCloudClientException {
        if (this.needUpdateSignaturePair()) {
            this.refresh();
        }
        return this.credentials;
    }

    @Override
    public final void refresh() throws QCloudClientException {
        boolean locked = false;
        try {
            locked = this.lock.tryLock(20L, TimeUnit.SECONDS);
            if (!locked) {
                throw new QCloudClientException("lock timeout, no credential for sign");
            }
            this.credentials = this.fetchNewCredentials();
        }
        catch (InterruptedException e) {
            throw new QCloudClientException("interrupt when try to get credential", e);
        }
        finally {
            if (locked) {
                this.lock.unlock();
            }
        }
    }

    public final void invalidate() {
        this.credentials = null;
    }

    protected abstract QCloudLifecycleCredentials fetchNewCredentials() throws QCloudClientException;

    private boolean needUpdateSignaturePair() {
        if (this.credentials == null) {
            return true;
        }
        String keyTime = this.credentials.getKeyTime();
        if (TextUtils.isEmpty((CharSequence)keyTime)) {
            return true;
        }
        String[] times = keyTime.split(";");
        if (times.length != 2) {
            return true;
        }
        String expire = times[1];
        long expireTime = Long.valueOf(expire);
        long currentTime = System.currentTimeMillis() / 1000L;
        return currentTime > expireTime - 60L;
    }
}

