/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.qcloud.core.logger.LogAdapter;

public final class AndroidLogcatAdapter
implements LogAdapter {
    @Override
    public boolean isLoggable(int priority, @Nullable String tag) {
        if (TextUtils.isEmpty((CharSequence)tag) || tag.length() >= 23) {
            return false;
        }
        return Log.isLoggable((String)tag, (int)priority);
    }

    @Override
    public void log(int priority, @NonNull String tag, @NonNull String message, @Nullable Throwable tr) {
        switch (priority) {
            case 2: {
                this.v(tag, message, tr);
                break;
            }
            case 3: {
                this.d(tag, message, tr);
                break;
            }
            case 4: {
                this.i(tag, message, tr);
                break;
            }
            case 5: {
                this.w(tag, message, tr);
                break;
            }
            case 6: {
                this.e(tag, message, tr);
            }
        }
    }

    private int v(String tag, String message, @Nullable Throwable tr) {
        if (tr == null) {
            return Log.v((String)tag, (String)message);
        }
        return Log.v((String)tag, (String)message, (Throwable)tr);
    }

    private int d(String tag, String message, @Nullable Throwable tr) {
        if (tr == null) {
            return Log.d((String)tag, (String)message);
        }
        return Log.d((String)tag, (String)message, (Throwable)tr);
    }

    private int i(String tag, String message, @Nullable Throwable tr) {
        if (tr == null) {
            return Log.i((String)tag, (String)message);
        }
        return Log.i((String)tag, (String)message, (Throwable)tr);
    }

    private int w(String tag, String message, @Nullable Throwable tr) {
        if (tr == null) {
            return Log.w((String)tag, (String)message);
        }
        return Log.w((String)tag, (String)message, (Throwable)tr);
    }

    private int e(String tag, String message, @Nullable Throwable tr) {
        if (tr == null) {
            return Log.e((String)tag, (String)message);
        }
        return Log.e((String)tag, (String)message, (Throwable)tr);
    }
}

