/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.auth.QCloudSignSourceProvider;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.auth.STSCredentialScope;
import com.tencent.qcloud.core.auth.SignerFactory;
import com.tencent.qcloud.core.common.QCloudAuthenticationException;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import com.tencent.qcloud.core.util.QCloudStringUtils;
import java.net.URL;

public class QCloudHttpRequest<T>
extends HttpRequest<T> {
    private final QCloudSignSourceProvider signProvider;
    private final String signerType;
    private final STSCredentialScope[] credentialScope;
    private final boolean signInUrl;

    public QCloudHttpRequest(Builder<T> builder) {
        super(builder);
        this.signerType = ((Builder)builder).signerType;
        this.signProvider = ((Builder)builder).signProvider;
        this.credentialScope = ((Builder)builder).credentialScope;
        this.signInUrl = ((Builder)builder).signInUrl;
    }

    public QCloudSignSourceProvider getSignProvider() {
        return this.signProvider;
    }

    public STSCredentialScope[] getCredentialScope() {
        return this.credentialScope;
    }

    public boolean isSignInUrl() {
        return this.signInUrl;
    }

    @Override
    QCloudSigner getQCloudSigner() throws QCloudClientException {
        QCloudSigner signer = null;
        if (this.signerType != null && this.shouldCalculateAuth() && (signer = SignerFactory.getSigner(this.signerType)) == null) {
            throw new QCloudClientException(new QCloudAuthenticationException("can't get signer for type : " + this.signerType));
        }
        return signer;
    }

    private boolean shouldCalculateAuth() {
        return QCloudStringUtils.isEmpty(this.header("Authorization"));
    }

    public static class Builder<T>
    extends HttpRequest.Builder<T> {
        private QCloudSignSourceProvider signProvider;
        private String signerType;
        private STSCredentialScope[] credentialScope;
        private boolean signInUrl;

        public Builder<T> signer(String signerType, QCloudSignSourceProvider signProvider) {
            this.signerType = signerType;
            this.signProvider = signProvider;
            return this;
        }

        public Builder<T> credentialScope(STSCredentialScope[] credentialScope) {
            this.credentialScope = credentialScope;
            return this;
        }

        public Builder<T> signInUrl(boolean signInUrl) {
            this.signInUrl = signInUrl;
            return this;
        }

        @Override
        public Builder<T> url(URL url) {
            return (Builder)super.url(url);
        }

        @Override
        public Builder<T> scheme(String scheme) {
            return (Builder)super.scheme(scheme);
        }

        @Override
        public Builder<T> path(String path) {
            return (Builder)super.path(path);
        }

        @Override
        public Builder<T> host(String host) {
            return (Builder)super.host(host);
        }

        @Override
        public Builder<T> port(int port) {
            return (Builder)super.port(port);
        }

        @Override
        public Builder<T> method(String method) {
            return (Builder)super.method(method);
        }

        @Override
        public Builder<T> query(String key, String value) {
            return (Builder)super.query(key, value);
        }

        @Override
        public Builder<T> contentMD5() {
            return (Builder)super.contentMD5();
        }

        @Override
        public Builder<T> addHeader(String name, String value) {
            return (Builder)super.addHeader(name, value);
        }

        @Override
        public Builder<T> removeHeader(String name) {
            return (Builder)super.removeHeader(name);
        }

        @Override
        public Builder<T> userAgent(String userAgent) {
            return (Builder)super.userAgent(userAgent);
        }

        @Override
        public Builder<T> setUseCache(boolean cacheEnabled) {
            return (Builder)super.setUseCache(cacheEnabled);
        }

        @Override
        public Builder<T> body(RequestBodySerializer bodySerializer) {
            return (Builder)super.body(bodySerializer);
        }

        @Override
        public Builder<T> tag(Object tag) {
            return (Builder)super.tag(tag);
        }

        @Override
        public Builder<T> converter(ResponseBodyConverter<T> responseBodyConverter) {
            return (Builder)super.converter(responseBodyConverter);
        }

        @Override
        public QCloudHttpRequest<T> build() {
            this.prepareBuild();
            return new QCloudHttpRequest(this);
        }
    }
}

