/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.task;

import androidx.annotation.NonNull;
import com.tencent.qcloud.core.task.UIThreadExecutor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskExecutors {
    public static final ThreadPoolExecutor COMMAND_EXECUTOR = new ThreadPoolExecutor(5, 5, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new TaskThreadFactory("Command-", 8));
    public static final ThreadPoolExecutor UPLOAD_EXECUTOR = new ThreadPoolExecutor(2, 2, 5L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(), new TaskThreadFactory("Upload-", 3));
    public static final ThreadPoolExecutor DOWNLOAD_EXECUTOR = new ThreadPoolExecutor(3, 3, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new TaskThreadFactory("Download-", 3));
    public static final UIThreadExecutor UI_THREAD_EXECUTOR = new UIThreadExecutor();

    static {
        UPLOAD_EXECUTOR.allowCoreThreadTimeOut(true);
        COMMAND_EXECUTOR.allowCoreThreadTimeOut(true);
        DOWNLOAD_EXECUTOR.allowCoreThreadTimeOut(true);
    }

    static final class TaskThreadFactory
    implements ThreadFactory {
        private final AtomicInteger increment = new AtomicInteger(1);
        private final String tag;
        private final int priority;

        TaskThreadFactory(String tag, int priority) {
            this.tag = tag;
            this.priority = priority;
        }

        @Override
        public final Thread newThread(@NonNull Runnable runnable) {
            Thread newThread = new Thread(runnable, "QCloud-" + this.tag + this.increment.getAndIncrement());
            newThread.setDaemon(false);
            newThread.setPriority(this.priority);
            return newThread;
        }
    }
}

