/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger;

import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

class FileLogItem {
    private String tag = null;
    private String msg = null;
    private Throwable throwable = null;
    private int priority = 0;
    private long timestamp;
    private long threadId;
    private String threadName = null;

    public FileLogItem(String tag, int priority, String msg, Throwable t) {
        this.priority = priority;
        this.tag = tag;
        this.msg = msg;
        this.throwable = t;
        this.timestamp = System.currentTimeMillis();
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(FileLogItem.getPriorityString(this.priority)).append("/");
        builder.append(FileLogItem.timeUtils(this.timestamp, "yyyy-MM-dd HH:mm:ss"));
        builder.append("[").append(this.threadName).append(" ").append(this.threadId).append("]");
        builder.append("[").append(this.tag).append("]");
        builder.append("[").append(this.msg).append("]");
        if (this.throwable != null) {
            builder.append(" * Exception :\n").append(Log.getStackTraceString((Throwable)this.throwable));
        }
        builder.append("\n");
        return builder.toString();
    }

    private static String getPriorityString(int priority) {
        switch (priority) {
            case 2: {
                return "VERBOSE";
            }
            case 3: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "WARN";
            }
            case 6: {
                return "ERROR";
            }
        }
        return "UNKNOWN";
    }

    private static String timeUtils(long seconds, String dateFormat) {
        Date dat = new Date(seconds);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(dat);
        SimpleDateFormat format = new SimpleDateFormat(dateFormat, Locale.CHINA);
        return format.format(gc.getTime());
    }

    public long getLength() {
        return (this.msg != null ? this.msg.length() : 0) + 40;
    }
}

