/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http.interceptor;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.HttpUtil;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.TaskManager;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TrafficControlInterceptor
implements Interceptor {
    private TrafficStrategy uploadTrafficStrategy = new ModerateTrafficStrategy("UploadStrategy-", 2);
    private TrafficStrategy downloadTrafficStrategy = new AggressiveTrafficStrategy("DownloadStrategy-", 3);

    private TrafficStrategy getSuitableStrategy(HttpTask task) {
        return task.isDownloadTask() ? this.downloadTrafficStrategy : (task.isUploadTask() ? this.uploadTrafficStrategy : null);
    }

    private double getAverageStreamingSpeed(HttpTask task, long networkMillsTook) {
        if (networkMillsTook == 0L) {
            return 0.0;
        }
        return (double)task.getTransferBodySize() / 1024.0 / ((double)networkMillsTook / 1000.0);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        IOException e;
        Request request = chain.request();
        HttpTask task = (HttpTask)TaskManager.getInstance().get((String)request.tag());
        TrafficStrategy strategy = this.getSuitableStrategy(task);
        if (strategy != null) {
            strategy.waitForPermit();
        }
        QCloudLogger.i("QCloudHttp", " %s begin to execute", request);
        try {
            long startNs = System.nanoTime();
            Response response = this.processRequest(chain, request);
            if (task.isDownloadTask()) {
                task.convertResponse(response);
            }
            if (strategy != null) {
                if (response.isSuccessful()) {
                    long networkMillsTook = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                    strategy.reportSpeed(request, this.getAverageStreamingSpeed(task, networkMillsTook));
                } else {
                    strategy.reportException(request, null);
                }
            }
            return response;
        }
        catch (QCloudClientException e1) {
            e = e1.getCause() instanceof IOException ? (IOException)e1.getCause() : new IOException(e1);
        }
        catch (QCloudServiceException e2) {
            e = e2.getCause() instanceof IOException ? (IOException)e2.getCause() : new IOException(e2);
        }
        catch (IOException exception) {
            e = exception;
        }
        if (strategy != null) {
            if (HttpUtil.isNetworkTimeoutError(e)) {
                strategy.reportTimeOut(request);
            } else {
                strategy.reportException(request, e);
            }
        }
        throw e;
    }

    private Response processRequest(Interceptor.Chain chain, Request request) throws IOException {
        return chain.proceed(request);
    }

    private static class ModerateTrafficStrategy
    extends TrafficStrategy {
        ModerateTrafficStrategy(String name, int maxConcurrent) {
            super(name, 1, maxConcurrent);
        }
    }

    private static class AggressiveTrafficStrategy
    extends TrafficStrategy {
        AggressiveTrafficStrategy(String name, int maxConcurrent) {
            super(name, maxConcurrent, maxConcurrent);
        }
    }

    private static abstract class TrafficStrategy {
        private final int maxConcurrent;
        private final String name;
        static final int SINGLE_THREAD_SAFE_SPEED = 100;
        static final long BOOST_MODE_DURATION = TimeUnit.SECONDS.toNanos(3L);
        private ResizableSemaphore controller;
        private AtomicInteger concurrent;
        private long boostModeExhaustedTime;

        TrafficStrategy(String name, int concurrent, int maxConcurrent) {
            this.name = name;
            this.maxConcurrent = maxConcurrent;
            this.controller = new ResizableSemaphore(concurrent, true);
            this.concurrent = new AtomicInteger(concurrent);
            QCloudLogger.d("QCloudHttp", name + " init concurrent is " + concurrent, new Object[0]);
        }

        void reportException(Request request, IOException exception) {
            this.controller.release();
        }

        void reportTimeOut(Request request) {
            this.adjustConcurrent(1, true);
        }

        void reportSpeed(Request request, double averageSpeed) {
            if (averageSpeed > 0.0) {
                QCloudLogger.d("QCloudHttp", this.name + " %s streaming speed is %1.3f KBps", request, averageSpeed);
                int concurrent = this.concurrent.get();
                if (averageSpeed > 240.0 && concurrent < this.maxConcurrent) {
                    this.boostModeExhaustedTime = System.nanoTime() + BOOST_MODE_DURATION;
                    this.adjustConcurrent(concurrent + 1, true);
                } else if (averageSpeed > 120.0 && this.boostModeExhaustedTime > 0L) {
                    this.boostModeExhaustedTime = System.nanoTime() + BOOST_MODE_DURATION;
                    this.controller.release();
                } else if (averageSpeed > 0.0 && concurrent > 1 && averageSpeed < 70.0) {
                    this.adjustConcurrent(concurrent - 1, true);
                } else {
                    this.controller.release();
                }
            } else {
                this.controller.release();
            }
        }

        void waitForPermit() {
            try {
                if (this.concurrent.get() > 1 && System.nanoTime() > this.boostModeExhaustedTime) {
                    this.adjustConcurrent(1, false);
                }
                this.controller.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private synchronized void adjustConcurrent(int expect, boolean release) {
            int current = this.concurrent.get();
            int delta = expect - current;
            if (delta == 0) {
                if (release) {
                    this.controller.release();
                }
            } else {
                this.concurrent.set(expect);
                if (delta > 0) {
                    if (release) {
                        this.controller.release(1 + delta);
                    }
                } else {
                    this.controller.reducePermits(delta *= -1);
                    if (release) {
                        this.controller.release();
                    }
                }
                QCloudLogger.i("QCloudHttp", this.name + "set concurrent to " + expect, new Object[0]);
            }
        }
    }

    private static class ResizableSemaphore
    extends Semaphore {
        ResizableSemaphore(int permit, boolean fair) {
            super(permit, fair);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

