/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudProgressListener;
import java.io.IOException;
import okio.Buffer;
import okio.ForwardingSink;
import okio.Sink;

class CountingSink
extends ForwardingSink {
    private long bytesWritten = 0L;
    private long bytesTotal = 0L;
    private long recentReportBytes = 0L;
    private QCloudProgressListener progressListener;

    public CountingSink(Sink delegate, long bytesTotal, QCloudProgressListener progressListener) {
        super(delegate);
        this.bytesTotal = bytesTotal;
        this.progressListener = progressListener;
    }

    private void reportProgress() {
        boolean enoughDelta;
        if (this.progressListener == null) {
            return;
        }
        long delta = this.bytesWritten - this.recentReportBytes;
        boolean bl = enoughDelta = delta > 51200L || delta * 10L > this.bytesTotal || this.bytesWritten == this.bytesTotal;
        if (enoughDelta) {
            this.recentReportBytes = this.bytesWritten;
            this.progressListener.onProgress(this.bytesWritten, this.bytesTotal);
        }
    }

    void writeBytesInternal(long byteCount) {
        this.bytesWritten += byteCount;
        this.reportProgress();
    }

    long getTotalTransferred() {
        return this.bytesWritten;
    }

    public void write(Buffer source, long byteCount) throws IOException {
        super.write(source, byteCount);
        this.writeBytesInternal(byteCount);
    }
}

