/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import android.text.TextUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class STSCredentialScope {
    public final String action;
    public final String bucket;
    public final String prefix;
    public final String region;
    static final STSCredentialScope NONE = new STSCredentialScope(null, null, null, null);

    public STSCredentialScope(String action, String bucket, String region, String prefix) {
        this.action = action;
        this.bucket = bucket;
        this.region = region;
        this.prefix = prefix != null && prefix.charAt(0) == '/' ? prefix.substring(1) : prefix;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof STSCredentialScope)) {
            return false;
        }
        STSCredentialScope another = (STSCredentialScope)obj;
        return TextUtils.equals((CharSequence)this.action, (CharSequence)another.action) && TextUtils.equals((CharSequence)this.bucket, (CharSequence)another.bucket) && TextUtils.equals((CharSequence)this.prefix, (CharSequence)another.prefix) && TextUtils.equals((CharSequence)this.region, (CharSequence)another.region);
    }

    public STSCredentialScope[] toArray() {
        return STSCredentialScope.toArray(this);
    }

    public static STSCredentialScope[] toArray(STSCredentialScope ... scopes) {
        return scopes;
    }

    public static String jsonify(STSCredentialScope[] scopes) {
        JSONArray scopeArray = new JSONArray();
        for (STSCredentialScope scope : scopes) {
            try {
                JSONObject scopeObject = new JSONObject();
                scopeObject.put("action", (Object)scope.action);
                scopeObject.put("bucket", (Object)scope.bucket);
                scopeObject.put("prefix", (Object)scope.prefix);
                scopeObject.put("region", (Object)scope.region);
                scopeArray.put((Object)scopeObject);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return scopeArray.toString();
    }
}

