/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import bolts.CancellationTokenSource;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.auth.ScopeLimitCredentialProvider;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudDigistListener;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.http.MultipartStreamRequestBody;
import com.tencent.qcloud.core.http.NetworkClient;
import com.tencent.qcloud.core.http.NetworkProxy;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.http.StreamingRequestBody;
import com.tencent.qcloud.core.task.QCloudTask;
import com.tencent.qcloud.core.task.TaskExecutors;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public final class HttpTask<T>
extends QCloudTask<HttpResult<T>> {
    private static AtomicInteger increments = new AtomicInteger(1);
    protected final HttpRequest<T> httpRequest;
    protected final QCloudCredentialProvider credentialProvider;
    protected HttpResult<T> httpResult;
    protected HttpTaskMetrics metrics;
    private NetworkProxy<T> networkProxy;
    private QCloudProgressListener mProgressListener = new QCloudProgressListener(){

        @Override
        public void onProgress(long complete, long target) {
            HttpTask.this.onProgress(complete, target);
        }
    };

    HttpTask(HttpRequest<T> httpRequest, QCloudCredentialProvider credentialProvider, NetworkClient networkClient) {
        super("HttpTask-" + httpRequest.tag() + "-" + increments.getAndIncrement(), httpRequest.tag());
        this.httpRequest = httpRequest;
        this.credentialProvider = credentialProvider;
        this.networkProxy = networkClient.getNetworkProxy();
        this.networkProxy.identifier = this.getIdentifier();
        this.networkProxy.mProgressListener = this.mProgressListener;
    }

    @Override
    public HttpTask<T> scheduleOn(Executor executor) {
        this.scheduleOn(executor, new CancellationTokenSource());
        return this;
    }

    public HttpTask<T> schedule() {
        if (this.httpRequest.getRequestBody() instanceof ProgressBody) {
            this.scheduleOn(TaskExecutors.UPLOAD_EXECUTOR, new CancellationTokenSource());
        } else if (this.httpRequest.getResponseBodyConverter() instanceof ProgressBody) {
            this.scheduleOn(TaskExecutors.DOWNLOAD_EXECUTOR, new CancellationTokenSource());
        } else {
            this.scheduleOn(TaskExecutors.COMMAND_EXECUTOR, new CancellationTokenSource());
        }
        return this;
    }

    public boolean isSuccessful() {
        return this.httpResult != null && this.httpResult.isSuccessful();
    }

    @Override
    public HttpResult<T> getResult() {
        return this.httpResult;
    }

    public HttpTask<T> attachMetric(HttpTaskMetrics httpMetric) {
        this.metrics = httpMetric;
        return this;
    }

    boolean isUploadTask() {
        if (this.httpRequest.getRequestBody() instanceof StreamingRequestBody) {
            return ((StreamingRequestBody)this.httpRequest.getRequestBody()).isLargeData();
        }
        return false;
    }

    boolean isDownloadTask() {
        return this.httpRequest.getResponseBodyConverter() instanceof ProgressBody;
    }

    double getAverageStreamingSpeed(long networkMillsTook) {
        ProgressBody body = null;
        if (this.httpRequest.getRequestBody() instanceof ProgressBody) {
            body = (ProgressBody)this.httpRequest.getRequestBody();
        } else if (this.httpRequest.getResponseBodyConverter() instanceof ProgressBody) {
            body = (ProgressBody)((Object)this.httpRequest.getResponseBodyConverter());
        }
        if (body != null) {
            return (double)body.getBytesTransferred() / 1024.0 / ((double)networkMillsTook / 1000.0);
        }
        return 0.0;
    }

    @Override
    public void cancel() {
        this.networkProxy.cancel();
        super.cancel();
    }

    @Override
    protected HttpResult<T> execute() throws QCloudClientException, QCloudServiceException {
        Object multipartStreamRequestBody;
        QCloudSigner signer;
        if (this.metrics == null) {
            this.metrics = new HttpTaskMetrics();
        }
        this.networkProxy.metrics = this.metrics;
        this.metrics.onTaskStart();
        if (this.httpRequest.shouldCalculateContentMD5()) {
            this.metrics.onCalculateMD5Start();
            this.calculateContentMD5();
            this.metrics.onCalculateMD5End();
        }
        if ((signer = this.httpRequest.getQCloudSigner()) != null) {
            this.metrics.onSignRequestStart();
            this.signRequest(signer, (QCloudHttpRequest)this.httpRequest);
            this.metrics.onSignRequestEnd();
        }
        if (this.httpRequest.getRequestBody() instanceof ProgressBody) {
            ((ProgressBody)this.httpRequest.getRequestBody()).setProgressListener(this.mProgressListener);
        }
        if (this.httpRequest.getRequestBody() instanceof MultipartStreamRequestBody) {
            multipartStreamRequestBody = (MultipartStreamRequestBody)this.httpRequest.getRequestBody();
            ((MultipartStreamRequestBody)multipartStreamRequestBody).build();
        }
        try {
            this.httpResult = this.networkProxy.executeHttpRequest(this.httpRequest);
            multipartStreamRequestBody = this.httpResult;
            return multipartStreamRequestBody;
        }
        catch (QCloudServiceException serviceException) {
            if (this.isClockSkewedError(serviceException)) {
                if (signer != null) {
                    this.metrics.onSignRequestStart();
                    this.signRequest(signer, (QCloudHttpRequest)this.httpRequest);
                    this.metrics.onSignRequestEnd();
                }
                HttpResult<T> httpResult = this.httpResult = this.networkProxy.executeHttpRequest(this.httpRequest);
                return httpResult;
            }
            throw serviceException;
        }
        finally {
            this.metrics.onTaskEnd();
        }
    }

    private boolean isClockSkewedError(QCloudServiceException serviceException) {
        return "RequestIsExpired".equals(serviceException.getErrorCode()) || "RequestTimeTooSkewed".equals(serviceException.getErrorCode());
    }

    private void signRequest(QCloudSigner signer, QCloudHttpRequest request) throws QCloudClientException {
        if (this.credentialProvider == null) {
            throw new QCloudClientException("no credentials provider");
        }
        QCloudCredentials credentials = this.credentialProvider instanceof ScopeLimitCredentialProvider ? ((ScopeLimitCredentialProvider)this.credentialProvider).getCredentials(request.getCredentialScope()) : this.credentialProvider.getCredentials();
        signer.sign(request, credentials);
    }

    private void calculateContentMD5() throws QCloudClientException {
        RequestBody requestBody = this.httpRequest.getRequestBody();
        if (requestBody == null) {
            throw new QCloudClientException("get md5 canceled, request body is null.");
        }
        if (requestBody instanceof QCloudDigistListener) {
            try {
                if (this.httpRequest.getRequestBody() instanceof MultipartStreamRequestBody) {
                    ((MultipartStreamRequestBody)this.httpRequest.getRequestBody()).addMd5();
                }
                this.httpRequest.addHeader("Content-MD5", ((QCloudDigistListener)requestBody).onGetMd5());
            }
            catch (IOException e) {
                throw new QCloudClientException("calculate md5 error", e);
            }
        } else {
            Buffer sink = new Buffer();
            try {
                requestBody.writeTo((BufferedSink)sink);
            }
            catch (IOException e) {
                throw new QCloudClientException("calculate md5 error", e);
            }
            String md5 = sink.md5().base64();
            this.httpRequest.addHeader("Content-MD5", md5);
            sink.close();
        }
    }

    void convertResponse(Response response) throws QCloudClientException, QCloudServiceException {
        this.httpResult = this.networkProxy.convertResponse(this.httpRequest, response);
    }
}

