/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.task;

import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TaskManager {
    static final String TASK_LOG_TAG = "QCloudTask";
    private Map<String, Task> taskPool = new ConcurrentHashMap<String, Task>(30);
    private static volatile TaskManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskManager getInstance() {
        if (instance != null) return instance;
        Class<TaskManager> clazz = TaskManager.class;
        synchronized (TaskManager.class) {
            if (instance != null) return instance;
            instance = new TaskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TaskManager() {
    }

    void add(Task task) {
        this.taskPool.put(task.getIdentifier(), task);
        QCloudLogger.d(TASK_LOG_TAG, "[Pool] ADD %s, %d cached", task.getIdentifier(), this.taskPool.size());
    }

    void remove(Task task) {
        if (this.taskPool.remove(task.getIdentifier()) != null) {
            QCloudLogger.d(TASK_LOG_TAG, "[Pool] REMOVE %s, %d cached", task.getIdentifier(), this.taskPool.size());
        }
    }

    public Task get(String identifier) {
        return this.taskPool.get(identifier);
    }

    public List<Task> snapshot() {
        return new ArrayList<Task>(this.taskPool.values());
    }

    void evict() {
        QCloudLogger.d(TASK_LOG_TAG, "[Pool] CLEAR %d", this.taskPool.size());
        this.taskPool.clear();
    }
}

