/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.task;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.TaskExecutors;
import com.tencent.qcloud.core.task.TaskManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class Task<T>
implements Runnable {
    private final String identifier;
    private final Object tag;
    protected boolean executed;
    protected boolean completed;
    private boolean closed;
    protected T mResult;
    protected QCloudClientException clientException;
    protected QCloudServiceException serviceException;
    protected TaskManager taskManager;
    private Executor observerExecutor;
    protected ThreadPoolExecutor workerExecutor;
    protected Set<QCloudResultListener<T>> mResultListeners = new HashSet<QCloudResultListener<T>>(2);
    protected Set<QCloudProgressListener> mProgressListeners = new HashSet<QCloudProgressListener>(2);

    Task(String identifier, Object tag) {
        this.identifier = identifier;
        this.tag = tag;
        this.taskManager = TaskManager.getInstance();
    }

    protected void scheduleOn(ThreadPoolExecutor executor) {
        this.taskManager.add(this);
        this.workerExecutor = executor;
        TaskExecutors.schedule(executor, this);
    }

    public final Task<T> observeOn(Executor executor) {
        this.observerExecutor = executor;
        return this;
    }

    public final T executeNow() throws QCloudClientException, QCloudServiceException {
        this.executeNowSilently();
        if (this.clientException != null) {
            throw this.clientException;
        }
        if (this.serviceException != null) {
            throw this.serviceException;
        }
        return this.mResult;
    }

    public final void executeNowSilently() {
        this.taskManager.add(this);
        this.run();
    }

    public final Task<T> addResultListener(QCloudResultListener<T> resultListener) {
        if (resultListener != null) {
            this.mResultListeners.add(resultListener);
        }
        return this;
    }

    public final Task<T> addResultListeners(List<QCloudResultListener<T>> resultListeners) {
        if (resultListeners != null) {
            this.mResultListeners.addAll(resultListeners);
        }
        return this;
    }

    public final Task<T> removeResultListener(QCloudResultListener<T> resultListener) {
        if (resultListener != null) {
            this.mResultListeners.remove(resultListener);
        }
        return this;
    }

    public final void removeAllListeners() {
        this.mResultListeners.clear();
        this.mProgressListeners.clear();
    }

    public final List<QCloudResultListener<T>> getAllResultListeners() {
        return new ArrayList<QCloudResultListener<T>>(this.mResultListeners);
    }

    public final List<QCloudProgressListener> getAllProgressListeners() {
        return new ArrayList<QCloudProgressListener>(this.mProgressListeners);
    }

    public final Task<T> addProgressListener(QCloudProgressListener progressListener) {
        if (progressListener != null) {
            this.mProgressListeners.add(progressListener);
        }
        return this;
    }

    public final Task<T> addProgressListeners(List<QCloudProgressListener> progressListeners) {
        if (progressListeners != null) {
            this.mProgressListeners.addAll(progressListeners);
        }
        return this;
    }

    public final Task<T> removeProgressListener(QCloudProgressListener progressListener) {
        if (progressListener != null) {
            this.mProgressListeners.remove(progressListener);
        }
        return this;
    }

    public T getResult() {
        return this.mResult;
    }

    public Exception getException() {
        return this.clientException != null ? this.clientException : this.serviceException;
    }

    protected void onSuccess() {
        if (this.mResultListeners.size() > 0) {
            this.executeListener(new Runnable(){

                @Override
                public void run() {
                    ArrayList listeners = new ArrayList(Task.this.mResultListeners);
                    for (QCloudResultListener qCloudResultListener : listeners) {
                        qCloudResultListener.onSuccess(Task.this.mResult);
                    }
                }
            });
        }
    }

    protected void onFailure() {
        if (this.mResultListeners.size() > 0) {
            this.executeListener(new Runnable(){

                @Override
                public void run() {
                    ArrayList listeners = new ArrayList(Task.this.mResultListeners);
                    for (QCloudResultListener qCloudResultListener : listeners) {
                        qCloudResultListener.onFailure(Task.this.clientException, Task.this.serviceException);
                    }
                }
            });
        }
    }

    protected void onProgress(final long complete, final long target) {
        if (this.mProgressListeners.size() > 0) {
            this.executeListener(new Runnable(){

                @Override
                public void run() {
                    ArrayList<QCloudProgressListener> listeners = new ArrayList<QCloudProgressListener>(Task.this.mProgressListeners);
                    for (QCloudProgressListener progressListener : listeners) {
                        progressListener.onProgress(complete, target);
                    }
                }
            });
        }
    }

    private void executeListener(Runnable callback) {
        if (this.observerExecutor != null) {
            this.observerExecutor.execute(callback);
        } else {
            callback.run();
        }
    }

    protected synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.taskManager.remove(this);
        }
    }

    protected synchronized void onExecute() {
        QCloudLogger.d("QCloudTask", "[Task] %s start execute", this.getIdentifier());
        this.executed = true;
    }

    protected synchronized void onComplete() {
        QCloudLogger.d("QCloudTask", "[Task] %s complete", this.getIdentifier());
        this.close();
        this.completed = true;
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public final Object getTag() {
        return this.tag;
    }

    public final synchronized boolean isExecuted() {
        return this.executed;
    }

    public final synchronized boolean isCompleted() {
        return this.completed;
    }

    protected abstract T onCommand() throws QCloudClientException, QCloudServiceException;

    @Override
    public void run() {
        this.onExecute();
        try {
            this.mResult = this.onCommand();
            this.onSuccess();
        }
        catch (QCloudClientException e) {
            e.printStackTrace();
            this.clientException = e;
            this.onFailure();
        }
        catch (QCloudServiceException e) {
            e.printStackTrace();
            this.serviceException = e;
            this.onFailure();
        }
        this.onComplete();
    }
}

