/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.http.CountingSink;
import com.tencent.qcloud.core.http.ProgressBody;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

class StreamingRequestBody
extends RequestBody
implements ProgressBody {
    private File file;
    private byte[] bytes;
    private InputStream stream;
    private long offset = 0L;
    private long length = 0L;
    private String contentType;
    private QCloudProgressListener progressListener;
    private CountingSink countingSink;

    @Override
    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    private StreamingRequestBody() {
    }

    @Override
    public long getBytesTransferred() {
        return this.countingSink != null ? this.countingSink.getTotalTransferred() : 0L;
    }

    static StreamingRequestBody file(File file, String contentType) {
        return StreamingRequestBody.file(file, contentType, 0L, Long.MAX_VALUE);
    }

    static StreamingRequestBody file(File file, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.file = file;
        requestBody.contentType = contentType;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.length = length < 1L ? Long.MAX_VALUE : length;
        return requestBody;
    }

    static StreamingRequestBody bytes(byte[] bytes, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.bytes = bytes;
        requestBody.contentType = contentType;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.length = length < 1L ? Long.MAX_VALUE : length;
        return requestBody;
    }

    static StreamingRequestBody steam(InputStream inputStream, File tmpFile, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.stream = inputStream;
        requestBody.contentType = contentType;
        requestBody.file = tmpFile;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.length = length < 1L ? Long.MAX_VALUE : length;
        return requestBody;
    }

    public MediaType contentType() {
        if (this.contentType != null) {
            return MediaType.parse((String)this.contentType);
        }
        return null;
    }

    public long contentLength() throws IOException {
        if (this.stream != null) {
            return Math.min((long)this.stream.available() - this.offset, this.length);
        }
        if (this.file != null) {
            return Math.min(this.file.length() - this.offset, this.length);
        }
        return Math.min((long)this.bytes.length - this.offset, this.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getStream() throws IOException {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        if (this.stream != null) {
            FileInputStream fileInputStream;
            FileOutputStream fos = null;
            try {
                int bytesRead;
                fos = new FileOutputStream(this.file);
                byte[] buffer = new byte[8192];
                while ((bytesRead = this.stream.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
                fos.flush();
                fileInputStream = new FileInputStream(this.file);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(fos);
                Util.closeQuietly((Closeable)this.stream);
                this.stream = null;
                throw throwable;
            }
            Util.closeQuietly((Closeable)fos);
            Util.closeQuietly((Closeable)this.stream);
            this.stream = null;
            return fileInputStream;
        }
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        InputStream inputStream = null;
        Source source = null;
        try {
            inputStream = this.getStream();
            if (this.offset > 0L) {
                long l = inputStream.skip(this.offset);
            }
            source = Okio.source((InputStream)inputStream);
            long contentLength = this.contentLength();
            this.countingSink = new CountingSink((Sink)sink, contentLength, this.progressListener);
            BufferedSink bufferedSink = Okio.buffer((Sink)this.countingSink);
            bufferedSink.write(source, contentLength);
            bufferedSink.flush();
        }
        catch (Throwable throwable) {
            Util.closeQuietly((Closeable)inputStream);
            Util.closeQuietly(source);
            Util.closeQuietly((Closeable)((Object)this.countingSink));
            throw throwable;
        }
        Util.closeQuietly((Closeable)inputStream);
        Util.closeQuietly((Closeable)source);
        Util.closeQuietly((Closeable)((Object)this.countingSink));
    }
}

