/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.CountingSink;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import com.tencent.qcloud.core.util.QCloudHttpUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class ResponseFileConverter<T>
extends ResponseBodyConverter<T>
implements ProgressBody {
    private String filePath;
    private long offset;
    private QCloudProgressListener progressListener;
    private CountingSink countingSink;

    public ResponseFileConverter(String filePath, long offset) {
        this.filePath = filePath;
        this.offset = offset;
    }

    @Override
    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    @Override
    public T convert(HttpResponse<T> response) throws QCloudClientException, QCloudServiceException {
        HttpResponse.checkResponseSuccessful(response);
        String contentRangeString = response.header("Content-Range");
        long[] contentRange = QCloudHttpUtils.parseContentRange(contentRangeString);
        long contentLength = contentRange != null ? contentRange[1] - contentRange[0] + 1L : response.contentLength();
        File downloadFilePath = new File(this.filePath);
        File parentDir = downloadFilePath.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new QCloudClientException("local file directory can not create.");
        }
        BufferedSink sink = null;
        try {
            if (this.offset <= 0L) {
                this.countingSink = new CountingSink(Okio.sink((File)downloadFilePath), contentLength, this.progressListener);
                sink = Okio.buffer((Sink)this.countingSink);
                sink.write((Source)response.response.body().source(), contentLength);
                sink.flush();
            } else {
                this.writeRandomAccessFile(downloadFilePath, response.byteStream(), contentLength);
            }
            T t = null;
            return t;
        }
        catch (IOException e) {
            throw new QCloudClientException("write local file error for " + e.toString(), e);
        }
        finally {
            Util.closeQuietly(sink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRandomAccessFile(File downloadFilePath, InputStream inputStream, long contentLength) throws IOException, QCloudClientException {
        if (inputStream == null) {
            throw new QCloudClientException("response body stream is null");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            int len;
            randomAccessFile = new RandomAccessFile(downloadFilePath, "rws");
            randomAccessFile.seek(this.offset);
            byte[] buffer = new byte[8192];
            this.countingSink = new CountingSink((Sink)new Buffer(), contentLength, this.progressListener);
            while ((len = inputStream.read(buffer)) != -1) {
                randomAccessFile.write(buffer, 0, len);
                this.countingSink.writeBytesInternal(len);
            }
        }
        finally {
            Util.closeQuietly((Closeable)inputStream);
            Util.closeQuietly((Closeable)randomAccessFile);
        }
    }

    @Override
    public long getBytesTransferred() {
        return this.countingSink != null ? this.countingSink.getTotalTransferred() : 0L;
    }
}

