/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.content.Context;
import com.tencent.qcloud.core.http.MimeType;
import com.tencent.qcloud.core.http.StreamingRequestBody;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okio.ByteString;

public abstract class RequestBodySerializer {
    abstract RequestBody body();

    public static RequestBodySerializer string(String contentType, String content) {
        return new BaseRequestBodyWrapper(RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)content));
    }

    public static RequestBodySerializer string(String contentType, ByteString content) {
        return new BaseRequestBodyWrapper(RequestBody.create((MediaType)MediaType.parse((String)contentType), (ByteString)content));
    }

    public static RequestBodySerializer bytes(String contentType, byte[] content) {
        return RequestBodySerializer.bytes(contentType, content, 0L, -1L);
    }

    public static RequestBodySerializer bytes(String contentType, byte[] content, long offset, long byteCount) {
        StreamingRequestBody requestBody = StreamingRequestBody.bytes(content, contentType, offset, byteCount);
        return new BaseRequestBodyWrapper(requestBody);
    }

    public static RequestBodySerializer file(String contentType, File file) {
        return RequestBodySerializer.file(contentType, file, 0L, -1L);
    }

    public static RequestBodySerializer file(String contentType, File file, long offset, long length) {
        StreamingRequestBody fileRequestBody = StreamingRequestBody.file(file, contentType, offset, length);
        return new BaseRequestBodyWrapper(fileRequestBody);
    }

    public static RequestBodySerializer stream(String contentType, Context context, InputStream inputStream) {
        return RequestBodySerializer.stream(contentType, context, inputStream, 0L, -1L);
    }

    public static RequestBodySerializer stream(String contentType, Context context, InputStream inputStream, long offset, long length) {
        File tmpFile = new File(context.getExternalCacheDir(), "inputStream_tmp");
        return RequestBodySerializer.stream(contentType, tmpFile, inputStream, offset, length);
    }

    public static RequestBodySerializer stream(String contentType, File tmpFile, InputStream inputStream) {
        return RequestBodySerializer.stream(contentType, tmpFile, inputStream, 0L, -1L);
    }

    public static RequestBodySerializer stream(String contentType, File tmpFile, InputStream inputStream, long offset, long length) {
        StreamingRequestBody requestBody = StreamingRequestBody.steam(inputStream, tmpFile, contentType, offset, length);
        return new BaseRequestBodyWrapper(requestBody);
    }

    public static RequestBodySerializer multipart(Map<String, String> keyValues, Map<String, String> uploadFiles) {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MediaType.parse((String)"multipart/form-data"));
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            bodyBuilder.addFormDataPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : uploadFiles.entrySet()) {
            String path = entry.getKey();
            String type = entry.getValue();
            File file = new File(path);
            StreamingRequestBody fileRequestBody = StreamingRequestBody.file(file, MimeType.getTypeByFileName(file.getName()));
            bodyBuilder.addFormDataPart(type, file.getName(), (RequestBody)fileRequestBody);
        }
        return new BaseRequestBodyWrapper((RequestBody)bodyBuilder.build());
    }

    private static final class BaseRequestBodyWrapper
    extends RequestBodySerializer {
        private final RequestBody body;

        public BaseRequestBodyWrapper(RequestBody body) {
            this.body = body;
        }

        @Override
        RequestBody body() {
            return this.body;
        }
    }
}

