/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.Utils;

public class SessionQCloudCredentials
implements QCloudLifecycleCredentials {
    private final String secretId;
    private final String signKey;
    private final String keyTime;
    private final String token;

    public SessionQCloudCredentials(String secretId, String secretKey, String token, long expire) {
        if (secretId == null) {
            throw new IllegalArgumentException("secretId cannot be null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("secretKey cannot be null.");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null.");
        }
        if (expire <= 0L) {
            throw new IllegalArgumentException("expire time must be positive");
        }
        this.secretId = secretId;
        this.keyTime = this.getKeyTime(expire);
        this.signKey = this.getSignKey(secretKey, this.keyTime);
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    private String getKeyTime(long expired) {
        long currentTime = System.currentTimeMillis() / 1000L;
        return currentTime + ";" + expired;
    }

    private String getSignKey(String secretKey, String keyTime) {
        byte[] hmacSha1 = Utils.hmacSha1(keyTime, secretKey);
        if (hmacSha1 != null) {
            return new String(Utils.encodeHex(hmacSha1));
        }
        return null;
    }

    @Override
    public String getKeyTime() {
        return this.keyTime;
    }

    @Override
    public String getSecretId() {
        return this.secretId;
    }

    @Override
    public String getSignKey() {
        return this.signKey;
    }
}

