/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import android.util.Base64;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.auth.ShortTimeCredentialProvider;
import com.tencent.qcloud.core.auth.Utils;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionCredentialProvider
extends ShortTimeCredentialProvider {
    private String secretId;
    private String secretKey;
    private String appid;
    private String userAgent;
    private String region;

    @Deprecated
    public SessionCredentialProvider(String secretId, String secretKey, String appid, String region, String userAgent) {
        super(secretId, secretKey, 0L);
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.appid = appid;
        this.userAgent = userAgent;
        this.region = region;
    }

    public SessionCredentialProvider(HttpRequest<String> httpRequest) {
        super(httpRequest);
    }

    @Override
    QCloudLifecycleCredentials onGetCredentialFromLocal(String secretId, String secretKey) throws QCloudClientException {
        try {
            this.httpRequest = this.getRequestByKey();
            String json = (String)((HttpResult)QCloudHttpClient.getDefault().resolveRequest(this.httpRequest).executeNow()).content();
            return this.onRemoteCredentialReceived(json);
        }
        catch (QCloudServiceException e) {
            throw new QCloudClientException("get session json fails", e);
        }
    }

    @Override
    protected QCloudLifecycleCredentials onRemoteCredentialReceived(String jsonContent) throws QCloudClientException {
        if (jsonContent != null) {
            try {
                JSONObject jsonObject = new JSONObject(jsonContent);
                JSONObject data = jsonObject.optJSONObject("data");
                if (data == null) {
                    data = jsonObject;
                }
                JSONObject credentials = data.optJSONObject("credentials");
                long expiredTime = data.optLong("expiredTime");
                if (credentials != null) {
                    String sessionToken = credentials.optString("sessionToken");
                    String tmpSecretId = credentials.optString("tmpSecretId");
                    String tmpSecretKey = credentials.optString("tmpSecretKey");
                    return new SessionQCloudCredentials(tmpSecretId, tmpSecretKey, sessionToken, expiredTime);
                }
            }
            catch (JSONException e) {
                throw new QCloudClientException("parse session json fails", e);
            }
        }
        return null;
    }

    private HttpRequest<String> getRequestByKey() {
        String requestHost = "sts.api.qcloud.com";
        String requestPath = "/v2/index.php";
        String requestMethod = "GET";
        TreeMap<String, String> params = new TreeMap<String, String>();
        String policy = String.format("{\"statement\": [{\"action\": [\"name/cos:*\"],\"effect\": \"allow\",\"resource\":[\"qcs::cos:%s:uid/%s:prefix//%s/*\"]}],\"version\": \"2.0\"}", this.region, this.appid, this.appid);
        params.put("policy", policy);
        params.put("name", "Rabbitliu");
        params.put("Action", "GetFederationToken");
        params.put("SecretId", this.secretId);
        params.put("Nonce", "" + new Random().nextInt(Integer.MAX_VALUE));
        params.put("Timestamp", "" + System.currentTimeMillis() / 1000L);
        params.put("RequestClient", this.userAgent);
        String plainText = this.makeSignPlainText(params, requestMethod, requestHost, requestPath);
        byte[] hmacSha1 = Utils.hmacSha1(plainText, this.secretKey);
        if (hmacSha1 != null) {
            params.put("Signature", Base64.encodeToString((byte[])hmacSha1, (int)0));
        }
        return new HttpRequest.Builder().scheme("https").host(requestHost).path(requestPath).method(requestMethod).query(params).build();
    }

    private String makeSignPlainText(Map<String, String> requestParams, String requestMethod, String requestHost, String requestPath) {
        String retStr = "";
        retStr = retStr + requestMethod;
        retStr = retStr + requestHost;
        retStr = retStr + requestPath;
        retStr = retStr + this.buildParamStr(requestParams);
        return retStr;
    }

    private String buildParamStr(Map<String, String> requestParams) {
        StringBuilder retStr = new StringBuilder();
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            if (retStr.length() == 0) {
                retStr.append('?');
            } else {
                retStr.append('&');
            }
            retStr.append(entry.getKey().replace("_", ".")).append('=').append(entry.getValue().toString());
        }
        return retStr.toString();
    }
}

