/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.mtaUtils;

import android.content.Context;
import android.util.Log;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatReportStrategy;
import com.tencent.stat.StatServiceImpl;
import com.tencent.stat.StatSpecifyReportedInfo;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class MTAServer {
    private static final String TAG = "MTAServer";
    private String mtaAppKey = "Aqcloud105115";
    private String sendEventId = "request_sent";
    private String failEventId = "request_fail";
    private String errorParameterName = "error";
    private String classParameterName = "class_name";
    private String sdkVersion = "1.0";
    private String sdkChannel = "COS-ANDROID-SDK";
    private Context applicationContext;
    private ThreadLocal<DateFormat> dateFormatThreadLocal = new ThreadLocal();
    private String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private StatSpecifyReportedInfo sdkReportInfo;

    public String fmtTime(long secondMillis) {
        DateFormat dateFormat = this.dateFormatThreadLocal.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(this.TIME_FORMAT, Locale.ENGLISH);
            this.dateFormatThreadLocal.set(dateFormat);
        }
        return dateFormat.format(new Date(secondMillis));
    }

    public MTAServer(Context applicationContext, String sdkVersion) {
        this.applicationContext = applicationContext;
        this.sdkVersion = sdkVersion;
        this.sdkReportInfo = new StatSpecifyReportedInfo();
        this.sdkReportInfo.setAppKey(this.mtaAppKey);
        this.sdkReportInfo.setInstallChannel(this.sdkChannel);
        this.sdkReportInfo.setVersion(this.sdkVersion);
        this.sdkReportInfo.setSendImmediately(true);
        StatConfig.setMaxBatchReportCount((int)10);
        StatConfig.setStatSendStrategy((StatReportStrategy)StatReportStrategy.BATCH);
        Log.d((String)TAG, (String)"MTAServer instance success");
    }

    public void reportFailedEvent(String className, String errorMsg) {
        if (className != null && errorMsg != null) {
            Properties properties = new Properties();
            properties.setProperty(this.classParameterName, className);
            properties.setProperty(this.errorParameterName, errorMsg);
            StatServiceImpl.trackCustomKVEvent((Context)this.applicationContext, (String)this.failEventId, (Properties)properties, (StatSpecifyReportedInfo)this.sdkReportInfo);
            Log.d((String)TAG, (String)(className + ": " + errorMsg));
        }
    }

    public void reportSendEvent(String className) {
        if (className != null) {
            Properties properties = new Properties();
            properties.setProperty(this.classParameterName, className);
            StatServiceImpl.trackCustomKVEvent((Context)this.applicationContext, (String)this.sendEventId, (Properties)properties, (StatSpecifyReportedInfo)this.sdkReportInfo);
            Log.d((String)TAG, (String)(className + ": " + className));
        }
    }
}

