/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mid.util;

import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Base64;
import android.util.Log;
import com.tencent.mid.api.MidEntity;
import com.tencent.mid.api.MidProvider;
import com.tencent.mid.api.MidService;
import com.tencent.mid.util.b;
import com.tencent.mid.util.f;
import com.tencent.mid.util.g;
import com.tencent.mid.util.o;
import com.tencent.mid.util.p;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpHost;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Util {
    private static f a = null;
    public static int errorCount = 0;
    private static Random b = null;
    public static Map<String, MidEntity> lastOtherMidMap = null;
    public static long lastGetOtherMidMapTime = 0L;

    public static synchronized f getLogger() {
        if (a == null) {
            a = new f("MID");
        }
        return a;
    }

    public static boolean isStringValid(String string) {
        return string != null && string.trim().length() != 0;
    }

    public static boolean isMidValid(MidEntity midEntity) {
        return midEntity != null && Util.isMidValid(midEntity.getMid());
    }

    public static boolean isMidValid(String string) {
        return string != null && string.trim().length() >= 40;
    }

    public static MidEntity getNewerMidEntity(MidEntity midEntity, MidEntity midEntity2) {
        if (midEntity != null && midEntity2 != null) {
            return midEntity.compairTo(midEntity2) >= 0 ? midEntity : midEntity2;
        }
        if (midEntity != null) {
            return midEntity;
        }
        if (midEntity2 != null) {
            return midEntity2;
        }
        return null;
    }

    public static boolean equal(MidEntity midEntity, MidEntity midEntity2) {
        if (midEntity != null && midEntity2 != null) {
            return midEntity.compairTo(midEntity2) == 0;
        }
        return midEntity == null && midEntity2 == null;
    }

    public static boolean checkPermission(Context context, String string) {
        boolean bl = false;
        try {
            PackageManager packageManager = context.getPackageManager();
            bl = packageManager.checkPermission(string, context.getPackageName()) == 0;
        }
        catch (Throwable throwable) {
            Log.e((String)"MID", (String)"checkPermission error", (Throwable)throwable);
        }
        return bl;
    }

    public static boolean isWifiNet(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getTypeName() != null && networkInfo.getTypeName().equalsIgnoreCase("WIFI");
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            NetworkInfo networkInfo;
            if (!Util.checkPermission(context, "android.permission.INTERNET")) {
                return false;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null) {
                if (networkInfo.isConnectedOrConnecting()) {
                    return true;
                }
                Log.w((String)"MID", (String)"Network error is not exist");
                return false;
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MID", (String)"isNetworkAvailable error", (Throwable)throwable);
        }
        if (++errorCount <= 5) {
            return true;
        }
        if (errorCount < 10) {
            return false;
        }
        if (errorCount >= 10) {
            errorCount = 0;
        }
        return false;
    }

    public static String md5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuffer.append(byArray[i2]);
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    public static void jsonPut(JSONObject jSONObject, String string, String string2) {
        if (Util.isStringValid(string2)) {
            jSONObject.put(string, (Object)string2);
        }
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 8) {
            return string;
        }
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = Base64.decode((byte[])byArray, (int)0);
            byArray2 = g.b(byArray2);
            return new String(byArray2, "UTF-8").trim().replace("\t", "").replace("\n", "").replace("\r", "");
        }
        catch (Throwable throwable) {
            Log.e((String)"MID", (String)"decode error", (Throwable)throwable);
            return string;
        }
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 8) {
            return string;
        }
        try {
            byte[] byArray = g.a(string.getBytes("UTF-8"));
            byte[] byArray2 = Base64.encode((byte[])byArray, (int)0);
            return new String(byArray2, "UTF-8").trim().replace("\t", "").replace("\n", "").replace("\r", "");
        }
        catch (Throwable throwable) {
            Log.e((String)"MID", (String)"encode error", (Throwable)throwable);
            return string;
        }
    }

    public static String getImei(Context context) {
        String string = "";
        try {
            if (Util.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                string = telephonyManager.getDeviceId();
                if (string != null) {
                    return string;
                }
            } else {
                a.d("Could not get permission of android.permission.READ_PHONE_STATE");
            }
        }
        catch (Throwable throwable) {
            a.d("get device id error:" + throwable.toString());
        }
        return string != null ? string : "";
    }

    public static String getImsi(Context context) {
        String string = "";
        try {
            if (Util.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                string = telephonyManager.getSubscriberId();
                if (telephonyManager != null) {
                    return string;
                }
            } else {
                a.d("Could not get permission of android.permission.READ_PHONE_STATE");
            }
        }
        catch (Throwable throwable) {
            a.d("get subscriber id error:" + throwable.toString());
        }
        return string != null ? string : "";
    }

    public static String getWifiMacAddress(Context context) {
        String string = "";
        if (Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            try {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager == null) {
                    return "";
                }
                string = wifiManager.getConnectionInfo().getMacAddress();
            }
            catch (Exception exception) {
                a.d("get wifi address error" + exception);
                return "";
            }
        } else {
            a.d("Could not get permission of android.permission.ACCESS_WIFI_STATE");
        }
        return string != null ? string : "";
    }

    public static HttpHost getHttpProxy() {
        if (Proxy.getDefaultHost() != null) {
            return new HttpHost(Proxy.getDefaultHost(), Proxy.getDefaultPort());
        }
        return null;
    }

    public static HttpHost getHttpProxy(Context context) {
        if (null == context) {
            return null;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName()) != 0) {
                return null;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return null;
            }
            if (networkInfo.getTypeName() != null && networkInfo.getTypeName().equalsIgnoreCase("WIFI")) {
                return null;
            }
            String string = networkInfo.getExtraInfo();
            if (string == null) {
                return null;
            }
            if (string.equals("cmwap") || string.equals("3gwap") || string.equals("uniwap")) {
                return new HttpHost("10.0.0.172", 80);
            }
            if (string.equals("ctwap")) {
                return new HttpHost("10.0.0.200", 80);
            }
        }
        catch (Throwable throwable) {
            a.f(throwable);
        }
        return null;
    }

    public static byte[] deocdeGZipContent(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        int n2 = 0;
        while ((n2 = gZIPInputStream.read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n2);
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        byteArrayInputStream.close();
        gZIPInputStream.close();
        byteArrayOutputStream.close();
        return byArray3;
    }

    public static String getHttpAddr(Context context) {
        return "http://" + com.tencent.mid.util.b.a(context).c();
    }

    public static byte[] getHMAC(String string, String string2) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(string.getBytes(), "hmacmd5");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKeySpec);
            mac.update(string2.getBytes());
            return mac.doFinal();
        }
        catch (Exception exception) {
            a.b(exception);
            return null;
        }
    }

    private static synchronized Random a() {
        if (null == b) {
            b = new Random();
        }
        return b;
    }

    public static int getRandInt() {
        return Util.a().nextInt(Integer.MAX_VALUE);
    }

    public static String bytesToStr(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(byArray[i2] + "");
        }
        return stringBuffer.toString();
    }

    public static byte[] strToBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        return byArray;
    }

    public static WifiInfo getWifiInfo(Context context) {
        Context context2;
        WifiManager wifiManager;
        if (Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE") && (wifiManager = (WifiManager)(context2 = context.getApplicationContext()).getSystemService("wifi")) != null) {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            return wifiInfo;
        }
        return null;
    }

    public static String getWiFiBBSID(Context context) {
        try {
            WifiInfo wifiInfo = Util.getWifiInfo(context);
            if (wifiInfo != null) {
                return wifiInfo.getBSSID();
            }
        }
        catch (Throwable throwable) {
            a.d(throwable.toString());
        }
        return null;
    }

    public static String getWiFiSSID(Context context) {
        try {
            WifiInfo wifiInfo = Util.getWifiInfo(context);
            if (wifiInfo != null) {
                return wifiInfo.getSSID();
            }
        }
        catch (Throwable throwable) {
            a.d(throwable.toString());
        }
        return null;
    }

    public static JSONArray getWifiTopN(Context context, int n2) {
        try {
            if (!MidService.isEnableReportWifiList()) {
                return null;
            }
            if (Util.checkPermission(context, "android.permission.INTERNET") && Util.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                List list;
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager != null && (list = wifiManager.getScanResults()) != null && list.size() > 0) {
                    Collections.sort(list, new o());
                    JSONArray jSONArray = new JSONArray();
                    for (int i2 = 0; i2 < list.size() && i2 < n2; ++i2) {
                        ScanResult scanResult = (ScanResult)list.get(i2);
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put("bs", (Object)scanResult.BSSID);
                        jSONObject.put("ss", (Object)scanResult.SSID);
                        jSONArray.put((Object)jSONObject);
                    }
                    return jSONArray;
                }
            } else {
                a.d("can not get the permisson of android.permission.INTERNET");
            }
        }
        catch (Throwable throwable) {
            a.d(throwable.toString());
        }
        return null;
    }

    public static JSONArray getSensors(Context context) {
        try {
            List list;
            SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
            if (sensorManager != null && (list = sensorManager.getSensorList(-1)) != null && list.size() > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Sensor sensor = (Sensor)list.get(i2);
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("name", (Object)sensor.getName());
                    jSONObject.put("vendor", (Object)sensor.getVendor());
                    jSONArray.put((Object)jSONObject);
                }
                return jSONArray;
            }
        }
        catch (Throwable throwable) {
            a.d(throwable.toString());
        }
        return null;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static JSONArray queryMids(Context context, int n2) {
        void var6_12;
        String string;
        Map<String, MidEntity> map;
        a.h("queryMids, midType=" + n2);
        JSONArray jSONArray = new JSONArray();
        int n3 = 2;
        if (n2 == 2) {
            n3 = 3;
        }
        if ((map = Util.getMidsByApps(context, n3)) != null && map.size() > 0) {
            for (Map.Entry object2 : map.entrySet()) {
                string = (String)object2.getKey();
                MidEntity midEntity = (MidEntity)object2.getValue();
                if (midEntity == null || !midEntity.isMidValid()) continue;
                try {
                    JSONObject jSONObject = Util.a(midEntity);
                    jSONObject.put("loc", (Object)"priv");
                    if (string.equals(context.getPackageName())) {
                        jSONObject.put("app", 1);
                    }
                    jSONObject.put("pkg", (Object)string);
                    jSONArray.put((Object)jSONObject);
                }
                catch (Exception exception) {}
            }
        }
        Object object3 = null;
        object3 = n2 == 2 ? com.tencent.mid.b.g.a(context).d() : com.tencent.mid.b.g.a(context).j();
        a.b("settingEntity:" + object3);
        if (object3 != null && ((MidEntity)object3).isMidValid()) {
            try {
                JSONObject jSONObject = Util.a((MidEntity)object3);
                jSONObject.put("loc", (Object)"pub");
                jSONObject.put("lc", (Object)"set");
                jSONArray.put((Object)jSONObject);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        Object var6_9 = null;
        if (n2 == 2) {
            MidEntity midEntity = com.tencent.mid.b.g.a(context).e();
        } else {
            MidEntity midEntity = com.tencent.mid.b.g.a(context).k();
        }
        a.b("sdCardEntity:" + var6_12);
        if (var6_12 != null && var6_12.isMidValid()) {
            try {
                string = Util.a((MidEntity)var6_12);
                string.put("loc", (Object)"pub");
                string.put("lc", (Object)"sd");
                jSONArray.put((Object)string);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONArray;
    }

    private static JSONObject a(MidEntity midEntity) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("mid", (Object)midEntity.getMid());
        jSONObject.put("ts", midEntity.getTimestamps() / 1000L);
        return jSONObject;
    }

    public static String getPackageAuth(String string) {
        return "content://" + Util.getPackageAuthName(string);
    }

    public static String getPackageAuthName(String string) {
        return string + ".TENCENT.MID.V3";
    }

    public static Map<String, MidEntity> getMidsByApps(Context context, int n2) {
        p p2 = new p(context, n2);
        Thread thread = new Thread(p2);
        thread.start();
        try {
            thread.join(3500L);
        }
        catch (Throwable throwable) {
            a.d(throwable.toString());
        }
        Map<String, MidEntity> map = p2.a();
        return map;
    }

    private static Map<String, MidEntity> b(Context context, int n2) {
        HashMap<String, MidEntity> hashMap = new HashMap<String, MidEntity>(4);
        Map<String, ProviderInfo> map = Util.queryMatchContentProviders(context);
        Log.i((String)"MID", (String)(">>>   queryMatchContentProviders size:" + (map != null ? map.size() : 0)));
        MidEntity midEntity = null;
        if (n2 == 2) {
            midEntity = com.tencent.mid.b.g.a(context).i();
        } else if (n2 == 3) {
            midEntity = com.tencent.mid.b.g.a(context).c();
        }
        if (Util.isMidValid(midEntity)) {
            hashMap.put(context.getPackageName(), midEntity);
        }
        if (map == null || map.size() == 0) {
            return hashMap;
        }
        if (null != lastOtherMidMap && !lastOtherMidMap.isEmpty() && Math.abs(System.currentTimeMillis() - lastGetOtherMidMapTime) < 1000L) {
            Log.d((String)"MID", (String)(">>> use lastOtherMidMap size:" + lastOtherMidMap.size() + ",content:"));
            return lastOtherMidMap;
        }
        for (String object : map.keySet()) {
            try {
                MidEntity midEntity2;
                if (object.equals(context.getPackageName())) continue;
                String string = Util.getPackageAuth(object) + "/" + n2;
                Log.d((String)"MID", (String)(">>>   read mid from other providrt cmd:" + string));
                String string2 = context.getContentResolver().getType(Uri.parse((String)string));
                Log.d((String)"MID", (String)(">>>   mid cmd:" + string + ", return:" + string2));
                if (Util.isEmpty(string2) || (midEntity2 = MidEntity.parse(string2)) == null || !midEntity2.isMidValid()) continue;
                hashMap.put(object, midEntity2);
            }
            catch (Throwable throwable) {
                a.f(throwable);
            }
        }
        lastOtherMidMap = hashMap;
        lastGetOtherMidMapTime = System.currentTimeMillis();
        Log.d((String)"MID", (String)(">>>   appPrivateMidMap size:" + hashMap.size() + ",content:"));
        for (Map.Entry entry : hashMap.entrySet()) {
            Log.w((String)"MID", (String)(">>>   pkg:" + (String)entry.getKey() + ",midEntity:" + ((MidEntity)entry.getValue()).toString()));
        }
        return hashMap;
    }

    public static void insertMid2Provider(Context context, String string, String string2) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("mid", string2);
            context.getContentResolver().insert(Uri.parse((String)(Util.getPackageAuth(string) + "/" + 10)), contentValues);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void insertMid2OldProvider(Context context, String string, String string2) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("mid", string2);
            context.getContentResolver().insert(Uri.parse((String)(Util.getPackageAuth(string) + "/" + 11)), contentValues);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Map<String, ProviderInfo> queryMatchContentProviders(Context context) {
        HashMap<String, ProviderInfo> hashMap = new HashMap<String, ProviderInfo>();
        List list = context.getPackageManager().queryContentProviders(null, 0, 0);
        for (ProviderInfo providerInfo : list) {
            if (!providerInfo.name.equals(MidProvider.class.getName()) || !providerInfo.authority.equals(Util.getPackageAuthName(providerInfo.packageName))) continue;
            hashMap.put(providerInfo.packageName, providerInfo);
        }
        return hashMap;
    }

    public static void updateIfLocalInvalid(Context context, String string) {
        if (Util.isMidValid(string)) {
            MidEntity midEntity = new MidEntity();
            midEntity.setImei(Util.getImei(context));
            midEntity.setMac(Util.getWifiMacAddress(context));
            midEntity.setMid(string);
            midEntity.setTimestamps(System.currentTimeMillis());
            com.tencent.mid.b.g.a(context).f(midEntity);
        }
    }

    public static String getDateString(int n2) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.roll(6, n2);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            String string = simpleDateFormat.format(calendar.getTime());
            return string;
        }
        catch (Throwable throwable) {
            return "00";
        }
    }

    public static Map<String, ProviderInfo> getLocalXGAppList(Context context) {
        HashMap<String, ProviderInfo> hashMap = new HashMap<String, ProviderInfo>();
        List list = context.getPackageManager().queryContentProviders(null, 0, 0);
        for (ProviderInfo providerInfo : list) {
            if (!providerInfo.name.equals("com.tencent.android.tpush.XGPushProvider") || !providerInfo.authority.equals(Util.getProviderAuth(providerInfo.packageName))) continue;
            hashMap.put(providerInfo.packageName, providerInfo);
            Log.d((String)"MID.XG", (String)(providerInfo.authority + "," + providerInfo.packageName + "," + providerInfo.name));
        }
        return hashMap;
    }

    public static String getProviderAuth(String string) {
        return string + ".AUTH_XGPUSH";
    }

    public static String getToken(Context context, String string) {
        Uri uri = Uri.parse((String)("content://" + string + ".AUTH_XGPUSH" + "/" + "tokenByMid"));
        String string2 = context.getContentResolver().getType(uri);
        if (string2 != null) {
            try {
                string2 = new String(Base64.decode((byte[])string2.getBytes(), (int)0), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        Log.i((String)"MID.XG", (String)("get token from pkg:" + string + ", token:" + string2));
        if (string2 != null && string2.trim().length() == 40) {
            return string2;
        }
        return null;
    }

    public static Map<String, Integer> queryAllToken(Context context) {
        Map<String, ProviderInfo> map = Util.getLocalXGAppList(context);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (map == null || map.size() == 0) {
            return hashMap;
        }
        for (String string : map.keySet()) {
            String string2 = Util.getToken(context, string);
            if (!Util.isMidValid(string2)) continue;
            Integer n2 = (Integer)hashMap.get(string2);
            if (n2 == null) {
                hashMap.put(string2, 1);
                continue;
            }
            hashMap.put(string2, n2 + 1);
        }
        return hashMap;
    }

    public static String selectMaxCountXgAppToken(Context context) {
        Map<String, Integer> map = Util.queryAllToken(context);
        if (map != null && map.size() > 0) {
            int n2 = 0;
            String string = null;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() <= n2) continue;
                n2 = entry.getValue();
                string = entry.getKey();
            }
            return string;
        }
        return null;
    }

    static /* synthetic */ Map a(Context context, int n2) {
        return Util.b(context, n2);
    }
}

