/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.MTAProxy;
import com.tencent.cos.xml.SimpleCosXml;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.AbortMultiUploadResult;
import com.tencent.cos.xml.model.object.AppendObjectRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.CopyObjectRequest;
import com.tencent.cos.xml.model.object.CopyObjectResult;
import com.tencent.cos.xml.model.object.DeleteObjectRequest;
import com.tencent.cos.xml.model.object.DeleteObjectResult;
import com.tencent.cos.xml.model.object.GetObjectBytesRequest;
import com.tencent.cos.xml.model.object.GetObjectBytesResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.PostObjectRequest;
import com.tencent.cos.xml.model.object.PostObjectResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartCopyRequest;
import com.tencent.cos.xml.model.object.UploadPartCopyResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.transfer.ResponseBytesConverter;
import com.tencent.cos.xml.transfer.ResponseFileBodySerializer;
import com.tencent.cos.xml.transfer.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.utils.URLEncodeUtils;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.auth.SignerFactory;
import com.tencent.qcloud.core.auth.StaticCredentialProvider;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.logger.FileLogAdapter;
import com.tencent.qcloud.core.logger.LogAdapter;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.RetryStrategy;
import java.net.UnknownHostException;
import java.util.List;

public class CosXmlSimpleService
implements SimpleCosXml {
    protected QCloudHttpClient client;
    protected QCloudCredentialProvider credentialProvider;
    protected String scheme;
    protected String region;
    protected String appid;
    protected String ip;
    protected String domainSuffix;
    protected String tag = "CosXml";
    protected String signerType = "CosXmlSigner";
    public static String appCachePath;
    protected CosXmlServiceConfig config;

    public CosXmlSimpleService(Context context, CosXmlServiceConfig configuration, QCloudCredentialProvider qCloudCredentialProvider) {
        QCloudLogger.addAdapter((LogAdapter)new FileLogAdapter(context, "QLog"));
        MTAProxy.init(context.getApplicationContext());
        appCachePath = context.getApplicationContext().getFilesDir().getPath();
        RetryStrategy retryStrategy = configuration.getRetryStrategy();
        this.client = retryStrategy != null ? new QCloudHttpClient.Builder().setRetryStrategy(retryStrategy).build() : QCloudHttpClient.getDefault();
        this.config = configuration;
        this.client.addVerifiedHost("*." + configuration.getDomainSuffix());
        this.client.setDebuggable(configuration.isDebuggable());
        this.scheme = configuration.getProtocol();
        this.region = configuration.getRegion();
        this.domainSuffix = configuration.getDomainSuffix();
        this.appid = configuration.getAppid();
        this.ip = configuration.getIp();
        this.credentialProvider = qCloudCredentialProvider;
    }

    public CosXmlSimpleService(Context context, CosXmlServiceConfig configuration, QCloudSigner qCloudSigner) {
        QCloudLogger.addAdapter((LogAdapter)new FileLogAdapter(context, "QLog"));
        appCachePath = context.getApplicationContext().getFilesDir().getPath();
        RetryStrategy retryStrategy = configuration.getRetryStrategy();
        this.client = retryStrategy != null ? new QCloudHttpClient.Builder().setRetryStrategy(retryStrategy).build() : QCloudHttpClient.getDefault();
        this.config = configuration;
        this.client.addVerifiedHost("*." + configuration.getDomainSuffix());
        this.client.setDebuggable(configuration.isDebuggable());
        this.scheme = configuration.getProtocol();
        this.region = configuration.getRegion();
        this.domainSuffix = configuration.getDomainSuffix();
        this.appid = configuration.getAppid();
        this.ip = configuration.getIp();
        this.credentialProvider = new StaticCredentialProvider(null);
        this.signerType = "UserCosXmlSigner";
        SignerFactory.registerSigner((String)this.signerType, qCloudSigner.getClass());
    }

    public void addCustomerDNS(String domainName, String[] ipList) throws CosXmlClientException {
        try {
            this.client.addDnsRecord(domainName, ipList);
        }
        catch (UnknownHostException e) {
            throw new CosXmlClientException(e);
        }
    }

    public void addVerifiedHost(String hostName) {
        this.client.addVerifiedHost(hostName);
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> QCloudHttpRequest buildHttpRequest(T1 cosXmlRequest, T2 cosXmlResult) throws CosXmlClientException {
        cosXmlRequest.checkParameters();
        String host = cosXmlRequest.getHost(this.config, cosXmlRequest.isSupportAccelerate());
        QCloudHttpRequest.Builder httpRequestBuilder = new QCloudHttpRequest.Builder().method(cosXmlRequest.getMethod()).scheme(this.scheme).host(this.ip == null ? host : this.ip).path(cosXmlRequest.getPath(this.config)).addHeader("Host", host).userAgent(CosXmlServiceConfig.DEFAULT_USER_AGENT).tag((Object)this.tag);
        if (this.credentialProvider == null) {
            httpRequestBuilder.signer(null, null);
        } else if (cosXmlRequest instanceof PostObjectRequest) {
            httpRequestBuilder.signer(null, null);
            QCloudLifecycleCredentials qCloudLifecycleCredentials = null;
            try {
                qCloudLifecycleCredentials = (QCloudLifecycleCredentials)this.credentialProvider.getCredentials();
                if (TextUtils.isEmpty((CharSequence)qCloudLifecycleCredentials.getSecretId()) || TextUtils.isEmpty((CharSequence)qCloudLifecycleCredentials.getSignKey()) || TextUtils.isEmpty((CharSequence)qCloudLifecycleCredentials.getKeyTime())) {
                    throw new CosXmlClientException("invalid credential provider");
                }
            }
            catch (QCloudClientException e) {
                throw new CosXmlClientException(e);
            }
            ((PostObjectRequest)cosXmlRequest).setSecretIdAndKey(qCloudLifecycleCredentials.getSecretId(), qCloudLifecycleCredentials.getSignKey(), qCloudLifecycleCredentials.getKeyTime());
            if (this.credentialProvider instanceof SessionQCloudCredentials) {
                SessionQCloudCredentials sessionQCloudCredentials = (SessionQCloudCredentials)this.credentialProvider;
                httpRequestBuilder.addHeader("x-cos-security-token", sessionQCloudCredentials.getToken());
            }
        } else {
            httpRequestBuilder.signer(this.signerType, cosXmlRequest.getSignSourceProvider());
        }
        httpRequestBuilder.query(cosXmlRequest.getQueryString());
        httpRequestBuilder.addHeaders(cosXmlRequest.getRequestHeaders());
        if (cosXmlRequest.isNeedMD5()) {
            httpRequestBuilder.contentMD5();
        }
        if (cosXmlRequest.getRequestBody() != null) {
            httpRequestBuilder.body(cosXmlRequest.getRequestBody());
        }
        if (cosXmlRequest instanceof GetObjectRequest) {
            String absolutePath = ((GetObjectRequest)cosXmlRequest).getDownloadPath();
            httpRequestBuilder.converter(new ResponseFileBodySerializer((GetObjectResult)cosXmlResult, absolutePath, ((GetObjectRequest)cosXmlRequest).getFileOffset()));
        } else if (cosXmlRequest instanceof GetObjectBytesRequest) {
            httpRequestBuilder.converter(new ResponseBytesConverter((GetObjectBytesResult)cosXmlResult));
        } else {
            httpRequestBuilder.converter(new ResponseXmlS3BodySerializer(cosXmlResult));
        }
        QCloudHttpRequest httpRequest = httpRequestBuilder.build();
        return httpRequest;
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> T2 execute(T1 cosXmlRequest, T2 cosXmlResult) throws CosXmlClientException, CosXmlServiceException {
        try {
            QCloudHttpRequest httpRequest = this.buildHttpRequest(cosXmlRequest, cosXmlResult);
            HttpTask httpTask = cosXmlRequest instanceof PostObjectRequest ? this.client.resolveRequest(httpRequest, null) : this.client.resolveRequest(httpRequest, this.credentialProvider);
            cosXmlRequest.setTask(httpTask);
            httpTask.addStateListener(cosXmlRequest.getTaskStateListener());
            if (cosXmlRequest instanceof AppendObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((AppendObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PutObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PutObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof UploadPartRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((UploadPartRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof GetObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((GetObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PostObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PostObjectRequest)cosXmlRequest).getProgressListener());
            }
            HttpResult httpResult = (HttpResult)httpTask.executeNow();
            return (T2)(httpResult != null ? (CosXmlResult)httpResult.content() : null);
        }
        catch (QCloudServiceException e) {
            throw (CosXmlServiceException)e;
        }
        catch (QCloudClientException e) {
            throw new CosXmlClientException(e);
        }
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> void schedule(final T1 cosXmlRequest, T2 cosXmlResult, final CosXmlResultListener cosXmlResultListener) {
        QCloudResultListener qCloudResultListener = new QCloudResultListener<HttpResult<T2>>(){

            public void onSuccess(HttpResult<T2> result) {
                cosXmlResultListener.onSuccess(cosXmlRequest, (CosXmlResult)result.content());
            }

            public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                if (clientException != null) {
                    cosXmlResultListener.onFail(cosXmlRequest, new CosXmlClientException((Throwable)clientException), null);
                } else {
                    cosXmlResultListener.onFail(cosXmlRequest, null, (CosXmlServiceException)serviceException);
                }
            }
        };
        try {
            QCloudHttpRequest httpRequest = this.buildHttpRequest(cosXmlRequest, cosXmlResult);
            HttpTask httpTask = cosXmlRequest instanceof PostObjectRequest ? this.client.resolveRequest(httpRequest, null) : this.client.resolveRequest(httpRequest, this.credentialProvider);
            cosXmlRequest.setTask(httpTask);
            httpTask.addStateListener(cosXmlRequest.getTaskStateListener());
            if (cosXmlRequest instanceof AppendObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((AppendObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PutObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PutObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof UploadPartRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((UploadPartRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof GetObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((GetObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PostObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PostObjectRequest)cosXmlRequest).getProgressListener());
            }
            httpTask.schedule().addResultListener(qCloudResultListener);
        }
        catch (QCloudClientException e) {
            cosXmlResultListener.onFail(cosXmlRequest, new CosXmlClientException(e), null);
        }
    }

    public String getAccessUrl(CosXmlRequest cosXmlRequest) {
        String host = null;
        try {
            host = cosXmlRequest.getHost(this.config, false);
        }
        catch (CosXmlClientException e) {
            e.printStackTrace();
        }
        String path = cosXmlRequest.getPath(this.config);
        try {
            path = URLEncodeUtils.cosPathEncode(cosXmlRequest.getPath(this.config));
        }
        catch (CosXmlClientException cosXmlClientException) {
            // empty catch block
        }
        return host + path;
    }

    @Override
    public InitMultipartUploadResult initMultipartUpload(InitMultipartUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        System.out.println("initMultipartUpload");
        return this.execute(request, new InitMultipartUploadResult());
    }

    @Override
    public void initMultipartUploadAsync(InitMultipartUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new InitMultipartUploadResult(), cosXmlResultListener);
    }

    @Override
    public ListPartsResult listParts(ListPartsRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new ListPartsResult());
    }

    @Override
    public void listPartsAsync(ListPartsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new ListPartsResult(), cosXmlResultListener);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new UploadPartResult());
    }

    @Override
    public void uploadPartAsync(UploadPartRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new UploadPartResult(), cosXmlResultListener);
    }

    @Override
    public AbortMultiUploadResult abortMultiUpload(AbortMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new AbortMultiUploadResult());
    }

    @Override
    public void abortMultiUploadAsync(AbortMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new AbortMultiUploadResult(), cosXmlResultListener);
    }

    @Override
    public CompleteMultiUploadResult completeMultiUpload(CompleteMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        CompleteMultiUploadResult completeMultiUploadResult = new CompleteMultiUploadResult();
        completeMultiUploadResult.accessUrl = this.getAccessUrl(request);
        return this.execute(request, completeMultiUploadResult);
    }

    @Override
    public void completeMultiUploadAsync(CompleteMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        CompleteMultiUploadResult completeMultiUploadResult = new CompleteMultiUploadResult();
        completeMultiUploadResult.accessUrl = this.getAccessUrl(request);
        this.schedule(request, completeMultiUploadResult, cosXmlResultListener);
    }

    @Override
    public DeleteObjectResult deleteObject(DeleteObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new DeleteObjectResult());
    }

    @Override
    public void deleteObjectAsync(DeleteObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new DeleteObjectResult(), cosXmlResultListener);
    }

    @Override
    public GetObjectResult getObject(GetObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetObjectResult());
    }

    @Override
    public void getObjectAsync(GetObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetObjectResult(), cosXmlResultListener);
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.accessUrl = this.getAccessUrl(request);
        return this.execute(request, putObjectResult);
    }

    @Override
    public void putObjectAsync(PutObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.accessUrl = this.getAccessUrl(request);
        this.schedule(request, putObjectResult, cosXmlResultListener);
    }

    @Override
    public PostObjectResult postObject(PostObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        PostObjectResult postObjectResult = new PostObjectResult();
        return this.execute(request, postObjectResult);
    }

    @Override
    public void postObjectAsync(PostObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        PostObjectResult postObjectResult = new PostObjectResult();
        this.schedule(request, postObjectResult, cosXmlResultListener);
    }

    @Override
    public byte[] getObject(String bucketName, String objectName) throws CosXmlClientException, CosXmlServiceException {
        GetObjectBytesRequest getObjectBytesRequest = new GetObjectBytesRequest(bucketName, objectName);
        GetObjectBytesResult getObjectBytesResult = this.execute(getObjectBytesRequest, new GetObjectBytesResult());
        return getObjectBytesResult != null ? getObjectBytesResult.data : new byte[]{};
    }

    @Override
    public HeadObjectResult headObject(HeadObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new HeadObjectResult());
    }

    @Override
    public void headObjectAsync(HeadObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new HeadObjectResult(), cosXmlResultListener);
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new CopyObjectResult());
    }

    @Override
    public void copyObjectAsync(CopyObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new CopyObjectResult(), cosXmlResultListener);
    }

    @Override
    public UploadPartCopyResult copyObject(UploadPartCopyRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new UploadPartCopyResult());
    }

    @Override
    public void copyObjectAsync(UploadPartCopyRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new UploadPartCopyResult(), cosXmlResultListener);
    }

    @Override
    public void cancel(CosXmlRequest cosXmlRequest) {
        if (cosXmlRequest != null && cosXmlRequest.getHttpTask() != null) {
            cosXmlRequest.getHttpTask().cancel();
        }
    }

    @Override
    public void cancelAll() {
        List tasks = this.client.getTasksByTag(this.tag);
        for (HttpTask task : tasks) {
            task.cancel();
        }
    }

    @Override
    public void release() {
        this.cancelAll();
    }

    public String getAppid() {
        return this.appid;
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    public String getRegion(CosXmlRequest cosXmlRequest) {
        return cosXmlRequest.getRegion() == null ? this.region : cosXmlRequest.getRegion();
    }

    public CosXmlServiceConfig getConfig() {
        return this.config;
    }
}

